/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.internals;

import com.ctrip.framework.apollo.build.ApolloInjector;
import com.ctrip.framework.apollo.core.dto.ApolloConfigNotification;
import com.ctrip.framework.apollo.core.dto.ApolloNotificationMessages;
import com.ctrip.framework.apollo.core.dto.ServiceDTO;
import com.ctrip.framework.apollo.core.enums.ConfigFileFormat;
import com.ctrip.framework.apollo.core.schedule.ExponentialSchedulePolicy;
import com.ctrip.framework.apollo.core.schedule.SchedulePolicy;
import com.ctrip.framework.apollo.core.signature.Signature;
import com.ctrip.framework.apollo.core.utils.ApolloThreadFactory;
import com.ctrip.framework.apollo.core.utils.StringUtils;
import com.ctrip.framework.apollo.exceptions.ApolloConfigException;
import com.ctrip.framework.apollo.internals.ConfigServiceLocator;
import com.ctrip.framework.apollo.internals.RemoteConfigRepository;
import com.ctrip.framework.apollo.spi.ConfigServiceLoadBalancerClient;
import com.ctrip.framework.apollo.tracer.Tracer;
import com.ctrip.framework.apollo.tracer.spi.Transaction;
import com.ctrip.framework.apollo.util.ConfigUtil;
import com.ctrip.framework.apollo.util.ExceptionUtil;
import com.ctrip.framework.apollo.util.http.HttpClient;
import com.ctrip.framework.apollo.util.http.HttpRequest;
import com.ctrip.framework.apollo.util.http.HttpResponse;
import com.ctrip.framework.foundation.internals.ServiceBootstrap;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.RateLimiter;
import com.google.gson.Gson;
import java.lang.reflect.Type;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteConfigLongPollService {
    private static final Logger logger = LoggerFactory.getLogger(RemoteConfigLongPollService.class);
    private static final Joiner STRING_JOINER = Joiner.on((String)"+");
    private static final Joiner.MapJoiner MAP_JOINER = Joiner.on((String)"&").withKeyValueSeparator("=");
    private static final Escaper queryParamEscaper = UrlEscapers.urlFormParameterEscaper();
    private static final long INIT_NOTIFICATION_ID = -1L;
    private static final int LONG_POLLING_READ_TIMEOUT = 90000;
    private final ExecutorService m_longPollingService;
    private final AtomicBoolean m_longPollingStopped;
    private SchedulePolicy m_longPollFailSchedulePolicyInSecond;
    private RateLimiter m_longPollRateLimiter;
    private final ConcurrentMap<String, Boolean> m_longPollStarted;
    private final Map<String, Multimap<String, RemoteConfigRepository>> m_longPollNamespaces;
    private final Table<String, String, Long> m_notifications;
    private final Map<String, ApolloNotificationMessages> m_remoteNotificationMessages;
    private Type m_responseType;
    private static final Gson GSON = new Gson();
    private ConfigUtil m_configUtil;
    private HttpClient m_httpClient;
    private ConfigServiceLocator m_serviceLocator;
    private final ConfigServiceLoadBalancerClient configServiceLoadBalancerClient = (ConfigServiceLoadBalancerClient)ServiceBootstrap.loadPrimary(ConfigServiceLoadBalancerClient.class);

    public RemoteConfigLongPollService() {
        this.m_longPollFailSchedulePolicyInSecond = new ExponentialSchedulePolicy(1L, 120L);
        this.m_longPollingStopped = new AtomicBoolean(false);
        this.m_longPollingService = Executors.newCachedThreadPool(ApolloThreadFactory.create((String)"RemoteConfigLongPollService", (boolean)true));
        this.m_longPollStarted = new ConcurrentHashMap<String, Boolean>();
        this.m_longPollNamespaces = Maps.newConcurrentMap();
        this.m_notifications = Tables.synchronizedTable((Table)HashBasedTable.create());
        this.m_remoteNotificationMessages = Maps.newConcurrentMap();
        this.m_responseType = new TypeToken<List<ApolloConfigNotification>>(){}.getType();
        this.m_configUtil = ApolloInjector.getInstance(ConfigUtil.class);
        this.m_httpClient = ApolloInjector.getInstance(HttpClient.class);
        this.m_serviceLocator = ApolloInjector.getInstance(ConfigServiceLocator.class);
        this.m_longPollRateLimiter = RateLimiter.create((double)this.m_configUtil.getLongPollQPS());
    }

    public boolean submit(String appId, String namespace, RemoteConfigRepository remoteConfigRepository) {
        Multimap repositoryMultimap = this.m_longPollNamespaces.computeIfAbsent(appId, k -> Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create()));
        boolean result = repositoryMultimap.put((Object)namespace, (Object)remoteConfigRepository);
        this.m_notifications.put((Object)appId, (Object)namespace, (Object)-1L);
        if (this.m_longPollStarted.get(appId) == null) {
            this.startLongPolling(appId);
        }
        return result;
    }

    private void startLongPolling(String sysAppId) {
        if (Boolean.TRUE.equals(this.m_longPollStarted.putIfAbsent(sysAppId, true))) {
            return;
        }
        try {
            final String appId = sysAppId;
            final String cluster = this.m_configUtil.getCluster();
            final String dataCenter = this.m_configUtil.getDataCenter();
            final String secret = this.m_configUtil.getAccessKeySecret(appId);
            final long longPollingInitialDelayInMills = this.m_configUtil.getLongPollingInitialDelayInMills();
            this.m_longPollingService.submit(new Runnable(){

                @Override
                public void run() {
                    if (longPollingInitialDelayInMills > 0L) {
                        try {
                            logger.debug("Long polling will start in {} ms.", (Object)longPollingInitialDelayInMills);
                            TimeUnit.MILLISECONDS.sleep(longPollingInitialDelayInMills);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    RemoteConfigLongPollService.this.doLongPollingRefresh(appId, cluster, dataCenter, secret);
                }
            });
        }
        catch (Throwable ex) {
            this.m_longPollStarted.remove(sysAppId);
            ApolloConfigException exception = new ApolloConfigException("Schedule long polling refresh failed", ex);
            Tracer.logError((Throwable)exception);
            logger.warn(ExceptionUtil.getDetailMessage(exception));
        }
    }

    void stopLongPollingRefresh() {
        this.m_longPollingStopped.compareAndSet(false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLongPollingRefresh(String appId, String cluster, String dataCenter, String secret) {
        ServiceDTO lastServiceDto = null;
        while (!this.m_longPollingStopped.get() && !Thread.currentThread().isInterrupted()) {
            if (!this.m_longPollRateLimiter.tryAcquire(5L, TimeUnit.SECONDS)) {
                try {
                    TimeUnit.SECONDS.sleep(5L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            Transaction transaction = Tracer.newTransaction((String)"Apollo.ConfigService", (String)"pollNotification");
            String url = null;
            try {
                if (lastServiceDto == null) {
                    lastServiceDto = this.resolveConfigService();
                }
                url = this.assembleLongPollRefreshUrl(lastServiceDto.getHomepageUrl(), appId, cluster, dataCenter, this.m_notifications.row((Object)appId));
                logger.debug("Long polling from {}", (Object)url);
                HttpRequest request = new HttpRequest(url);
                request.setReadTimeout(90000);
                if (!StringUtils.isBlank((String)secret)) {
                    Map headers = Signature.buildHttpHeaders((String)url, (String)appId, (String)secret);
                    request.setHeaders(headers);
                }
                transaction.addData("Url", (Object)url);
                HttpResponse response = this.m_httpClient.doGet(request, this.m_responseType);
                logger.debug("Long polling response: {}, url: {}", (Object)response.getStatusCode(), (Object)url);
                if (response.getStatusCode() == 200 && response.getBody() != null) {
                    this.updateNotifications(appId, (List)response.getBody());
                    this.updateRemoteNotifications((List)response.getBody());
                    transaction.addData("Result", (Object)((List)response.getBody()).toString());
                    this.notify(appId, lastServiceDto, (List)response.getBody());
                }
                if (response.getStatusCode() == 304 && ThreadLocalRandom.current().nextBoolean()) {
                    lastServiceDto = null;
                }
                this.m_longPollFailSchedulePolicyInSecond.success();
                transaction.addData("StatusCode", (Object)response.getStatusCode());
                transaction.setStatus("0");
            }
            catch (Throwable ex) {
                lastServiceDto = null;
                Tracer.logEvent((String)"ApolloConfigException", (String)ExceptionUtil.getDetailMessage(ex));
                transaction.setStatus(ex);
                long sleepTimeInSecond = this.m_longPollFailSchedulePolicyInSecond.fail();
                if (ex.getCause() instanceof SocketTimeoutException) {
                    Tracer.logEvent((String)"Apollo.Client.NamespaceTimeout", (String)this.assembleNamespaces(appId));
                }
                logger.warn("Long polling failed, will retry in {} seconds. appId: {}, cluster: {}, namespaces: {}, long polling url: {}, reason: {}", new Object[]{sleepTimeInSecond, appId, cluster, this.assembleNamespaces(appId), url, ExceptionUtil.getDetailMessage(ex)});
                try {
                    TimeUnit.SECONDS.sleep(sleepTimeInSecond);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            finally {
                transaction.complete();
            }
        }
    }

    private void notify(String appId, ServiceDTO lastServiceDto, List<ApolloConfigNotification> notifications) {
        if (notifications == null || notifications.isEmpty()) {
            return;
        }
        Multimap<String, RemoteConfigRepository> namespaceRepositories = this.m_longPollNamespaces.get(appId);
        if (namespaceRepositories == null) {
            return;
        }
        for (ApolloConfigNotification notification : notifications) {
            String namespaceName = notification.getNamespaceName();
            ArrayList toBeNotified = Lists.newArrayList((Iterable)namespaceRepositories.get((Object)namespaceName));
            ApolloNotificationMessages originalMessages = this.m_remoteNotificationMessages.get(namespaceName);
            ApolloNotificationMessages remoteMessages = originalMessages == null ? null : originalMessages.clone();
            toBeNotified.addAll(namespaceRepositories.get((Object)String.format("%s.%s", namespaceName, ConfigFileFormat.Properties.getValue())));
            for (RemoteConfigRepository remoteConfigRepository : toBeNotified) {
                try {
                    remoteConfigRepository.onLongPollNotified(lastServiceDto, remoteMessages);
                }
                catch (Throwable ex) {
                    Tracer.logError((Throwable)ex);
                }
            }
        }
    }

    private void updateNotifications(String appId, List<ApolloConfigNotification> deltaNotifications) {
        for (ApolloConfigNotification notification : deltaNotifications) {
            String namespaceNameWithPropertiesSuffix;
            if (Strings.isNullOrEmpty((String)notification.getNamespaceName())) continue;
            String namespaceName = notification.getNamespaceName();
            if (this.m_notifications.contains((Object)appId, (Object)namespaceName)) {
                this.m_notifications.put((Object)appId, (Object)namespaceName, (Object)notification.getNotificationId());
            }
            if (!this.m_notifications.contains((Object)appId, (Object)(namespaceNameWithPropertiesSuffix = String.format("%s.%s", namespaceName, ConfigFileFormat.Properties.getValue())))) continue;
            this.m_notifications.put((Object)appId, (Object)namespaceNameWithPropertiesSuffix, (Object)notification.getNotificationId());
        }
    }

    private void updateRemoteNotifications(List<ApolloConfigNotification> deltaNotifications) {
        for (ApolloConfigNotification notification : deltaNotifications) {
            if (Strings.isNullOrEmpty((String)notification.getNamespaceName()) || notification.getMessages() == null || notification.getMessages().isEmpty()) continue;
            ApolloNotificationMessages localRemoteMessages = this.m_remoteNotificationMessages.get(notification.getNamespaceName());
            if (localRemoteMessages == null) {
                localRemoteMessages = new ApolloNotificationMessages();
                this.m_remoteNotificationMessages.put(notification.getNamespaceName(), localRemoteMessages);
            }
            localRemoteMessages.mergeFrom(notification.getMessages());
        }
    }

    private String assembleNamespaces(String appId) {
        Multimap<String, RemoteConfigRepository> namespaceRepositories = this.m_longPollNamespaces.get(appId);
        if (namespaceRepositories == null) {
            return "";
        }
        return STRING_JOINER.join((Iterable)namespaceRepositories.keySet());
    }

    String assembleLongPollRefreshUrl(String uri, String appId, String cluster, String dataCenter, Map<String, Long> notificationsMap) {
        String localIp;
        HashMap queryParams = Maps.newHashMap();
        queryParams.put("appId", queryParamEscaper.escape(appId));
        queryParams.put("cluster", queryParamEscaper.escape(cluster));
        queryParams.put("notifications", queryParamEscaper.escape(this.assembleNotifications(notificationsMap)));
        if (!Strings.isNullOrEmpty((String)dataCenter)) {
            queryParams.put("dataCenter", queryParamEscaper.escape(dataCenter));
        }
        if (!Strings.isNullOrEmpty((String)(localIp = this.m_configUtil.getLocalIp()))) {
            queryParams.put("ip", queryParamEscaper.escape(localIp));
        }
        String params = MAP_JOINER.join((Map)queryParams);
        if (!uri.endsWith("/")) {
            uri = uri + "/";
        }
        return uri + "notifications/v2?" + params;
    }

    String assembleNotifications(Map<String, Long> notificationsMap) {
        ArrayList notifications = Lists.newArrayList();
        for (Map.Entry<String, Long> entry : notificationsMap.entrySet()) {
            ApolloConfigNotification notification = new ApolloConfigNotification(entry.getKey(), entry.getValue().longValue());
            notifications.add(notification);
        }
        return GSON.toJson((Object)notifications);
    }

    private ServiceDTO resolveConfigService() {
        List<ServiceDTO> configServices = this.getConfigServices();
        return this.configServiceLoadBalancerClient.chooseOneFrom(configServices);
    }

    private List<ServiceDTO> getConfigServices() {
        List<ServiceDTO> services = this.m_serviceLocator.getConfigServices();
        if (services.size() == 0) {
            throw new ApolloConfigException("No available config service");
        }
        return services;
    }
}

