/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.monitor.api;

import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;

public interface ApolloClientThreadPoolMonitorApi {
    public Map<String, ApolloThreadPoolInfo> getThreadPoolInfo();

    public ApolloThreadPoolInfo getRemoteConfigRepositoryThreadPoolInfo();

    public ApolloThreadPoolInfo getAbstractConfigThreadPoolInfo();

    public ApolloThreadPoolInfo getAbstractConfigFileThreadPoolInfo();

    public ApolloThreadPoolInfo getMetricsExporterThreadPoolInfo();

    public static class ApolloThreadPoolInfo {
        private ThreadPoolExecutor executor;

        public ApolloThreadPoolInfo(ThreadPoolExecutor executor) {
            this.executor = executor;
        }

        public ApolloThreadPoolInfo() {
        }

        public int getActiveTaskCount() {
            return this.executor != null ? this.executor.getActiveCount() : 0;
        }

        public int getQueueSize() {
            return this.executor != null ? this.executor.getQueue().size() : 0;
        }

        public int getCorePoolSize() {
            return this.executor != null ? this.executor.getCorePoolSize() : 0;
        }

        public int getMaximumPoolSize() {
            return this.executor != null ? this.executor.getMaximumPoolSize() : 0;
        }

        public int getPoolSize() {
            return this.executor != null ? this.executor.getPoolSize() : 0;
        }

        public long getTotalTaskCount() {
            return this.executor != null ? this.executor.getTaskCount() : 0L;
        }

        public long getCompletedTaskCount() {
            return this.executor != null ? this.executor.getCompletedTaskCount() : 0L;
        }

        public int getLargestPoolSize() {
            return this.executor != null ? this.executor.getLargestPoolSize() : 0;
        }

        public int getQueueRemainingCapacity() {
            return this.executor != null ? this.executor.getQueue().remainingCapacity() : 0;
        }
    }
}

