/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.monitor.internal.listener;

import com.ctrip.framework.apollo.monitor.internal.event.ApolloClientMonitorEvent;
import com.ctrip.framework.apollo.monitor.internal.listener.ApolloClientMonitorEventListener;
import com.ctrip.framework.apollo.monitor.internal.model.CounterModel;
import com.ctrip.framework.apollo.monitor.internal.model.GaugeModel;
import com.ctrip.framework.apollo.monitor.internal.model.SampleModel;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractApolloClientMonitorEventListener
implements ApolloClientMonitorEventListener {
    private final Map<String, CounterModel> counterSamples = Maps.newConcurrentMap();
    private final Map<String, GaugeModel> gaugeSamples = Maps.newConcurrentMap();
    private final AtomicBoolean isUpdated = new AtomicBoolean();
    private final String tag;

    public AbstractApolloClientMonitorEventListener(String tag) {
        this.tag = tag;
    }

    @Override
    public String getName() {
        return this.tag;
    }

    @Override
    public boolean isSupported(ApolloClientMonitorEvent event) {
        return this.tag.equals(event.getTag());
    }

    @Override
    public void collect(ApolloClientMonitorEvent event) {
        this.collect0(event);
        this.isUpdated.set(true);
    }

    @Override
    public boolean isMetricsSampleUpdated() {
        return this.isUpdated.getAndSet(false);
    }

    @Override
    public List<SampleModel> export() {
        this.export0();
        ArrayList<SampleModel> samples = new ArrayList<SampleModel>(this.counterSamples.values());
        samples.addAll(this.gaugeSamples.values());
        return samples;
    }

    protected void collect0(ApolloClientMonitorEvent event) {
    }

    protected void export0() {
    }

    public void createOrUpdateGaugeSample(String metricsName, String[] tagKeys, String[] tagValues, double value) {
        this.createOrUpdateSample(metricsName, tagKeys, tagValues, value, false);
    }

    public void createOrUpdateGaugeSample(String metricsName, double value) {
        this.createOrUpdateSample(metricsName, null, null, value, false);
    }

    public void createOrUpdateCounterSample(String metricsName, String[] tagKeys, String[] tagValues, double increaseValue) {
        this.createOrUpdateSample(metricsName, tagKeys, tagValues, increaseValue, true);
    }

    public void createOrUpdateCounterSample(String metricsName, double increaseValue) {
        this.createOrUpdateSample(metricsName, null, null, increaseValue, true);
    }

    private void createOrUpdateSample(String metricsName, String[] tagKeys, String[] tagValues, double value, boolean isCounter) {
        String mapKey = metricsName + (tagValues != null ? Arrays.toString(tagValues) : "");
        if (isCounter) {
            CounterModel counter = this.counterSamples.computeIfAbsent(mapKey, key -> (CounterModel)CounterModel.create(metricsName, 0.0).putTags(this.getTags(tagKeys, tagValues)));
            counter.increase(value);
        } else {
            GaugeModel gauge = this.gaugeSamples.computeIfAbsent(mapKey, key -> (GaugeModel)GaugeModel.create(metricsName, 0.0).putTags(this.getTags(tagKeys, tagValues)));
            gauge.setValue(value);
        }
    }

    private Map<String, String> getTags(String[] tagKeys, String[] tagValues) {
        if (tagKeys != null && tagValues != null && tagKeys.length == tagValues.length) {
            HashMap tags = Maps.newHashMap();
            for (int i = 0; i < tagKeys.length; ++i) {
                tags.put(tagKeys[i], tagValues[i]);
            }
            return tags;
        }
        return Collections.emptyMap();
    }
}

