/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.monitor.internal.listener.impl;

import com.ctrip.framework.apollo.Apollo;
import com.ctrip.framework.apollo.core.utils.DeferredLoggerFactory;
import com.ctrip.framework.apollo.core.utils.StringUtils;
import com.ctrip.framework.apollo.monitor.api.ApolloClientBootstrapArgsMonitorApi;
import com.ctrip.framework.apollo.monitor.internal.event.ApolloClientMonitorEvent;
import com.ctrip.framework.apollo.monitor.internal.jmx.mbean.ApolloClientJmxBootstrapArgsMBean;
import com.ctrip.framework.apollo.monitor.internal.listener.AbstractApolloClientMonitorEventListener;
import com.ctrip.framework.apollo.util.ConfigUtil;
import com.ctrip.framework.apollo.util.date.DateUtil;
import com.google.common.collect.Maps;
import java.time.LocalDateTime;
import java.util.Map;
import org.slf4j.Logger;

public class DefaultApolloClientBootstrapArgsApi
extends AbstractApolloClientMonitorEventListener
implements ApolloClientBootstrapArgsMonitorApi,
ApolloClientJmxBootstrapArgsMBean {
    private static final Logger logger = DeferredLoggerFactory.getLogger(DefaultApolloClientBootstrapArgsApi.class);
    private final Map<String, Object> bootstrapArgs = Maps.newHashMap();
    private final Map<String, String> bootstrapArgsString = Maps.newHashMap();

    public DefaultApolloClientBootstrapArgsApi(ConfigUtil configUtil) {
        super("BootstrapMonitor");
        this.putAttachmentValue("apollo.access-key.secret", configUtil.getAccessKeySecret());
        this.putAttachmentValue("ApolloAutoUpdateInjectedSpringProperties", configUtil.isAutoUpdateInjectedSpringPropertiesEnabled());
        this.putAttachmentValue("apollo.bootstrap.enabled", Boolean.parseBoolean(System.getProperty("apollo.bootstrap.enabled")));
        this.putAttachmentValue("apollo.bootstrap.namespaces", System.getProperty("apollo.bootstrap.namespaces"));
        this.putAttachmentValue("apollo.bootstrap.eagerLoad.enabled", Boolean.parseBoolean(System.getProperty("apollo.bootstrap.eagerLoad.enabled")));
        this.putAttachmentValue("apollo.override-system-properties", configUtil.isOverrideSystemProperties());
        this.putAttachmentValue("apollo.cache-dir", configUtil.getDefaultLocalCacheDir());
        this.putAttachmentValue("apollo.cluster", configUtil.getCluster());
        this.putAttachmentValue("apollo.config-service", System.getProperty("apollo.config-service"));
        this.putAttachmentValue("apollo.client.monitor.external.type", configUtil.getMonitorExternalType());
        this.putAttachmentValue("apollo.client.monitor.enabled", configUtil.isClientMonitorEnabled());
        this.putAttachmentValue("apollo.client.monitor.external.export-period", configUtil.getMonitorExternalExportPeriod());
        this.putAttachmentValue("apollo.meta", configUtil.getMetaServerDomainName());
        this.putAttachmentValue("apollo.property.names.cache.enable", configUtil.isPropertyNamesCacheEnabled());
        this.putAttachmentValue("apollo.property.order.enable", configUtil.isPropertiesOrderEnabled());
        this.putAttachmentValue("apollo.client.monitor.jmx.enabled", configUtil.isClientMonitorJmxEnabled());
        this.putAttachmentValue("apollo.client.monitor.exception-queue-size", configUtil.getMonitorExceptionQueueSize());
        this.putAttachmentValue("app.id", configUtil.getAppId());
        this.putAttachmentValue("env", configUtil.getApolloEnv());
        this.putAttachmentValue("version", Apollo.VERSION);
        DateUtil.formatLocalDateTime(LocalDateTime.now()).ifPresent(s -> this.putAttachmentValue("metaFreshTime", s));
        this.putAttachmentValue("configServiceUrl", "");
    }

    @Override
    public void collect0(ApolloClientMonitorEvent event) {
        String argName = event.getName();
        if (this.bootstrapArgs.containsKey(argName)) {
            this.putAttachmentValue(argName, event.getAttachmentValue(argName));
        } else {
            logger.warn("Unhandled event name: {}", (Object)argName);
        }
    }

    private void putAttachmentValue(String argName, Object value) {
        if (StringUtils.isBlank((String)argName) || value == null) {
            return;
        }
        this.bootstrapArgs.put(argName, value);
        this.bootstrapArgsString.put(argName, String.valueOf(value));
    }

    @Override
    public boolean isMetricsSampleUpdated() {
        return false;
    }

    @Override
    public Map<String, Object> getBootstrapArgs() {
        return this.bootstrapArgs;
    }

    @Override
    public Map<String, String> getBootstrapArgsString() {
        return this.bootstrapArgsString;
    }
}

