/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.monitor.internal.listener.impl;

import com.ctrip.framework.apollo.exceptions.ApolloConfigException;
import com.ctrip.framework.apollo.monitor.api.ApolloClientExceptionMonitorApi;
import com.ctrip.framework.apollo.monitor.internal.event.ApolloClientMonitorEvent;
import com.ctrip.framework.apollo.monitor.internal.jmx.mbean.ApolloClientJmxExceptionMBean;
import com.ctrip.framework.apollo.monitor.internal.listener.AbstractApolloClientMonitorEventListener;
import com.ctrip.framework.apollo.util.ConfigUtil;
import com.google.common.collect.EvictingQueue;
import com.google.common.collect.Queues;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class DefaultApolloClientExceptionApi
extends AbstractApolloClientMonitorEventListener
implements ApolloClientExceptionMonitorApi,
ApolloClientJmxExceptionMBean {
    private final AtomicInteger exceptionCountFromStartup = new AtomicInteger(0);
    private final Queue<ApolloConfigException> exceptionsQueue;

    public DefaultApolloClientExceptionApi(ConfigUtil configUtil) {
        super("ErrorMonitor");
        int monitorExceptionQueueSize = configUtil.getMonitorExceptionQueueSize();
        EvictingQueue evictingQueue = EvictingQueue.create((int)monitorExceptionQueueSize);
        this.exceptionsQueue = Queues.synchronizedQueue((Queue)evictingQueue);
    }

    @Override
    public List<Exception> getApolloConfigExceptionList() {
        return new ArrayList<Exception>(this.exceptionsQueue);
    }

    @Override
    public Integer getExceptionCountFromStartup() {
        return this.exceptionCountFromStartup.get();
    }

    @Override
    public void collect0(ApolloClientMonitorEvent event) {
        ApolloConfigException exception = (ApolloConfigException)event.getAttachmentValue("throwable");
        if (exception != null) {
            this.exceptionsQueue.add(exception);
            this.exceptionCountFromStartup.incrementAndGet();
            this.createOrUpdateCounterSample("apollo_client_exception_num", 1.0);
        }
    }

    @Override
    public List<String> getApolloConfigExceptionDetails() {
        return this.exceptionsQueue.stream().map(Throwable::getMessage).collect(Collectors.toList());
    }
}

