/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.spi;

import com.ctrip.framework.apollo.build.ApolloInjector;
import com.ctrip.framework.apollo.spi.ConfigFactory;
import com.ctrip.framework.apollo.spi.ConfigFactoryManager;
import com.ctrip.framework.apollo.spi.ConfigRegistry;
import com.ctrip.framework.apollo.util.ConfigUtil;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;

public class DefaultConfigFactoryManager
implements ConfigFactoryManager {
    private ConfigRegistry m_registry;
    private Table<String, String, ConfigFactory> m_factories = Tables.synchronizedTable((Table)HashBasedTable.create());
    private ConfigUtil m_configUtil;

    public DefaultConfigFactoryManager() {
        this.m_registry = ApolloInjector.getInstance(ConfigRegistry.class);
        this.m_configUtil = ApolloInjector.getInstance(ConfigUtil.class);
    }

    @Override
    public ConfigFactory getFactory(String namespace) {
        return this.getFactory(this.m_configUtil.getAppId(), namespace);
    }

    @Override
    public ConfigFactory getFactory(String appId, String namespace) {
        ConfigFactory factory = this.m_registry.getFactory(appId, namespace);
        if (factory != null) {
            return factory;
        }
        factory = (ConfigFactory)this.m_factories.get((Object)appId, (Object)namespace);
        if (factory != null) {
            return factory;
        }
        factory = ApolloInjector.getInstance(ConfigFactory.class, namespace);
        if (factory != null) {
            return factory;
        }
        factory = ApolloInjector.getInstance(ConfigFactory.class);
        this.m_factories.put((Object)appId, (Object)namespace, (Object)factory);
        return factory;
    }
}

