/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.spring.spi;

import com.ctrip.framework.apollo.build.ApolloInjector;
import com.ctrip.framework.apollo.core.utils.StringUtils;
import com.ctrip.framework.apollo.spring.annotation.ApolloAnnotationProcessor;
import com.ctrip.framework.apollo.spring.annotation.EnableApolloConfig;
import com.ctrip.framework.apollo.spring.annotation.SpringValueProcessor;
import com.ctrip.framework.apollo.spring.config.PropertySourcesProcessor;
import com.ctrip.framework.apollo.spring.property.AutoUpdateConfigChangeListener;
import com.ctrip.framework.apollo.spring.property.SpringValueDefinitionProcessor;
import com.ctrip.framework.apollo.spring.spi.ApolloConfigRegistrarHelper;
import com.ctrip.framework.apollo.spring.util.BeanRegistrationUtil;
import com.ctrip.framework.apollo.util.ConfigUtil;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;

public class DefaultApolloConfigRegistrarHelper
implements ApolloConfigRegistrarHelper {
    private static final Logger logger = LoggerFactory.getLogger(DefaultApolloConfigRegistrarHelper.class);
    private final ConfigUtil configUtil = ApolloInjector.getInstance(ConfigUtil.class);
    private Environment environment;

    @Override
    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)importingClassMetadata.getAnnotationAttributes(EnableApolloConfig.class.getName()));
        String[] namespaces = attributes.getStringArray("value");
        int order = (Integer)attributes.getNumber("order");
        PropertySourcesProcessor.addNamespaces(this.configUtil.getAppId(), Lists.newArrayList((Object[])this.resolveNamespaces(namespaces)), order);
        AnnotationAttributes[] multipleConfigs = attributes.getAnnotationArray("multipleConfigs");
        if (multipleConfigs != null) {
            for (AnnotationAttributes multipleConfig : multipleConfigs) {
                String appId = multipleConfig.getString("appId");
                Object[] multipleNamespaces = this.resolveNamespaces(multipleConfig.getStringArray("namespaces"));
                String secret = this.resolveSecret(multipleConfig.getString("secret"));
                int multipleOrder = (Integer)multipleConfig.getNumber("order");
                if (!StringUtils.isBlank((String)secret)) {
                    System.setProperty("apollo.accesskey." + appId + ".secret", secret);
                }
                PropertySourcesProcessor.addNamespaces(appId, Lists.newArrayList((Object[])multipleNamespaces), multipleOrder);
            }
        }
        HashMap<String, Object> propertySourcesPlaceholderPropertyValues = new HashMap<String, Object>();
        propertySourcesPlaceholderPropertyValues.put("order", 0);
        BeanRegistrationUtil.registerBeanDefinitionIfNotExists(registry, PropertySourcesPlaceholderConfigurer.class, propertySourcesPlaceholderPropertyValues);
        BeanRegistrationUtil.registerBeanDefinitionIfNotExists(registry, AutoUpdateConfigChangeListener.class);
        BeanRegistrationUtil.registerBeanDefinitionIfNotExists(registry, PropertySourcesProcessor.class);
        BeanRegistrationUtil.registerBeanDefinitionIfNotExists(registry, ApolloAnnotationProcessor.class);
        BeanRegistrationUtil.registerBeanDefinitionIfNotExists(registry, SpringValueProcessor.class);
        BeanRegistrationUtil.registerBeanDefinitionIfNotExists(registry, SpringValueDefinitionProcessor.class);
    }

    private String[] resolveNamespaces(String[] namespaces) {
        if (this.environment == null) {
            this.logNamespacePlaceholderNotSupportedMessage(namespaces);
            return namespaces;
        }
        String[] resolvedNamespaces = new String[namespaces.length];
        for (int i = 0; i < namespaces.length; ++i) {
            resolvedNamespaces[i] = this.environment.resolveRequiredPlaceholders(namespaces[i]);
        }
        return resolvedNamespaces;
    }

    private String resolveSecret(String secret) {
        if (this.environment == null) {
            if (secret != null && secret.contains("${")) {
                logger.warn("secret placeholder {} is not supported for Spring version prior to 3.2.x", (Object)secret);
            }
            return secret;
        }
        return this.environment.resolveRequiredPlaceholders(secret);
    }

    private void logNamespacePlaceholderNotSupportedMessage(String[] namespaces) {
        for (String namespace : namespaces) {
            if (!namespace.contains("${")) continue;
            logger.warn("Namespace placeholder {} is not supported for Spring version prior to 3.2.x, see https://github.com/apolloconfig/apollo/issues/4178 for more details.", (Object)namespace);
            break;
        }
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

