/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.util.escape;

public class EscapeUtil {
    private static final String SINGLE_UNDERSCORE = "_";
    private static final String DOUBLE_UNDERSCORE = "__";
    private static final String TRIPLE_UNDERSCORE = "___";

    public static String escapeNamespace(String namespace) {
        if (namespace == null || namespace.isEmpty()) {
            throw new IllegalArgumentException("Namespace cannot be null or empty");
        }
        return namespace.replace(SINGLE_UNDERSCORE, DOUBLE_UNDERSCORE);
    }

    public static String createConfigMapKey(String cluster, String namespace) {
        String escapedNamespace = EscapeUtil.escapeNamespace(namespace);
        return String.join((CharSequence)TRIPLE_UNDERSCORE, cluster, escapedNamespace);
    }
}

