/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.openapi.client.url;

import com.ctrip.framework.apollo.openapi.utils.UrlUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OpenApiPathBuilder {
    private static final String ENV_PATH = "env";
    private static final String ENVS_PATH = "envs";
    private static final String APPS_PATH = "apps";
    private static final String CLUSTERS_PATH = "clusters";
    private static final String NAMESPACES_PATH = "namespaces";
    private static final String ITEMS_PATH = "items";
    private static final String ENCODED_ITEMS_PATH = "encodedItems";
    private static final String RELEASE_PATH = "releases";
    private static final List<String> SORTED_PATH_KEYS = Arrays.asList("envs", "env", "apps", "clusters", "namespaces", "items", "encodedItems", "releases");
    private static final Escaper PATH_ESCAPER = UrlEscapers.urlPathSegmentEscaper();
    private static final Escaper QUERY_PARAM_ESCAPER = UrlEscapers.urlFormParameterEscaper();
    private static final Joiner PATH_JOIN = Joiner.on((String)"/");
    private final Map<String, String> pathVariable = new HashMap<String, String>();
    private final Map<String, String> params = new HashMap<String, String>();
    private String customResource;

    public static OpenApiPathBuilder newBuilder() {
        return new OpenApiPathBuilder();
    }

    private OpenApiPathBuilder() {
    }

    public OpenApiPathBuilder envPathVal(String env) {
        this.pathVariable.put(ENV_PATH, this.escapePath(env));
        return this;
    }

    public OpenApiPathBuilder envsPathVal(String envs) {
        this.pathVariable.put(ENVS_PATH, this.escapePath(envs));
        return this;
    }

    public OpenApiPathBuilder appsPathVal(String apps) {
        this.pathVariable.put(APPS_PATH, this.escapePath(apps));
        return this;
    }

    public OpenApiPathBuilder clustersPathVal(String clusters) {
        this.pathVariable.put(CLUSTERS_PATH, this.escapePath(clusters));
        return this;
    }

    public OpenApiPathBuilder namespacesPathVal(String namespaces) {
        this.pathVariable.put(NAMESPACES_PATH, this.escapePath(namespaces));
        return this;
    }

    public OpenApiPathBuilder itemsPathVal(String items) {
        if (UrlUtils.hasIllegalChar(items)) {
            items = new String(Base64.getEncoder().encode(items.getBytes(StandardCharsets.UTF_8)));
            this.pathVariable.put(ENCODED_ITEMS_PATH, this.escapePath(items));
        } else {
            this.pathVariable.put(ITEMS_PATH, this.escapePath(items));
        }
        return this;
    }

    public OpenApiPathBuilder releasesPathVal(String releases) {
        this.pathVariable.put(RELEASE_PATH, this.escapePath(releases));
        return this;
    }

    public OpenApiPathBuilder customResource(String customResource) {
        this.customResource = customResource;
        return this;
    }

    public OpenApiPathBuilder addParam(String key, Object value) {
        if (Strings.isNullOrEmpty((String)key)) {
            throw new IllegalArgumentException("Param key should not be null or empty");
        }
        this.params.put(key, this.escapeParam(String.valueOf(value)));
        return this;
    }

    public String buildPath(String baseUrl) {
        if (Strings.isNullOrEmpty((String)baseUrl)) {
            throw new IllegalArgumentException("Base url should not be null or empty");
        }
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(baseUrl);
        for (String k : SORTED_PATH_KEYS) {
            if (!this.pathVariable.containsKey(k)) continue;
            parts.add(k);
            String v = this.pathVariable.get(k);
            if (Strings.isNullOrEmpty((String)v)) continue;
            parts.add(v);
        }
        if (!Strings.isNullOrEmpty((String)this.customResource)) {
            parts.add(this.customResource);
        }
        String path = PATH_JOIN.join(parts);
        if (!this.params.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> kv : this.params.entrySet()) {
                if (sb.length() > 0) {
                    sb.append("&");
                }
                sb.append(kv.getKey()).append("=").append(kv.getValue());
            }
            path = path + "?" + sb;
        }
        return path;
    }

    protected String escapePath(String path) {
        return PATH_ESCAPER.escape(path);
    }

    protected String escapeParam(String param) {
        return QUERY_PARAM_ESCAPER.escape(param);
    }
}

