/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.openapi.client.service;

import com.ctrip.framework.apollo.core.enums.ConfigFileFormat;
import com.ctrip.framework.apollo.openapi.client.service.AbstractOpenApiService;
import com.ctrip.framework.apollo.openapi.client.url.OpenApiPathBuilder;
import com.ctrip.framework.apollo.openapi.dto.OpenAppNamespaceDTO;
import com.ctrip.framework.apollo.openapi.dto.OpenNamespaceDTO;
import com.ctrip.framework.apollo.openapi.dto.OpenNamespaceLockDTO;
import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public class NamespaceOpenApiService
extends AbstractOpenApiService
implements com.ctrip.framework.apollo.openapi.api.NamespaceOpenApiService {
    private static final Type OPEN_NAMESPACE_DTO_LIST_TYPE = new TypeToken<List<OpenNamespaceDTO>>(){}.getType();

    public NamespaceOpenApiService(CloseableHttpClient client, String baseUrl, Gson gson) {
        super(client, baseUrl, gson);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OpenNamespaceDTO getNamespace(String appId, String env, String clusterName, String namespaceName) {
        if (Strings.isNullOrEmpty((String)clusterName)) {
            clusterName = "default";
        }
        if (Strings.isNullOrEmpty((String)namespaceName)) {
            namespaceName = "application";
        }
        this.checkNotEmpty(appId, "App id");
        this.checkNotEmpty(env, "Env");
        OpenApiPathBuilder pathBuilder = OpenApiPathBuilder.newBuilder().envsPathVal(env).appsPathVal(appId).clustersPathVal(clusterName).namespacesPathVal(namespaceName);
        try (CloseableHttpResponse response = this.get(pathBuilder);){
            OpenNamespaceDTO openNamespaceDTO = (OpenNamespaceDTO)this.gson.fromJson(EntityUtils.toString((HttpEntity)response.getEntity()), OpenNamespaceDTO.class);
            return openNamespaceDTO;
        }
        catch (Throwable ex) {
            throw new RuntimeException(String.format("Get namespace for appId: %s, cluster: %s, namespace: %s in env: %s failed", appId, clusterName, namespaceName, env), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<OpenNamespaceDTO> getNamespaces(String appId, String env, String clusterName) {
        if (Strings.isNullOrEmpty((String)clusterName)) {
            clusterName = "default";
        }
        this.checkNotEmpty(appId, "App id");
        this.checkNotEmpty(env, "Env");
        OpenApiPathBuilder pathBuilder = OpenApiPathBuilder.newBuilder().envsPathVal(env).appsPathVal(appId).clustersPathVal(clusterName).customResource("namespaces");
        try (CloseableHttpResponse response = this.get(pathBuilder);){
            List list = (List)this.gson.fromJson(EntityUtils.toString((HttpEntity)response.getEntity()), OPEN_NAMESPACE_DTO_LIST_TYPE);
            return list;
        }
        catch (Throwable ex) {
            throw new RuntimeException(String.format("Get namespaces for appId: %s, cluster: %s in env: %s failed", appId, clusterName, env), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OpenAppNamespaceDTO createAppNamespace(OpenAppNamespaceDTO appNamespaceDTO) {
        this.checkNotEmpty(appNamespaceDTO.getAppId(), "App id");
        this.checkNotEmpty(appNamespaceDTO.getName(), "Name");
        this.checkNotEmpty(appNamespaceDTO.getDataChangeCreatedBy(), "Created by");
        if (Strings.isNullOrEmpty((String)appNamespaceDTO.getFormat())) {
            appNamespaceDTO.setFormat(ConfigFileFormat.Properties.getValue());
        }
        OpenApiPathBuilder pathBuilder = OpenApiPathBuilder.newBuilder().appsPathVal(appNamespaceDTO.getAppId()).customResource("appnamespaces");
        try (CloseableHttpResponse response = this.post(pathBuilder, appNamespaceDTO);){
            OpenAppNamespaceDTO openAppNamespaceDTO = (OpenAppNamespaceDTO)this.gson.fromJson(EntityUtils.toString((HttpEntity)response.getEntity()), OpenAppNamespaceDTO.class);
            return openAppNamespaceDTO;
        }
        catch (Throwable ex) {
            throw new RuntimeException(String.format("Create app namespace: %s for appId: %s, format: %s failed", appNamespaceDTO.getName(), appNamespaceDTO.getAppId(), appNamespaceDTO.getFormat()), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OpenNamespaceLockDTO getNamespaceLock(String appId, String env, String clusterName, String namespaceName) {
        if (Strings.isNullOrEmpty((String)clusterName)) {
            clusterName = "default";
        }
        if (Strings.isNullOrEmpty((String)namespaceName)) {
            namespaceName = "application";
        }
        this.checkNotEmpty(appId, "App id");
        this.checkNotEmpty(env, "Env");
        OpenApiPathBuilder pathBuilder = OpenApiPathBuilder.newBuilder().envsPathVal(env).appsPathVal(appId).clustersPathVal(clusterName).namespacesPathVal(namespaceName).customResource("lock");
        try (CloseableHttpResponse response = this.get(pathBuilder);){
            OpenNamespaceLockDTO openNamespaceLockDTO = (OpenNamespaceLockDTO)this.gson.fromJson(EntityUtils.toString((HttpEntity)response.getEntity()), OpenNamespaceLockDTO.class);
            return openNamespaceLockDTO;
        }
        catch (Throwable ex) {
            throw new RuntimeException(String.format("Get namespace lock for appId: %s, cluster: %s, namespace: %s in env: %s failed", appId, clusterName, namespaceName, env), ex);
        }
    }
}

