/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.b.d;
import dm.jdbc.b.j;
import dm.jdbc.b.n;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DBWarning;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbResultSetCache;
import dm.jdbc.driver.DmdbResultSetCachePool;
import dm.jdbc.filter.Filterable;
import dm.jdbc.parser.SQLProcessor;
import dm.jdbc.util.ByteUtil;
import dm.jdbc.util.ConvertUtil;
import dm.jdbc.util.StringUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public class DmdbStatement
extends Filterable
implements Statement {
    public int fo;
    public String fp;
    public boolean fq;
    public j jc;
    public DmdbConnection K;
    public int kx;
    public int ky;
    public int gZ;
    public String kz;
    public int kA;
    public long kB;
    public boolean kC;
    public int kD;
    public int iQ = 1000;
    public int iR;
    public long kE;
    public boolean kF = false;
    public boolean closed = true;
    public SQLWarning kG;
    public List kH = null;
    public DmdbResultSet kI;
    public List kJ = new ArrayList(3);
    public boolean kK = true;
    public d[] iE = new d[0];
    public int type = 1;
    public static final int STATEMENT = 1;
    public static final int PREPARED_STATEMENT = 2;
    public static final int CALLABLE_STATEMENT = 3;
    public boolean running = false;
    public static AtomicLong fY = new AtomicLong(0L);

    @Override
    public long getID() {
        if (this.ID < 0L) {
            this.ID = fY.incrementAndGet();
        }
        return this.ID;
    }

    public DmdbStatement(DmdbConnection dmdbConnection, int n2, int n3, int n4) {
        super(dmdbConnection, null);
        if (n2 == 1005) {
            dmdbConnection.addSQLWarning(DBWarning.getSQLWarning(DBError.ECJDBC_WARNING_UNSUPPORT_RESULTSET_TYPE));
            n2 = 1004;
        }
        this.K = dmdbConnection;
        this.kx = n2;
        this.ky = n3;
        this.gZ = n4;
        this.kC = dmdbConnection.connection_property_escapeProcess;
        this.kB = dmdbConnection.connection_property_maxRows;
        this.kD = dmdbConnection.connection_property_sessionTimeout;
        this.allocateHandle();
    }

    private void allocateHandle() {
        n n2;
        n n3 = n2 = this.K.hc != null && this.K.hc.size() > 0 ? (n)this.K.hc.get() : null;
        if (n2 != null) {
            this.fo = n2.fo;
            this.fp = n2.fp;
            this.fq = n2.fq;
        } else {
            this.K.gX.a(this);
            long l2 = this.fo;
            if (this.fo < 0) {
                l2 = 0xFFFFFFFFL & l2;
            }
            this.fp = "DM7CUR" + l2;
        }
        this.closed = false;
    }

    public boolean do_execute(String string) {
        return this.do_execute(string, 2);
    }

    public boolean do_execute(String string, int n2) {
        try {
            this.beforeExecute();
            this.executeInner(string, (short)0, n2 == 1);
            boolean bl = this.kI != null;
            return bl;
        }
        finally {
            this.afterExecute();
        }
    }

    public boolean do_execute(String string, int[] nArray) {
        int n2 = nArray != null && nArray.length > 0 ? 1 : 2;
        return this.do_execute(string, n2);
    }

    public boolean do_execute(String string, String[] stringArray) {
        int n2 = stringArray != null && stringArray.length > 0 ? 1 : 2;
        return this.do_execute(string, n2);
    }

    public DmdbResultSet do_executeQuery(String string) {
        try {
            this.beforeExecute();
            this.executeInner(string, (short)1, false);
            DmdbResultSet dmdbResultSet = this.kI == null ? DmdbResultSet.newEmptyResultSet(this) : this.kI;
            return dmdbResultSet;
        }
        finally {
            this.afterExecute();
        }
    }

    public int do_executeUpdate(String string) {
        return this.do_executeUpdate(string, 2);
    }

    public int do_executeUpdate(String string, int n2) {
        try {
            this.beforeExecute();
            this.executeInner(string, (short)2, n2 == 1);
            int n3 = this.do_getUpdateCount();
            return n3;
        }
        finally {
            this.afterExecute();
        }
    }

    public int do_executeUpdate(String string, int[] nArray) {
        int n2 = nArray != null && nArray.length > 0 ? 1 : 2;
        return this.do_executeUpdate(string, n2);
    }

    public int do_executeUpdate(String string, String[] stringArray) {
        int n2 = stringArray != null && stringArray.length > 0 ? 1 : 2;
        return this.do_executeUpdate(string, n2);
    }

    public int[] do_executeBatch() {
        try {
            this.beforeExecute();
            if (this.K.readOnly) {
                DBError.ECJDBC_READ_ONLY_CONNECTION.throwException(new String[0]);
            }
            if (this.kH != null && this.kH.size() > 0) {
                int n2 = this.kH.size();
                int[] nArray = new int[n2];
                ArrayList<String> arrayList = new ArrayList<String>();
                SQLException sQLException = null;
                int n3 = 0;
                while (n3 < n2) {
                    sQLException = null;
                    try {
                        this.executeInner((String)this.kH.get(n3), (short)2, false);
                        nArray[n3] = ConvertUtil.toInt(!this.K.compatibleOracle() ? this.do_getLargeUpdateCount() : -2L);
                        if (this.jc.eE) {
                            DBError.ECJDBC_INVALID_SQL_TYPE.throwException(new String[0]);
                        }
                    }
                    catch (SQLException sQLException2) {
                        nArray[n3] = !this.K.compatibleOracle() ? -3 : -2;
                        sQLException = sQLException2;
                    }
                    if (sQLException != null) {
                        if (this.K.connection_property_continueBatchOnError) {
                            arrayList.add("sql[" + n3 + "]:" + sQLException.getErrorCode() + ", " + sQLException.getMessage());
                            SQLWarning sQLWarning = new SQLWarning("sql[" + n3 + "]:" + sQLException.getErrorCode() + ", " + sQLException.getMessage());
                            this.addSQLWarning(sQLWarning);
                        } else {
                            int[] nArray2 = new int[n3];
                            System.arraycopy(nArray, 0, nArray2, 0, n3);
                            DBError.throwBatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), nArray2);
                        }
                    }
                    ++n3;
                }
                if (arrayList.size() > 0) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (String string : arrayList) {
                        stringBuilder.append(StringUtil.LINE_SEPARATOR).append(string);
                    }
                    DBError.throwBatchUpdateException(String.valueOf(DBError.EC_BP_WITH_ERROR.reason) + stringBuilder.toString(), DBError.EC_BP_WITH_ERROR.fR, DBError.EC_BP_WITH_ERROR.fQ, nArray);
                }
                int[] nArray3 = nArray;
                return nArray3;
            }
            int[] nArray = new int[]{};
            return nArray;
        }
        finally {
            this.do_clearBatch();
            this.afterExecute();
        }
    }

    public void do_addBatch(String string) {
        if (StringUtil.isEmpty(string)) {
            DBError.ECJDBC_SQL_IS_EMPTY.throwException(new String[0]);
        }
        if (this.kH == null) {
            this.kH = new ArrayList(10);
        }
        this.kH.add(string);
    }

    public void do_clearBatch() {
        if (this.kH != null && this.kH.size() > 0) {
            this.kH.clear();
        }
    }

    public void do_setPoolable(boolean bl) {
        this.kK = bl;
    }

    public boolean do_isPoolable() {
        return this.kK;
    }

    public void reconnect() {
        this.free();
        this.allocateHandle();
    }

    public void free() {
        this.clearResultSets();
        try {
            if (!this.closed && this.K != null && this.K.gX != null && !this.K.closed) {
                this.K.gX.f(this.fo);
            }
        }
        catch (Exception exception) {}
        this.closed = true;
    }

    public void do_close() {
        this.do_clearBatch();
        this.do_clearWarnings();
        this.clearResultSets();
        try {
            if (!this.closed && this.kK && this.K.connection_property_stmtPoolMaxSize > 0) {
                this.pool();
            } else {
                this.free();
            }
        }
        finally {
            if (this.K != null && this.K.hd != null) {
                this.K.hd.remove(this);
            }
            this.K = null;
            this.closed = true;
        }
    }

    public void pool() {
        this.K.hc.put(new n(this.fo, this.fp, this.fq));
    }

    public void clearResultSets() {
        for (DmdbResultSet dmdbResultSet : this.kJ) {
            if (dmdbResultSet == null) continue;
            dmdbResultSet.closed = true;
        }
        this.kJ.clear();
        if (this.kI != null) {
            this.kI.closed = true;
            this.kI = null;
        }
    }

    public void do_clearWarnings() {
        this.kG = null;
    }

    public void addSQLWarning(SQLWarning sQLWarning) {
        if (this.kG == sQLWarning) {
            return;
        }
        if (this.kG == null) {
            this.kG = sQLWarning;
        } else {
            this.kG.setNextWarning(sQLWarning);
        }
    }

    public void do_cancel() {
        this.checkClosed();
        if (this.running) {
            this.K.do_reset();
        }
    }

    public void do_setCursorName(String string) {
        if (StringUtil.isEmpty(string)) {
            return;
        }
        this.checkClosed();
        this.K.gX.a(this, string);
    }

    public DmdbResultSet do_getResultSet() {
        return this.kI;
    }

    public int do_getUpdateCount() {
        return this.jc.eE ? -1 : ConvertUtil.toInt(this.jc.updateCount);
    }

    public boolean do_getMoreResults() {
        return this.do_getMoreResults(1);
    }

    public void do_setFetchDirection(int n2) {
        if (n2 == 1000 || n2 == 1001) {
            this.iQ = n2;
        } else if (n2 == 1002) {
            this.iQ = 1000;
        } else {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwException(new String[0]);
        }
    }

    public void do_setFetchSize(int n2) {
        if (n2 < 0 && n2 != Integer.MIN_VALUE || this.kB != 0L && this.kB != -1L && (long)n2 > this.kB) {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwException(new String[0]);
        }
        this.iR = n2;
    }

    public boolean do_getMoreResults(int n2) {
        this.checkClosed();
        this.jc.updateCount = -1L;
        if (!this.jc.eE) {
            return false;
        }
        short s2 = (short)(this.kI.iD + 1);
        switch (n2) {
            case 1: {
                this.kI.do_close();
                break;
            }
            case 3: {
                this.clearResultSets();
                break;
            }
            case 2: {
                this.kJ.add(this.kI);
                break;
            }
            default: {
                DBError.ECJDBC_UNSUPPORTED_PARAM.throwException(new String[0]);
            }
        }
        this.kI = null;
        j j2 = this.K.gX.a(this, (short)0);
        this.jc.eE = j2.eE;
        if (j2.eE) {
            this.kI = new DmdbResultSet(s2, this, j2);
        }
        return j2.eE;
    }

    public DmdbResultSet do_getGeneratedKeys() {
        d[] dArray = new d[]{new d()};
        dArray[0].type = 8;
        dArray[0].prec = 8;
        dArray[0].scale = 0;
        dArray[0].ao = "BIGINT";
        dArray[0].name = "AUTO_GEN_KEY";
        dArray[0].ap = false;
        Object object = null;
        if (this.jc.eS.size() > 0) {
            object = new byte[this.jc.eS.size()][2][];
            int n2 = 0;
            while (n2 < this.jc.eS.size()) {
                object[n2][1] = new byte[8];
                ByteUtil.setLong(object[n2][1], 0, (Long)this.jc.eS.get(n2));
                ++n2;
            }
        } else {
            object = new byte[][][]{};
        }
        return DmdbResultSet.newLocalResultSet(this, dArray, object);
    }

    protected void beforeExecute() {
        this.checkClosed();
        this.do_clearWarnings();
        this.clearResultSets();
        this.running = true;
    }

    protected void afterExecute() {
        this.running = false;
    }

    private void executeInner(String string, short s2, boolean bl) {
        DmdbResultSetCache dmdbResultSetCache;
        if (StringUtil.isEmpty(string)) {
            DBError.ECJDBC_SQL_IS_EMPTY.throwException(new String[0]);
        }
        this.kz = string;
        if (this.kC) {
            try {
                this.kz = this.K.do_nativeSQL(string);
            }
            catch (Exception exception) {}
        }
        LinkedList linkedList = null;
        if (this.K.gz) {
            linkedList = new LinkedList();
            try {
                this.kz = SQLProcessor.execOpt(this.kz, linkedList, this.K.getServerEncoding());
            }
            catch (Exception exception) {}
        }
        if (this.K.connection_property_enRsCache && (dmdbResultSetCache = DmdbResultSetCachePool.getResultSetCache(this.K.gB, this.K.gA, this.kz, this)) != null) {
            this.kI = dmdbResultSetCache.getResultSet(this);
            this.jc = dmdbResultSetCache.jc;
            return;
        }
        if (linkedList != null && linkedList.size() > 0) {
            try {
                this.jc = this.K.gX.a(this, bl, linkedList);
            }
            catch (SQLException sQLException) {
                if (DBError.ECJDBC_COMMUNITION_ERROR.fQ == sQLException.getErrorCode() || DBError.EC_RN_OPERATION_CANCELED.fQ == sQLException.getErrorCode() || DBError.EC_EXCEED_SESSION_REQUEST_LIMIT.fQ == sQLException.getErrorCode()) {
                    throw sQLException;
                }
                this.kz = string;
                this.jc = this.K.gX.a(this, s2, bl);
            }
        } else {
            this.jc = this.K.gX.a(this, s2, bl);
        }
        if (this.jc.eE) {
            this.kI = this.createAndCacheResultSet((short)1, this.jc);
        }
        if (s2 == 2 && !this.K.compatibleOracle() && this.kI != null) {
            DBError.ECJDBC_INVALID_SQL_TYPE.throwException(new String[0]);
        }
    }

    protected DmdbResultSet createAndCacheResultSet(short s2, j j2) {
        if (this.K.connection_property_enRsCache && j2.eH > 0 && j2.eF != null && (long)j2.eF.length == j2.updateCount) {
            DmdbResultSetCachePool.addResultSet(this, this.kz, j2);
        }
        return new DmdbResultSet(s2, this, j2);
    }

    protected void checkClosed() {
        if (this.K == null || this.do_isClosed()) {
            DBError.ECJDBC_STATEMENT_HANDLE_CLOSED.throwException(new String[0]);
        }
        this.K.checkClosed();
    }

    public int do_getMaxFieldSize() {
        return this.kA;
    }

    public void do_setMaxFieldSize(int n2) {
        if (n2 < 0) {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwException(new String[0]);
        }
        this.kA = n2;
    }

    public int do_getMaxRows() {
        return ConvertUtil.toInt(this.kB);
    }

    public void do_setMaxRows(int n2) {
        if (n2 < 0) {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwException(new String[0]);
        }
        this.kB = n2;
    }

    public void do_setEscapeProcessing(boolean bl) {
        this.kC = bl;
    }

    public int do_getQueryTimeout() {
        return this.kD;
    }

    public void do_setQueryTimeout(int n2) {
        if (n2 < 0) {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwException(new String[0]);
        }
        this.kD = n2;
    }

    public SQLWarning do_getWarnings() {
        return this.kG;
    }

    public int do_getFetchDirection() {
        return this.iQ;
    }

    public int do_getFetchSize() {
        return this.iR;
    }

    public int do_getResultSetConcurrency() {
        return this.ky;
    }

    public int do_getResultSetType() {
        return this.kx;
    }

    public DmdbConnection do_getConnection() {
        return this.K;
    }

    public int do_getResultSetHoldability() {
        return this.gZ;
    }

    public boolean do_isClosed() {
        return this.closed;
    }

    public void do_closeOnCompletion() {
        this.kF = true;
    }

    public boolean do_isCloseOnCompletion() {
        return this.kF;
    }

    public long do_getLargeUpdateCount() {
        return this.jc.eE ? -1L : this.jc.updateCount;
    }

    public void do_setLargeMaxRows(long l2) {
        if (l2 < 0L) {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwException(new String[0]);
        }
        this.kB = l2;
    }

    public long do_getLargeMaxRows() {
        return this.kB;
    }

    public long[] do_executeLargeBatch() {
        try {
            this.beforeExecute();
            if (this.K.readOnly) {
                DBError.ECJDBC_READ_ONLY_CONNECTION.throwException(new String[0]);
            }
            if (this.kH != null && this.kH.size() > 0) {
                int n2 = this.kH.size();
                long[] lArray = new long[n2];
                ArrayList<String> arrayList = new ArrayList<String>();
                SQLException sQLException = null;
                int n3 = 0;
                while (n3 < n2) {
                    sQLException = null;
                    try {
                        this.executeInner((String)this.kH.get(n3), (short)2, false);
                        long l2 = lArray[n3] = !this.K.compatibleOracle() ? this.do_getLargeUpdateCount() : -2L;
                        if (this.jc.eE) {
                            DBError.ECJDBC_INVALID_SQL_TYPE.throwException(new String[0]);
                        }
                    }
                    catch (SQLException sQLException2) {
                        lArray[n3] = !this.K.compatibleOracle() ? -3 : -2;
                        sQLException = sQLException2;
                    }
                    if (sQLException != null) {
                        if (this.K.connection_property_continueBatchOnError) {
                            arrayList.add("sql[" + n3 + "]:" + sQLException.getErrorCode() + ", " + sQLException.getMessage());
                            SQLWarning sQLWarning = new SQLWarning("sql[" + n3 + "]:" + sQLException.getErrorCode() + ", " + sQLException.getMessage());
                            this.addSQLWarning(sQLWarning);
                        } else {
                            long[] lArray2 = new long[n3];
                            System.arraycopy(lArray, 0, lArray2, 0, n3);
                            DBError.throwBatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), lArray2);
                        }
                    }
                    ++n3;
                }
                if (arrayList.size() > 0) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (String string : arrayList) {
                        stringBuilder.append(StringUtil.LINE_SEPARATOR).append(string);
                    }
                    DBError.throwBatchUpdateException(String.valueOf(DBError.EC_BP_WITH_ERROR.reason) + stringBuilder.toString(), DBError.EC_BP_WITH_ERROR.fR, DBError.EC_BP_WITH_ERROR.fQ, lArray);
                }
                long[] lArray3 = lArray;
                return lArray3;
            }
            long[] lArray = new long[]{};
            return lArray;
        }
        finally {
            this.do_clearBatch();
            this.afterExecute();
        }
    }

    public long do_executeLargeUpdate(String string) {
        return this.do_executeLargeUpdate(string, 2);
    }

    public long do_executeLargeUpdate(String string, int n2) {
        try {
            this.beforeExecute();
            this.executeInner(string, (short)2, n2 == 1);
            long l2 = this.do_getLargeUpdateCount();
            return l2;
        }
        finally {
            this.afterExecute();
        }
    }

    public long do_executeLargeUpdate(String string, int[] nArray) {
        int n2 = nArray != null && nArray.length > 0 ? 1 : 2;
        return this.do_executeLargeUpdate(string, n2);
    }

    public long do_executeLargeUpdate(String string, String[] stringArray) {
        int n2 = stringArray != null && stringArray.length > 0 ? 1 : 2;
        return this.do_executeLargeUpdate(string, n2);
    }

    protected void checkConnection() {
        if (this.K == null) {
            DBError.ECJDBC_CONNECTION_CLOSED.throwException(new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery(String string) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_executeQuery(string);
            }
            return this.filterChain.reset().Statement_executeQuery(this, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String string) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_executeUpdate(string);
            }
            return this.filterChain.reset().Statement_executeUpdate(this, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.K == null) {
            return;
        }
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_close();
            } else {
                this.filterChain.reset().Statement_close(this);
            }
        }
    }

    @Override
    public int getMaxFieldSize() {
        if (this.filterChain == null) {
            return this.do_getMaxFieldSize();
        }
        return this.filterChain.reset().Statement_getMaxFieldSize(this);
    }

    @Override
    public void setMaxFieldSize(int n2) {
        if (this.filterChain == null) {
            this.do_setMaxFieldSize(n2);
        } else {
            this.filterChain.reset().Statement_setMaxFieldSize(this, n2);
        }
    }

    @Override
    public int getMaxRows() {
        if (this.filterChain == null) {
            return this.do_getMaxRows();
        }
        return this.filterChain.reset().Statement_getMaxRows(this);
    }

    @Override
    public void setMaxRows(int n2) {
        if (this.filterChain == null) {
            this.do_setMaxRows(n2);
        } else {
            this.filterChain.reset().Statement_setMaxRows(this, n2);
        }
    }

    @Override
    public void setEscapeProcessing(boolean bl) {
        if (this.filterChain == null) {
            this.do_setEscapeProcessing(bl);
        } else {
            this.filterChain.reset().Statement_setEscapeProcessing(this, bl);
        }
    }

    @Override
    public int getQueryTimeout() {
        if (this.filterChain == null) {
            return this.do_getQueryTimeout();
        }
        return this.filterChain.reset().Statement_getQueryTimeout(this);
    }

    @Override
    public void setQueryTimeout(int n2) {
        if (this.filterChain == null) {
            this.do_setQueryTimeout(n2);
        } else {
            this.filterChain.reset().Statement_setQueryTimeout(this, n2);
        }
    }

    @Override
    public void cancel() {
        if (this.filterChain == null) {
            this.do_cancel();
        } else {
            this.filterChain.reset().Statement_cancel(this);
        }
    }

    @Override
    public SQLWarning getWarnings() {
        if (this.filterChain == null) {
            return this.do_getWarnings();
        }
        return this.filterChain.reset().Statement_getWarnings(this);
    }

    @Override
    public void clearWarnings() {
        if (this.filterChain == null) {
            this.do_clearWarnings();
        } else {
            this.filterChain.reset().Statement_clearWarnings(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCursorName(String string) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_setCursorName(string);
            } else {
                this.filterChain.reset().Statement_setCursorName(this, string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String string) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_execute(string);
            }
            return this.filterChain.reset().Statement_execute(this, string);
        }
    }

    @Override
    public ResultSet getResultSet() {
        if (this.filterChain == null) {
            return this.do_getResultSet();
        }
        return this.filterChain.reset().Statement_getResultSet(this);
    }

    @Override
    public int getUpdateCount() {
        if (this.filterChain == null) {
            return this.do_getUpdateCount();
        }
        return this.filterChain.reset().Statement_getUpdateCount(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getMoreResults() {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getMoreResults();
            }
            return this.filterChain.reset().Statement_getMoreResults(this);
        }
    }

    @Override
    public void setFetchDirection(int n2) {
        if (this.filterChain == null) {
            this.do_setFetchDirection(n2);
        } else {
            this.filterChain.reset().Statement_setFetchDirection(this, n2);
        }
    }

    @Override
    public int getFetchDirection() {
        if (this.filterChain == null) {
            return this.do_getFetchDirection();
        }
        return this.filterChain.reset().Statement_getFetchDirection(this);
    }

    @Override
    public void setFetchSize(int n2) {
        if (this.filterChain == null) {
            this.do_setFetchSize(n2);
        } else {
            this.filterChain.reset().Statement_setFetchSize(this, n2);
        }
    }

    @Override
    public int getFetchSize() {
        if (this.filterChain == null) {
            return this.do_getFetchSize();
        }
        return this.filterChain.reset().Statement_getFetchSize(this);
    }

    @Override
    public int getResultSetConcurrency() {
        if (this.filterChain == null) {
            return this.do_getResultSetConcurrency();
        }
        return this.filterChain.reset().Statement_getResultSetConcurrency(this);
    }

    @Override
    public int getResultSetType() {
        if (this.filterChain == null) {
            return this.do_getResultSetType();
        }
        return this.filterChain.reset().Statement_getResultSetType(this);
    }

    @Override
    public void addBatch(String string) {
        if (this.filterChain == null) {
            this.do_addBatch(string);
        } else {
            this.filterChain.reset().Statement_addBatch(this, string);
        }
    }

    @Override
    public void clearBatch() {
        if (this.filterChain == null) {
            this.do_clearBatch();
        } else {
            this.filterChain.reset().Statement_clearBatch(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_executeBatch();
            }
            return this.filterChain.reset().Statement_executeBatch(this);
        }
    }

    @Override
    public Connection getConnection() {
        if (this.filterChain == null) {
            return this.do_getConnection();
        }
        return this.filterChain.reset().Statement_getConnection(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getMoreResults(int n2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getMoreResults(n2);
            }
            return this.filterChain.reset().Statement_getMoreResults(this, n2);
        }
    }

    @Override
    public ResultSet getGeneratedKeys() {
        if (this.filterChain == null) {
            return this.do_getGeneratedKeys();
        }
        return this.filterChain.reset().Statement_getGeneratedKeys(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String string, int n2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_executeUpdate(string, n2);
            }
            return this.filterChain.reset().Statement_executeUpdate(this, string, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String string, int[] nArray) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_executeUpdate(string, nArray);
            }
            return this.filterChain.reset().Statement_executeUpdate(this, string, nArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String string, String[] stringArray) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_executeUpdate(string, stringArray);
            }
            return this.filterChain.reset().Statement_executeUpdate(this, string, stringArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String string, int n2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_execute(string, n2);
            }
            return this.filterChain.reset().Statement_execute(this, string, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String string, int[] nArray) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_execute(string, nArray);
            }
            return this.filterChain.reset().Statement_execute(this, string, nArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String string, String[] stringArray) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_execute(string, stringArray);
            }
            return this.filterChain.reset().Statement_execute(this, string, stringArray);
        }
    }

    @Override
    public int getResultSetHoldability() {
        if (this.filterChain == null) {
            return this.do_getResultSetHoldability();
        }
        return this.filterChain.reset().Statement_getResultSetHoldability(this);
    }

    @Override
    public boolean isClosed() {
        if (this.filterChain == null) {
            return this.do_isClosed();
        }
        return this.filterChain.reset().Statement_isClosed(this);
    }

    @Override
    public void setPoolable(boolean bl) {
        if (this.filterChain == null) {
            this.do_setPoolable(bl);
        } else {
            this.filterChain.reset().Statement_setPoolable(this, bl);
        }
    }

    @Override
    public boolean isPoolable() {
        if (this.filterChain == null) {
            return this.do_isPoolable();
        }
        return this.filterChain.reset().Statement_isPoolable(this);
    }

    @Override
    public void closeOnCompletion() {
        if (this.filterChain == null) {
            this.do_closeOnCompletion();
        } else {
            this.filterChain.reset().Statement_closeOnCompletion(this);
        }
    }

    @Override
    public boolean isCloseOnCompletion() {
        if (this.filterChain == null) {
            return this.do_isCloseOnCompletion();
        }
        return this.filterChain.reset().Statement_isCloseOnCompletion(this);
    }

    @Override
    public long getLargeUpdateCount() {
        if (this.filterChain == null) {
            return this.do_getLargeUpdateCount();
        }
        return this.filterChain.reset().Statement_getLargeUpdateCount(this);
    }

    @Override
    public void setLargeMaxRows(long l2) {
        if (this.filterChain == null) {
            this.do_setLargeMaxRows(l2);
        } else {
            this.filterChain.reset().Statement_setLargeMaxRows(this, l2);
        }
    }

    @Override
    public long getLargeMaxRows() {
        if (this.filterChain == null) {
            return this.do_getLargeMaxRows();
        }
        return this.filterChain.reset().Statement_getLargeMaxRows(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] executeLargeBatch() {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_executeLargeBatch();
            }
            return this.filterChain.reset().Statement_executeLargeBatch(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long executeLargeUpdate(String string) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_executeLargeUpdate(string);
            }
            return this.filterChain.reset().Statement_executeLargeUpdate(this, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long executeLargeUpdate(String string, int n2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_executeLargeUpdate(string, n2);
            }
            return this.filterChain.reset().Statement_executeLargeUpdate(this, string, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long executeLargeUpdate(String string, int[] nArray) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_executeLargeUpdate(string, nArray);
            }
            return this.filterChain.reset().Statement_executeLargeUpdate(this, string, nArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long executeLargeUpdate(String string, String[] stringArray) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.K;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_executeLargeUpdate(string, stringArray);
            }
            return this.filterChain.reset().Statement_executeLargeUpdate(this, string, stringArray);
        }
    }

    public Object unwrap(Class clazz) {
        return clazz.cast(this);
    }

    public boolean isWrapperFor(Class clazz) {
        return clazz.isInstance(this);
    }

    public long getRowId() {
        if (this.filterChain == null) {
            return this.do_getRowId();
        }
        return this.filterChain.reset().Statement_getRowId(this);
    }

    public long do_getRowId() {
        return this.jc != null ? this.jc.eR : -1L;
    }

    public ResultSet[] getResultSets() {
        if (this.filterChain == null) {
            return this.do_getResultSets();
        }
        return this.filterChain.reset().Statement_getResultSets(this);
    }

    public ResultSet[] do_getResultSets() {
        return this.kJ != null ? this.kJ.toArray(new ResultSet[0]) : new ResultSet[]{};
    }

    public String getPrintMsg() {
        if (this.filterChain == null) {
            return this.do_getPrintMsg();
        }
        return this.filterChain.reset().Statement_getPrintMsg(this);
    }

    public String do_getPrintMsg() {
        return this.jc != null ? this.jc.eO : "";
    }

    public String getExplain() {
        if (this.filterChain == null) {
            return this.do_getExplain();
        }
        return this.filterChain.reset().Statement_getExplain(this);
    }

    public String do_getExplain() {
        return this.jc != null ? this.jc.eP : "";
    }

    public long getExecuteId() {
        if (this.filterChain == null) {
            return this.do_getExecuteId();
        }
        return this.filterChain.reset().Statement_getExecuteId(this);
    }

    public long do_getExecuteId() {
        return this.jc != null ? this.jc.eU : -1L;
    }

    public int getSqlType() {
        if (this.filterChain == null) {
            return this.do_getSqlType();
        }
        return this.filterChain.reset().Statement_getSqlType(this);
    }

    public int do_getSqlType() {
        int n2;
        short s2 = this.jc.eT;
        switch (s2) {
            case 162: 
            case 178: {
                n2 = 3;
                break;
            }
            case 160: {
                n2 = 1;
                break;
            }
            case 152: {
                n2 = 4;
                break;
            }
            default: {
                n2 = 2;
            }
        }
        return n2;
    }

    public int getRetType() {
        return this.jc != null ? (int)this.jc.eT : 0;
    }
}

