/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.filter.stat;

import dm.jdbc.b.e;
import dm.jdbc.b.i;
import dm.jdbc.filter.stat.BaseStat;
import dm.jdbc.filter.stat.ConnectionStatValue;
import dm.jdbc.filter.stat.SqlStat;
import dm.jdbc.filter.stat.SqlStatValue;
import dm.jdbc.util.IDGenerator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ConnectionStat
extends BaseStat {
    private String id;
    private String url;
    private volatile long connCount;
    private volatile long activeConnCount;
    private volatile long maxActiveConnCount;
    private volatile long executeCount;
    private volatile long errorCount;
    private volatile long stmtCount;
    private volatile long activeStmtCount;
    private volatile long maxActiveStmtCount;
    private volatile long commitCount;
    private volatile long rollbackCount;
    private volatile long clobOpenCount;
    private volatile long blobOpenCount;
    AtomicLongFieldUpdater connCountUpdater = AtomicLongFieldUpdater.newUpdater(ConnectionStat.class, "connCount");
    AtomicLongFieldUpdater activeConnCountUpdater = AtomicLongFieldUpdater.newUpdater(ConnectionStat.class, "activeConnCount");
    AtomicLongFieldUpdater maxActiveConnCountUpdater = AtomicLongFieldUpdater.newUpdater(ConnectionStat.class, "maxActiveConnCount");
    AtomicLongFieldUpdater executeCountUpdater = AtomicLongFieldUpdater.newUpdater(ConnectionStat.class, "executeCount");
    AtomicLongFieldUpdater errorCountUpdater = AtomicLongFieldUpdater.newUpdater(ConnectionStat.class, "errorCount");
    AtomicLongFieldUpdater stmtCountUpdater = AtomicLongFieldUpdater.newUpdater(ConnectionStat.class, "stmtCount");
    AtomicLongFieldUpdater activeStmtCountUpdater = AtomicLongFieldUpdater.newUpdater(ConnectionStat.class, "activeStmtCount");
    AtomicLongFieldUpdater maxActiveStmtCountUpdater = AtomicLongFieldUpdater.newUpdater(ConnectionStat.class, "maxActiveStmtCount");
    AtomicLongFieldUpdater commitCountUpdater = AtomicLongFieldUpdater.newUpdater(ConnectionStat.class, "commitCount");
    AtomicLongFieldUpdater rollbackCountUpdater = AtomicLongFieldUpdater.newUpdater(ConnectionStat.class, "rollbackCount");
    AtomicLongFieldUpdater clobOpenCountUpdater = AtomicLongFieldUpdater.newUpdater(ConnectionStat.class, "clobOpenCount");
    AtomicLongFieldUpdater blobOpenCountUpdater = AtomicLongFieldUpdater.newUpdater(ConnectionStat.class, "blobOpenCount");
    private LinkedHashMap sqlStatMap;
    private int maxSqlSize = i.ex;
    private AtomicLong skipSqlCount = new AtomicLong();
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private String properties = "";

    public ConnectionStat(String string) {
        this.id = "DS" + IDGenerator.generateId();
        this.url = string;
        this.sqlStatMap = new LinkedHashMap(200, 0.75f, false);
    }

    public SqlStat createSqlStat(String string) {
        this.lock.writeLock().lock();
        try {
            SqlStat sqlStat = (SqlStat)this.sqlStatMap.get(string);
            if (sqlStat == null) {
                sqlStat = new SqlStat(string);
                sqlStat.setDataSource(this.url);
                sqlStat.setDataSourceId(this.id);
                if (this.putSqlStat(sqlStat)) {
                    SqlStat sqlStat2 = sqlStat;
                    return sqlStat2;
                }
                return null;
            }
            SqlStat sqlStat3 = sqlStat;
            return sqlStat3;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private boolean putSqlStat(SqlStat sqlStat) {
        if (this.maxSqlSize > 0 && this.sqlStatMap.size() == this.maxSqlSize) {
            if (i.ey == e.bC) {
                SqlStat sqlStat2 = this.eliminateSqlStat();
                if (sqlStat2.getRunningCount() > 0L || sqlStat2.getExecuteCount() > 0L) {
                    this.skipSqlCount.incrementAndGet();
                }
                this.sqlStatMap.put(sqlStat.getSql(), sqlStat);
                return true;
            }
            if (sqlStat.getRunningCount() > 0L || sqlStat.getExecuteCount() > 0L) {
                this.skipSqlCount.incrementAndGet();
            }
            return false;
        }
        this.sqlStatMap.put(sqlStat.getSql(), sqlStat);
        return true;
    }

    private SqlStat eliminateSqlStat() {
        Iterator iterator;
        Map.Entry entry;
        if (this.maxSqlSize > 0 && this.sqlStatMap.size() == this.maxSqlSize && i.ey == e.bC && (entry = (iterator = this.sqlStatMap.entrySet().iterator()).next()) != null) {
            iterator.remove();
            return (SqlStat)entry.getValue();
        }
        return null;
    }

    public Map getSqlStatMap() {
        LinkedHashMap linkedHashMap = new LinkedHashMap(this.sqlStatMap.size());
        this.lock.readLock().lock();
        try {
            linkedHashMap.putAll(this.sqlStatMap);
        }
        finally {
            this.lock.readLock().unlock();
        }
        return linkedHashMap;
    }

    public List getSqlStatMapAndReset() {
        Object object;
        ArrayList<SqlStat> arrayList = new ArrayList<SqlStat>(this.sqlStatMap.size());
        this.lock.writeLock().lock();
        try {
            object = this.sqlStatMap.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry object2 = object.next();
                SqlStat sqlStat = (SqlStat)object2.getValue();
                if (sqlStat.getExecuteCount() == 0L && sqlStat.getRunningCount() == 0L) {
                    sqlStat.setRemoved(true);
                    object.remove();
                    continue;
                }
                arrayList.add((SqlStat)object2.getValue());
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        object = new ArrayList(arrayList.size());
        for (SqlStat sqlStat : arrayList) {
            SqlStatValue sqlStatValue = sqlStat.getValueAndReset();
            if (sqlStatValue.getExecuteCount() == 0L && sqlStatValue.getRunningCount() == 0) continue;
            object.add(sqlStatValue);
        }
        return object;
    }

    public void incrementConn() {
        this.connCountUpdater.incrementAndGet(this);
        this.activeConnCountUpdater.incrementAndGet(this);
        long l2 = this.activeConnCountUpdater.get(this);
        if (l2 > this.maxActiveConnCountUpdater.get(this)) {
            this.maxActiveConnCountUpdater.set(this, l2);
        }
    }

    public void decrementConn() {
        this.activeConnCountUpdater.decrementAndGet(this);
    }

    public long getActiveConnCount() {
        return this.activeConnCount;
    }

    public long getConnCount() {
        return this.connCount;
    }

    public long getMaxActiveConnCount() {
        return this.maxActiveConnCount;
    }

    public void incrementStmt() {
        this.stmtCountUpdater.incrementAndGet(this);
        this.activeStmtCountUpdater.incrementAndGet(this);
        long l2 = this.activeStmtCountUpdater.get(this);
        if (l2 > this.maxActiveStmtCountUpdater.get(this)) {
            this.maxActiveStmtCountUpdater.set(this, l2);
        }
    }

    public void decrementStmt() {
        this.activeStmtCountUpdater.decrementAndGet(this);
    }

    public void decrementStmt(int n2) {
        this.activeStmtCountUpdater.addAndGet(this, -n2);
    }

    public long getActiveStmtCount() {
        return this.activeStmtCount;
    }

    public long getStmtCount() {
        return this.stmtCount;
    }

    public long getMaxActiveStmtCount() {
        return this.maxActiveStmtCount;
    }

    public void incrementExecuteCount() {
        this.executeCountUpdater.incrementAndGet(this);
    }

    public void incrementErrorCount() {
        this.errorCountUpdater.incrementAndGet(this);
    }

    public void incrementCommitCount() {
        this.commitCountUpdater.incrementAndGet(this);
    }

    public void incrementRollbackCount() {
        this.rollbackCountUpdater.incrementAndGet(this);
    }

    public long getCommitCount() {
        return this.commitCount;
    }

    public long getRollbackCount() {
        return this.rollbackCount;
    }

    public ConnectionStatValue getValue(boolean bl) {
        ConnectionStatValue connectionStatValue = new ConnectionStatValue();
        connectionStatValue.setId(this.id);
        connectionStatValue.setUrl(this.url);
        connectionStatValue.setConnCount(ConnectionStat.get((Object)this, this.connCountUpdater, bl));
        connectionStatValue.setActiveConnCount(ConnectionStat.get((Object)this, this.activeConnCountUpdater, false));
        connectionStatValue.setMaxActiveConnCount(ConnectionStat.get((Object)this, this.maxActiveConnCountUpdater, false));
        connectionStatValue.setStmtCount(ConnectionStat.get((Object)this, this.stmtCountUpdater, bl));
        connectionStatValue.setActiveStmtCount(ConnectionStat.get((Object)this, this.activeStmtCountUpdater, false));
        connectionStatValue.setMaxActiveStmtCount(ConnectionStat.get((Object)this, this.maxActiveStmtCountUpdater, false));
        connectionStatValue.setCommitCount(ConnectionStat.get((Object)this, this.commitCountUpdater, bl));
        connectionStatValue.setRollbackCount(ConnectionStat.get((Object)this, this.rollbackCountUpdater, bl));
        connectionStatValue.setExecuteCount(ConnectionStat.get((Object)this, this.executeCountUpdater, bl));
        connectionStatValue.setErrorCount(ConnectionStat.get((Object)this, this.errorCountUpdater, bl));
        connectionStatValue.setBlobOpenCount(ConnectionStat.get((Object)this, this.blobOpenCountUpdater, bl));
        connectionStatValue.setClobOpenCount(ConnectionStat.get((Object)this, this.clobOpenCountUpdater, bl));
        connectionStatValue.setProperties(this.properties);
        return connectionStatValue;
    }

    public Map getData() {
        return this.getValue(false).getData();
    }

    public ConnectionStatValue getValueAndReset() {
        return this.getValue(true);
    }

    public String getUrl() {
        return this.url;
    }

    public String getProperties() {
        return this.properties;
    }

    public void setProperties(String string) {
        this.properties = string;
    }

    public String getId() {
        return this.id;
    }
}

