/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.convert;

import dm.jdbc.convert.OffRowBlobData;
import dm.jdbc.convert.OffRowBytesData;
import dm.jdbc.convert.OffRowClobData;
import dm.jdbc.convert.OffRowData;
import dm.jdbc.convert.OffRowReaderData;
import dm.jdbc.convert.OffRowStreamData;
import dm.jdbc.desc.Column;
import dm.jdbc.desc.Data;
import dm.jdbc.desc.TypeData;
import dm.jdbc.desc.TypeDescriptor;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbArray;
import dm.jdbc.driver.DmdbBFile;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbClob;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbIntervalDT;
import dm.jdbc.driver.DmdbIntervalYM;
import dm.jdbc.driver.DmdbNumeric;
import dm.jdbc.driver.DmdbRowId;
import dm.jdbc.driver.DmdbStruct;
import dm.jdbc.driver.DmdbTimestamp;
import dm.jdbc.driver.DmdbType;
import dm.jdbc.internal.IDmdbConnection;
import dm.jdbc.util.ByteUtil;
import dm.jdbc.util.ConvertUtil;
import dm.jdbc.util.StreamUtil;
import dm.jdbc.util.StringUtil;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class J2DB {
    public static final double MAX_REAL = 3.4E38;
    public static final double MIN_REAL = -3.4E38;
    public static final BigDecimal MAX_REAL_VALUE = new BigDecimal("3.4E+38");
    public static final BigDecimal MIN_REAL_VALUE = new BigDecimal("-3.4E+38");
    public static final BigDecimal MAX_TINYINT_VALUE = new BigDecimal(127);
    public static final BigDecimal MIN_TINYINT_VALUE = new BigDecimal(-128);
    public static final BigDecimal MAX_SMALLINT_VALUE = new BigDecimal(Short.MAX_VALUE);
    public static final BigDecimal MIN_SMALLINT_VALUE = new BigDecimal(Short.MIN_VALUE);
    public static final BigDecimal MAX_INT_VALUE = new BigDecimal(Integer.MAX_VALUE);
    public static final BigDecimal MIN_INT_VALUE = new BigDecimal(Integer.MIN_VALUE);
    public static final BigDecimal MAX_BIGINT_VALUE = new BigDecimal(Long.MAX_VALUE);
    public static final BigDecimal MIN_BIGINT_VALUE = new BigDecimal(Long.MIN_VALUE);

    public static byte[] fromBoolean(boolean bl, Column column, IDmdbConnection iDmdbConnection) {
        try {
            byte[] byArray = null;
            switch (column.type) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 13: 
                case 19: {
                    if (column.mask == 3) {
                        DBError.ECJDBC_INVALID_BFILE.throwz(new Object[0]);
                    }
                    return J2DB.fromLong(bl ? 1 : 0, column, iDmdbConnection);
                }
                case 12: 
                case 17: 
                case 18: {
                    if (DmdbType.isComplexType(column.type, column.scale)) {
                        DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                    }
                    byArray = J2DB.toBit(bl ? 1 : 0);
                    break;
                }
                default: {
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                }
            }
            return J2DB.checkLength(column, byArray, iDmdbConnection.getServerEncoding());
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(exception);
            return null;
        }
    }

    public static byte[] fromLong(long l2, Column column, IDmdbConnection iDmdbConnection) {
        try {
            byte[] byArray = null;
            switch (column.type) {
                case 3: 
                case 13: {
                    byArray = J2DB.toBit(l2);
                    break;
                }
                case 5: {
                    J2DB.checkTinyint(l2);
                    byArray = J2DB.toTinyint((byte)l2);
                    break;
                }
                case 6: {
                    J2DB.checkSmallint(l2);
                    byArray = J2DB.toSmallint((short)l2);
                    break;
                }
                case 7: {
                    J2DB.checkInt(l2);
                    byArray = J2DB.toInt((int)l2);
                    break;
                }
                case 8: {
                    J2DB.checkBigint(l2);
                    byArray = J2DB.toBigint(l2);
                    break;
                }
                case 10: {
                    J2DB.checkReal(l2);
                    byArray = J2DB.toReal(l2);
                    break;
                }
                case 11: {
                    byArray = J2DB.toDouble(l2);
                    break;
                }
                case 9: {
                    byArray = DmdbNumeric.valueOf(l2, column.prec, column.scale).encode();
                    break;
                }
                case 0: 
                case 1: 
                case 2: 
                case 19: {
                    if (column.mask == 3) {
                        DBError.ECJDBC_INVALID_BFILE.throwz(new Object[0]);
                    }
                    byArray = J2DB.toVarchar(String.valueOf(l2), iDmdbConnection.getServerEncoding());
                    break;
                }
                case 12: 
                case 17: 
                case 18: {
                    if (DmdbType.isComplexType(column.type, column.scale)) {
                        DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                    }
                    byArray = J2DB.toBinary(l2, column.prec);
                    break;
                }
                case 14: 
                case 15: 
                case 16: 
                case 26: {
                    byArray = J2DB.toDate(l2, column, iDmdbConnection);
                    break;
                }
                case 28: {
                    byArray = DmdbRowId.valueOf(l2).encode(iDmdbConnection);
                    break;
                }
                default: {
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                }
            }
            return J2DB.checkLength(column, byArray, iDmdbConnection.getServerEncoding());
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(exception);
            return null;
        }
    }

    public static byte[] fromFloat(float f2, Column column, DmdbConnection dmdbConnection) {
        try {
            byte[] byArray = null;
            switch (column.type) {
                case 3: 
                case 13: {
                    byArray = J2DB.toTinyint((byte)((double)f2 != 0.0 ? 1 : 0));
                    break;
                }
                case 5: {
                    J2DB.checkTinyint(f2);
                    byArray = J2DB.toTinyint((byte)f2);
                    break;
                }
                case 6: {
                    J2DB.checkSmallint(f2);
                    byArray = J2DB.toSmallint((short)f2);
                    break;
                }
                case 7: {
                    J2DB.checkInt(f2);
                    byArray = J2DB.toInt((int)f2);
                    break;
                }
                case 8: {
                    J2DB.checkBigint(f2);
                    byArray = J2DB.toBigint((long)f2);
                    break;
                }
                case 10: {
                    J2DB.checkReal(f2);
                    byArray = J2DB.toReal(f2);
                    break;
                }
                case 11: {
                    byArray = J2DB.toDouble(f2);
                    break;
                }
                case 9: {
                    byArray = DmdbNumeric.valueOf(String.valueOf(f2), column.prec, column.scale).encode();
                    break;
                }
                case 0: 
                case 1: 
                case 2: 
                case 19: {
                    if (column.mask == 3) {
                        DBError.ECJDBC_INVALID_BFILE.throwz(new Object[0]);
                    }
                    byArray = J2DB.toVarchar(String.valueOf(f2), dmdbConnection.getServerEncoding());
                    break;
                }
                default: {
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                }
            }
            return J2DB.checkLength(column, byArray, dmdbConnection.getServerEncoding());
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(exception);
            return null;
        }
    }

    public static byte[] fromDouble(double d2, Column column, IDmdbConnection iDmdbConnection) {
        try {
            byte[] byArray = null;
            switch (column.type) {
                case 3: 
                case 13: {
                    byArray = J2DB.toTinyint((byte)(d2 != 0.0 ? 1 : 0));
                    break;
                }
                case 5: {
                    J2DB.checkTinyint(d2);
                    byArray = J2DB.toTinyint((byte)d2);
                    break;
                }
                case 6: {
                    J2DB.checkSmallint(d2);
                    byArray = J2DB.toSmallint((short)d2);
                    break;
                }
                case 7: {
                    J2DB.checkInt(d2);
                    byArray = J2DB.toInt((int)d2);
                    break;
                }
                case 8: {
                    J2DB.checkBigint(d2);
                    byArray = J2DB.toBigint((long)d2);
                    break;
                }
                case 10: {
                    J2DB.checkReal(d2);
                    byArray = J2DB.toReal((float)d2);
                    break;
                }
                case 11: {
                    byArray = J2DB.toDouble(d2);
                    break;
                }
                case 9: {
                    byArray = DmdbNumeric.valueOf(String.valueOf(d2), column.prec, column.scale).encode();
                    break;
                }
                case 0: 
                case 1: 
                case 2: 
                case 19: {
                    if (column.mask == 3) {
                        DBError.ECJDBC_INVALID_BFILE.throwz(new Object[0]);
                    }
                    byArray = J2DB.toVarchar(String.valueOf(d2), iDmdbConnection.getServerEncoding());
                    break;
                }
                default: {
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                }
            }
            return J2DB.checkLength(column, byArray, iDmdbConnection.getServerEncoding());
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(exception);
            return null;
        }
    }

    public static byte[] fromBigDecimal(BigDecimal bigDecimal, Column column, IDmdbConnection iDmdbConnection) {
        try {
            byte[] byArray = null;
            switch (column.type) {
                case 3: 
                case 13: {
                    byArray = J2DB.toBit(bigDecimal.equals(new BigDecimal(0)) ? 0 : 1);
                    break;
                }
                case 5: {
                    J2DB.checkTinyint(bigDecimal);
                    byArray = J2DB.toTinyint(bigDecimal.setScale(0, 4).byteValue());
                    break;
                }
                case 6: {
                    J2DB.checkSmallint(bigDecimal);
                    byArray = J2DB.toSmallint(bigDecimal.setScale(0, 4).shortValue());
                    break;
                }
                case 7: {
                    J2DB.checkInt(bigDecimal);
                    byArray = J2DB.toInt(bigDecimal.setScale(0, 4).intValue());
                    break;
                }
                case 8: {
                    J2DB.checkBigint(bigDecimal);
                    byArray = J2DB.toBigint(bigDecimal.setScale(0, 4).longValue());
                    break;
                }
                case 10: {
                    J2DB.checkReal(bigDecimal);
                    byArray = J2DB.toReal(bigDecimal.floatValue());
                    break;
                }
                case 11: {
                    byArray = J2DB.toDouble(bigDecimal.doubleValue());
                    break;
                }
                case 9: {
                    byArray = DmdbNumeric.valueOf(bigDecimal, column.prec, column.scale).encode();
                    break;
                }
                case 0: 
                case 1: 
                case 2: 
                case 19: {
                    if (column.mask == 3) {
                        DBError.ECJDBC_INVALID_BFILE.throwz(new Object[0]);
                    }
                    byArray = J2DB.toVarchar(String.valueOf(bigDecimal), iDmdbConnection.getServerEncoding());
                    break;
                }
                case 28: {
                    byArray = DmdbRowId.valueOf(bigDecimal.longValue()).encode(iDmdbConnection);
                    break;
                }
                default: {
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                }
            }
            return J2DB.checkLength(column, byArray, iDmdbConnection.getServerEncoding());
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(exception);
            return null;
        }
    }

    public static Object fromString(String string, Column column, IDmdbConnection iDmdbConnection) {
        try {
            Object object = null;
            switch (column.type) {
                case 3: 
                case 13: {
                    object = J2DB.toBit(ConvertUtil.toBoolean(string) ? 1 : 0);
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    return J2DB.fromBigDecimal(new BigDecimal(string), column, iDmdbConnection);
                }
                case 10: {
                    Float f2 = Float.valueOf(string);
                    return J2DB.toReal(f2.floatValue());
                }
                case 11: {
                    Double d2 = Double.valueOf(string);
                    return J2DB.toDouble(d2);
                }
                case 9: {
                    object = J2DB.toDecimal(string, column.prec, column.scale);
                    break;
                }
                case 0: 
                case 1: 
                case 2: {
                    if (column.mask == 3 && !DmdbBFile.isValidBFileStr(string)) {
                        DBError.ECJDBC_INVALID_BFILE.throwz(new Object[0]);
                    }
                    object = J2DB.toVarchar(string, iDmdbConnection.getServerEncoding());
                    break;
                }
                case 19: {
                    object = J2DB.toClob(string, column, iDmdbConnection);
                    break;
                }
                case 17: 
                case 18: {
                    object = J2DB.toVarbinary(string);
                    break;
                }
                case 12: {
                    if (DmdbType.isComplexType(column.type, column.scale)) {
                        DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                    }
                    object = J2DB.toBlob(J2DB.toVarbinary(string), column, iDmdbConnection);
                    break;
                }
                case 14: 
                case 15: 
                case 16: 
                case 22: 
                case 23: 
                case 26: 
                case 27: {
                    DmdbTimestamp dmdbTimestamp = DmdbTimestamp.valueOf(string, column, iDmdbConnection);
                    object = dmdbTimestamp.encode(column, iDmdbConnection);
                    break;
                }
                case 21: {
                    DmdbIntervalDT dmdbIntervalDT = new DmdbIntervalDT(string);
                    object = dmdbIntervalDT.encode(column.scale);
                    break;
                }
                case 20: {
                    DmdbIntervalYM dmdbIntervalYM = new DmdbIntervalYM(string);
                    object = dmdbIntervalYM.encode(column.scale);
                    break;
                }
                case 28: {
                    object = DmdbRowId.valueOf(string).encode(iDmdbConnection);
                    break;
                }
                default: {
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                }
            }
            return object instanceof byte[] ? J2DB.checkLength(column, object, iDmdbConnection.getServerEncoding()) : object;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(exception);
            return null;
        }
    }

    public static Object fromBytes(byte[] byArray, Column column, IDmdbConnection iDmdbConnection) {
        try {
            Object object = null;
            switch (column.type) {
                case 5: {
                    if (byArray.length > 1) {
                        DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                    }
                    object = byArray;
                    break;
                }
                case 6: {
                    if (byArray.length > 2) {
                        DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                    }
                    object = byArray;
                    break;
                }
                case 7: {
                    if (byArray.length > 4) {
                        DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                    }
                    object = byArray;
                    break;
                }
                case 8: {
                    if (byArray.length > 8) {
                        DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                    }
                    object = byArray;
                    break;
                }
                case 0: 
                case 1: 
                case 2: {
                    if (column.mask == 3) {
                        DBError.ECJDBC_INVALID_BFILE.throwz(new Object[0]);
                    }
                    object = J2DB.toVarchar(byArray);
                    break;
                }
                case 19: {
                    object = J2DB.toClob(byArray, column, iDmdbConnection);
                    break;
                }
                case 17: 
                case 18: {
                    object = J2DB.toVarbinary(byArray);
                    break;
                }
                case 12: {
                    object = J2DB.toBlob(byArray, column, iDmdbConnection);
                    break;
                }
                case 117: 
                case 119: 
                case 121: 
                case 122: {
                    TypeDescriptor typeDescriptor = column.typeDescriptor;
                    if (typeDescriptor != null) {
                        object = TypeData.objBlobToBytes(byArray, typeDescriptor);
                        break;
                    }
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                    break;
                }
                case 28: {
                    object = DmdbRowId.valueOf(byArray).encode(iDmdbConnection);
                    break;
                }
                default: {
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                }
            }
            return object instanceof byte[] ? J2DB.checkLength(column, object, iDmdbConnection.getServerEncoding()) : object;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(exception);
            return null;
        }
    }

    public static byte[] fromDate(java.util.Date date, Column column, IDmdbConnection iDmdbConnection, Calendar calendar) {
        try {
            byte[] byArray = null;
            switch (column.type) {
                case 0: 
                case 1: 
                case 2: 
                case 19: {
                    if (column.mask == 3) {
                        DBError.ECJDBC_INVALID_BFILE.throwz(new Object[0]);
                    }
                    byArray = J2DB.toVarchar(date.toString(), iDmdbConnection.getServerEncoding());
                    break;
                }
                case 14: 
                case 15: 
                case 16: 
                case 22: 
                case 23: 
                case 26: 
                case 27: {
                    DmdbTimestamp dmdbTimestamp = DmdbTimestamp.valueOf(date);
                    byArray = dmdbTimestamp.encode(column, iDmdbConnection);
                    break;
                }
                default: {
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                }
            }
            return J2DB.checkLength(column, byArray, iDmdbConnection.getServerEncoding());
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(exception);
            return null;
        }
    }

    public static byte[] fromDmdbTimestamp(DmdbTimestamp dmdbTimestamp, Column column, IDmdbConnection iDmdbConnection) {
        try {
            byte[] byArray = null;
            switch (column.type) {
                case 0: 
                case 1: 
                case 2: 
                case 19: {
                    if (column.mask == 3) {
                        DBError.ECJDBC_INVALID_BFILE.throwz(new Object[0]);
                    }
                    byArray = J2DB.toVarchar(dmdbTimestamp.toString(), iDmdbConnection.getServerEncoding());
                    break;
                }
                case 14: 
                case 15: 
                case 16: 
                case 22: 
                case 23: 
                case 26: 
                case 27: {
                    byArray = dmdbTimestamp.encode(column, iDmdbConnection);
                    break;
                }
                default: {
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                }
            }
            return J2DB.checkLength(column, byArray, iDmdbConnection.getServerEncoding());
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(exception);
            return null;
        }
    }

    public static byte[] fromDmdbIntervalDT(DmdbIntervalDT dmdbIntervalDT, Column column, IDmdbConnection iDmdbConnection) {
        try {
            byte[] byArray = null;
            switch (column.type) {
                case 0: 
                case 1: 
                case 2: 
                case 19: {
                    if (column.mask == 3) {
                        DBError.ECJDBC_INVALID_BFILE.throwz(new Object[0]);
                    }
                    byArray = J2DB.toVarchar(dmdbIntervalDT.toString(), iDmdbConnection.getServerEncoding());
                    break;
                }
                case 21: {
                    byArray = dmdbIntervalDT.encode(column.scale);
                    break;
                }
                default: {
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                }
            }
            return J2DB.checkLength(column, byArray, iDmdbConnection.getServerEncoding());
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(exception);
            return null;
        }
    }

    public static byte[] fromDmdbIntervalYM(DmdbIntervalYM dmdbIntervalYM, Column column, IDmdbConnection iDmdbConnection) {
        try {
            byte[] byArray = null;
            switch (column.type) {
                case 0: 
                case 1: 
                case 2: 
                case 19: {
                    if (column.mask == 3) {
                        DBError.ECJDBC_INVALID_BFILE.throwz(new Object[0]);
                    }
                    byArray = J2DB.toVarchar(dmdbIntervalYM.toString(), iDmdbConnection.getServerEncoding());
                    break;
                }
                case 20: {
                    byArray = dmdbIntervalYM.encode(column.scale);
                    break;
                }
                default: {
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                }
            }
            return J2DB.checkLength(column, byArray, iDmdbConnection.getServerEncoding());
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(exception);
            return null;
        }
    }

    public static Object fromBlob(DmdbBlob dmdbBlob, Column column, DmdbConnection dmdbConnection) {
        try {
            Object object = null;
            switch (column.type) {
                case 17: 
                case 18: {
                    object = dmdbBlob.do_getBytes(1L, (int)dmdbBlob.do_length());
                    break;
                }
                case 12: {
                    if (dmdbConnection.lobEmptyCompOrcl && dmdbBlob instanceof DmdbBlob && dmdbBlob.empty) {
                        return Data.EMPTY_LOB;
                    }
                    object = J2DB.toBlob(dmdbBlob, column, dmdbConnection);
                    break;
                }
                case 117: 
                case 119: 
                case 121: 
                case 122: {
                    TypeDescriptor typeDescriptor = column.typeDescriptor;
                    if (typeDescriptor != null) {
                        byte[] byArray = dmdbBlob.do_getBytes(1L, (int)dmdbBlob.do_length());
                        object = TypeData.objBlobToBytes(byArray, typeDescriptor);
                        break;
                    }
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                    break;
                }
                default: {
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                }
            }
            return object instanceof byte[] ? J2DB.checkLength(column, object, dmdbConnection.getServerEncoding()) : object;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(exception);
            return null;
        }
    }

    public static Object fromClob(DmdbClob dmdbClob, Column column, DmdbConnection dmdbConnection) {
        try {
            Object object = null;
            switch (column.type) {
                case 0: 
                case 1: 
                case 2: {
                    String string = dmdbClob.do_getSubString(1L, (int)dmdbClob.do_length());
                    if (column.mask == 3 && !DmdbBFile.isValidBFileStr(string)) {
                        DBError.ECJDBC_INVALID_BFILE.throwz(new Object[0]);
                    }
                    object = ByteUtil.fromString(string, dmdbConnection.getServerEncoding());
                    break;
                }
                case 19: {
                    if (dmdbConnection.lobEmptyCompOrcl && dmdbClob instanceof DmdbClob && dmdbClob.empty) {
                        return Data.EMPTY_LOB;
                    }
                    object = J2DB.toClob(dmdbClob, column, dmdbConnection);
                    break;
                }
                default: {
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                }
            }
            return object instanceof byte[] ? (Object)J2DB.checkLength(column, (byte[])object, dmdbConnection.getServerEncoding()) : object;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(exception);
            return null;
        }
    }

    public static Object fromBinaryStream(InputStream inputStream, Column column, DmdbConnection dmdbConnection, long l2) {
        try {
            Object object = null;
            switch (column.type) {
                case 0: 
                case 1: 
                case 2: {
                    if (column.mask == 3) {
                        DBError.ECJDBC_INVALID_BFILE.throwz(new Object[0]);
                    }
                    object = StreamUtil.readBytes(inputStream, (int)l2);
                    break;
                }
                case 17: 
                case 18: {
                    object = J2DB.toVarbinary(StreamUtil.readBytes(inputStream, (int)l2));
                    break;
                }
                case 19: {
                    OffRowStreamData offRowStreamData = new OffRowStreamData(inputStream, dmdbConnection.getServerEncoding(), l2, 1);
                    object = offRowStreamData.offRow ? offRowStreamData : (Object)offRowStreamData.readAll();
                    break;
                }
                case 12: {
                    OffRowStreamData offRowStreamData = new OffRowStreamData(inputStream, dmdbConnection.getServerEncoding(), l2, 1);
                    object = offRowStreamData.offRow ? offRowStreamData : (Object)offRowStreamData.readAll();
                    break;
                }
                case 117: 
                case 119: 
                case 121: 
                case 122: {
                    TypeDescriptor typeDescriptor = column.typeDescriptor;
                    if (typeDescriptor != null) {
                        object = StreamUtil.readBytes(inputStream, (int)l2);
                        object = TypeData.objBlobToBytes(object, typeDescriptor);
                        break;
                    }
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                    break;
                }
                default: {
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                }
            }
            return object instanceof byte[] ? J2DB.checkLength(column, object, dmdbConnection.getServerEncoding()) : object;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(exception);
            return null;
        }
    }

    public static Object fromAsciiStream(InputStream inputStream, Column column, DmdbConnection dmdbConnection, long l2) {
        try {
            Object object = null;
            switch (column.type) {
                case 0: 
                case 1: 
                case 2: {
                    if (column.mask == 3) {
                        DBError.ECJDBC_INVALID_BFILE.throwz(new Object[0]);
                    }
                    byte[] byArray = StreamUtil.readBytes(inputStream, (int)l2);
                    char[] cArray = ConvertUtil.ASCIIBytesToJavaChars(byArray, 0, byArray.length);
                    object = ByteUtil.fromString(String.valueOf(cArray), dmdbConnection.getServerEncoding());
                    break;
                }
                case 19: {
                    OffRowStreamData offRowStreamData = new OffRowStreamData(inputStream, dmdbConnection.getServerEncoding(), l2, 2);
                    object = offRowStreamData.offRow ? offRowStreamData : (Object)offRowStreamData.readAll();
                    break;
                }
                case 17: 
                case 18: {
                    object = J2DB.toVarbinary(StreamUtil.readBytes(inputStream, (int)l2));
                    break;
                }
                case 12: {
                    OffRowStreamData offRowStreamData = new OffRowStreamData(inputStream, dmdbConnection.getServerEncoding(), l2, 2);
                    object = offRowStreamData.offRow ? offRowStreamData : (Object)offRowStreamData.readAll();
                    break;
                }
                default: {
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                }
            }
            return object instanceof byte[] ? J2DB.checkLength(column, object, dmdbConnection.getServerEncoding()) : object;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(exception);
            return null;
        }
    }

    public static Object fromUnicodeStream(InputStream inputStream, Column column, DmdbConnection dmdbConnection, long l2) {
        try {
            Object object = null;
            switch (column.type) {
                case 0: 
                case 1: 
                case 2: {
                    if (column.mask == 3) {
                        DBError.ECJDBC_INVALID_BFILE.throwz(new Object[0]);
                    }
                    byte[] byArray = StreamUtil.readBytes(inputStream, (int)l2);
                    String string = ConvertUtil.UnicodeBytesToString(byArray, byArray.length);
                    object = ByteUtil.fromString(string, dmdbConnection.getServerEncoding());
                    break;
                }
                case 19: {
                    OffRowStreamData offRowStreamData = new OffRowStreamData(inputStream, dmdbConnection.getServerEncoding(), l2, 3);
                    object = offRowStreamData.offRow ? offRowStreamData : (Object)offRowStreamData.readAll();
                    break;
                }
                case 17: 
                case 18: {
                    object = J2DB.toVarbinary(StreamUtil.readBytes(inputStream, (int)l2));
                    break;
                }
                case 12: {
                    OffRowStreamData offRowStreamData = new OffRowStreamData(inputStream, dmdbConnection.getServerEncoding(), l2, 3);
                    object = offRowStreamData.offRow ? offRowStreamData : (Object)offRowStreamData.readAll();
                    break;
                }
                default: {
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                }
            }
            return object instanceof byte[] ? J2DB.checkLength(column, object, dmdbConnection.getServerEncoding()) : object;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(exception);
            return null;
        }
    }

    public static Object fromReader(Reader reader, Column column, DmdbConnection dmdbConnection, long l2) {
        try {
            Object object = null;
            switch (column.type) {
                case 0: 
                case 1: 
                case 2: {
                    String string = StreamUtil.readString(reader, (int)l2);
                    if (column.mask == 3 && !DmdbBFile.isValidBFileStr(string)) {
                        DBError.ECJDBC_INVALID_BFILE.throwz(new Object[0]);
                    }
                    object = J2DB.toVarchar(string, dmdbConnection.getServerEncoding());
                    break;
                }
                case 17: 
                case 18: {
                    object = ByteUtil.fromString(StreamUtil.readString(reader, (int)l2), dmdbConnection.getServerEncoding());
                    break;
                }
                case 12: 
                case 19: {
                    OffRowReaderData offRowReaderData = new OffRowReaderData(reader, dmdbConnection.getServerEncoding(), l2);
                    object = offRowReaderData.offRow ? offRowReaderData : (Object)offRowReaderData.readAll();
                    break;
                }
                default: {
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                }
            }
            return object instanceof byte[] ? J2DB.checkLength(column, object, dmdbConnection.getServerEncoding()) : object;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(exception);
            return null;
        }
    }

    public static Object fromArray(DmdbArray dmdbArray, Column column, DmdbConnection dmdbConnection) {
        try {
            Object object = null;
            switch (column.type) {
                case 122: {
                    object = TypeData.sarrayToBytes(dmdbArray, column.typeDescriptor);
                    break;
                }
                case 117: 
                case 119: {
                    object = TypeData.arrayToBytes(dmdbArray, column.typeDescriptor);
                    break;
                }
                case 12: {
                    object = J2DB.toBlob(TypeData.toBytes(dmdbArray, column.typeDescriptor), column, (IDmdbConnection)dmdbConnection);
                    break;
                }
                default: {
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                }
            }
            return object instanceof byte[] ? J2DB.checkLength(column, object, dmdbConnection.getServerEncoding()) : object;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(exception);
            return null;
        }
    }

    public static Object fromStruct(DmdbStruct dmdbStruct, Column column, DmdbConnection dmdbConnection) {
        try {
            Object object = null;
            switch (column.type) {
                case 119: {
                    object = TypeData.structToBytes(dmdbStruct, column.typeDescriptor);
                    break;
                }
                case 121: {
                    object = TypeData.recordToBytes(dmdbStruct, column.typeDescriptor);
                    break;
                }
                case 12: {
                    object = J2DB.toBlob(TypeData.toBytes(dmdbStruct, column.typeDescriptor), column, (IDmdbConnection)dmdbConnection);
                    break;
                }
                default: {
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                }
            }
            return object instanceof byte[] ? J2DB.checkLength(column, object, dmdbConnection.getServerEncoding()) : object;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(exception);
            return null;
        }
    }

    public static Object fromRowId(RowId rowId, Column column, IDmdbConnection iDmdbConnection) {
        if (!(rowId instanceof DmdbRowId)) {
            return J2DB.fromBytes(rowId.getBytes(), column, iDmdbConnection);
        }
        try {
            byte[] byArray = null;
            switch (column.type) {
                case 28: {
                    byArray = ((DmdbRowId)rowId).encode(iDmdbConnection);
                    break;
                }
                case 8: {
                    byArray = ByteUtil.fromLong(((DmdbRowId)rowId).longValue(iDmdbConnection));
                    break;
                }
                default: {
                    return J2DB.fromBytes(rowId.getBytes(), column, iDmdbConnection);
                }
            }
            return byArray instanceof byte[] ? J2DB.checkLength(column, byArray, iDmdbConnection.getServerEncoding()) : byArray;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(exception);
            return null;
        }
    }

    public static byte[] fromObject(Object object, Column column, IDmdbConnection iDmdbConnection) {
        byte[] byArray;
        block29: {
            byArray = null;
            if (object instanceof String) {
                Object object2 = J2DB.fromString((String)object, column, iDmdbConnection);
                return object2 instanceof OffRowData ? ((OffRowData)object2).readAll() : (byte[])object2;
            }
            if (object instanceof Integer) {
                return J2DB.fromLong(((Integer)object).intValue(), column, iDmdbConnection);
            }
            if (object instanceof Short) {
                return J2DB.fromLong(((Short)object).shortValue(), column, iDmdbConnection);
            }
            if (object instanceof Long) {
                return J2DB.fromLong((Long)object, column, iDmdbConnection);
            }
            if (object instanceof Double) {
                return J2DB.fromDouble((Double)object, column, iDmdbConnection);
            }
            if (object instanceof Float) {
                return J2DB.fromDouble(((Float)object).floatValue(), column, iDmdbConnection);
            }
            if (object instanceof Byte) {
                return J2DB.fromLong(((Byte)object).byteValue(), column, iDmdbConnection);
            }
            if (object instanceof BigDecimal) {
                return J2DB.fromBigDecimal((BigDecimal)object, column, iDmdbConnection);
            }
            if (object instanceof Number) {
                BigDecimal bigDecimal = new BigDecimal(String.valueOf(object));
                return J2DB.fromBigDecimal(bigDecimal, column, iDmdbConnection);
            }
            if (object instanceof Date) {
                return J2DB.fromDate((java.util.Date)object, column, iDmdbConnection, null);
            }
            if (object instanceof Time) {
                return J2DB.fromDate((Time)object, column, iDmdbConnection, null);
            }
            if (object instanceof Timestamp) {
                return J2DB.fromDate((Timestamp)object, column, iDmdbConnection, null);
            }
            if (object instanceof DmdbBlob) {
                Blob blob = (Blob)object;
                byArray = blob.getBytes(1L, (int)blob.length());
                break block29;
            }
            if (object instanceof Blob) {
                Blob blob = (Blob)object;
                byArray = blob.getBytes(1L, (int)blob.length());
                break block29;
            }
            if (object instanceof Clob) {
                Clob clob = (Clob)object;
                String string = clob.getSubString(1L, (int)clob.length());
                byArray = ByteUtil.fromString(string, iDmdbConnection.getServerEncoding());
                break block29;
            }
            if (object instanceof InputStream) {
                OffRowStreamData offRowStreamData = new OffRowStreamData((InputStream)object, iDmdbConnection.getServerEncoding(), -1L, 1);
                byArray = ((OffRowData)offRowStreamData).readAll();
                break block29;
            }
            if (object instanceof Reader) {
                OffRowReaderData offRowReaderData = new OffRowReaderData((Reader)object, iDmdbConnection.getServerEncoding(), -1L);
                byArray = ((OffRowData)offRowReaderData).readAll();
                break block29;
            }
            if (object instanceof byte[]) {
                Object object3 = J2DB.fromBytes((byte[])object, column, iDmdbConnection);
                return object3 instanceof OffRowData ? ((OffRowData)object3).readAll() : (byte[])object3;
            }
            if (object instanceof Boolean) {
                return J2DB.fromBoolean((Boolean)object, column, iDmdbConnection);
            }
            if (object instanceof DmdbIntervalDT) {
                return J2DB.fromDmdbIntervalDT((DmdbIntervalDT)object, column, iDmdbConnection);
            }
            if (object instanceof DmdbIntervalYM) {
                return J2DB.fromDmdbIntervalYM((DmdbIntervalYM)object, column, iDmdbConnection);
            }
            if (object instanceof DmdbTimestamp) {
                return J2DB.fromDmdbTimestamp((DmdbTimestamp)object, column, iDmdbConnection);
            }
            if (object instanceof Character) {
                Object object4 = J2DB.fromString(String.valueOf(object), column, iDmdbConnection);
                return object4 instanceof OffRowData ? ((OffRowData)object4).readAll() : (byte[])object4;
            }
            if (object instanceof java.util.Date) {
                return J2DB.fromDate((java.util.Date)object, column, iDmdbConnection, null);
            }
            if (object instanceof RowId) {
                Object object5 = J2DB.fromRowId((RowId)object, column, iDmdbConnection);
                return object5 instanceof OffRowData ? ((OffRowData)object5).readAll() : (byte[])object5;
            }
            DBError.ECJDBC_UNSUPPORTED_TYPE.throwz(new Object[0]);
            return null;
        }
        try {
            return J2DB.checkLength(column, byArray, iDmdbConnection.getServerEncoding());
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(exception);
            return null;
        }
    }

    public static byte[] toDate(long l2, Column column, IDmdbConnection iDmdbConnection) {
        byte[] byArray = null;
        switch (column.type) {
            case 16: 
            case 26: {
                DmdbTimestamp dmdbTimestamp = DmdbTimestamp.valueOf(l2 * 1000L - 2209017600000L, column);
                byArray = dmdbTimestamp.encode(column, iDmdbConnection);
                break;
            }
            case 15: {
                if (l2 < Integer.MIN_VALUE || l2 > Integer.MAX_VALUE) {
                    DBError.EC_DATETIME_OVERFLOW.throwz(new Object[0]);
                }
                DmdbTimestamp dmdbTimestamp = DmdbTimestamp.valueOf(l2 * 1000L, column);
                byArray = dmdbTimestamp.encode(column, iDmdbConnection);
                break;
            }
            case 14: {
                DmdbTimestamp dmdbTimestamp = DmdbTimestamp.valueOf(l2 * 24L * 60L * 60L * 1000L - 2209017600000L, column);
                byArray = dmdbTimestamp.encode(column, iDmdbConnection);
                break;
            }
            default: {
                DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
            }
        }
        return byArray;
    }

    public static byte[] toBit(long l2) {
        byte[] byArray = new byte[]{(byte)(l2 != 0L ? 1 : 0)};
        return byArray;
    }

    public static byte[] toTinyint(long l2) {
        byte[] byArray = new byte[1];
        ByteUtil.setByte(byArray, 0, (byte)l2);
        return byArray;
    }

    public static byte[] toSmallint(long l2) {
        byte[] byArray = new byte[2];
        ByteUtil.setShort(byArray, 0, (short)l2);
        return byArray;
    }

    public static byte[] toInt(long l2) {
        byte[] byArray = new byte[4];
        ByteUtil.setInt(byArray, 0, (int)l2);
        return byArray;
    }

    public static byte[] toBigint(long l2) {
        byte[] byArray = new byte[8];
        ByteUtil.setLong(byArray, 0, l2);
        return byArray;
    }

    public static byte[] toReal(float f2) {
        byte[] byArray = new byte[4];
        ByteUtil.setInt(byArray, 0, Float.floatToIntBits(f2));
        return byArray;
    }

    public static byte[] toDouble(double d2) {
        byte[] byArray = new byte[8];
        ByteUtil.setLong(byArray, 0, Double.doubleToLongBits(d2));
        return byArray;
    }

    public static byte[] toDecimal(String string, int n2, int n3) {
        return DmdbNumeric.valueOf(string, n2, n3).encode();
    }

    public static byte[] toVarchar(String string, Charset charset) {
        byte[] byArray = ByteUtil.fromString(string, charset);
        return byArray;
    }

    private static byte[] toVarchar(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return new byte[0];
        }
        int n2 = byArray.length * 2;
        byte[] byArray2 = new byte[n2];
        int n3 = 0;
        while (n3 < byArray.length) {
            byte[] byArray3 = J2DB.toChar(byArray[n3]);
            byArray2[n3 * 2] = byArray3[0];
            byArray2[n3 * 2 + 1] = byArray3[1];
            ++n3;
        }
        return byArray2;
    }

    private static byte[] toChar(byte by) {
        byte[] byArray = new byte[]{J2DB.getCharByNumVal(by >> 4 & 0xF), J2DB.getCharByNumVal(by & 0xF)};
        return byArray;
    }

    private static byte getCharByNumVal(int n2) {
        if (n2 >= 0 && n2 <= 9) {
            return (byte)(n2 + 48);
        }
        if (n2 >= 10 && n2 <= 15) {
            return (byte)(n2 + 65 - 10);
        }
        DBError.ECJDBC_INVALID_HEX.throwz(new Object[0]);
        return 0;
    }

    private static byte[] toBinary(long l2, int n2) {
        byte[] byArray = new byte[8];
        int n3 = 7;
        byArray[n3--] = (byte)(l2 & 0xFFL);
        byArray[n3--] = (byte)(l2 >>> 8);
        byArray[n3--] = (byte)(l2 >>> 16);
        byArray[n3--] = (byte)(l2 >>> 24);
        byArray[n3--] = (byte)(l2 >>> 32);
        byArray[n3--] = (byte)(l2 >>> 40);
        byArray[n3--] = (byte)(l2 >>> 48);
        byArray[n3--] = (byte)(l2 >>> 56);
        if (n2 > 0 && n2 < byArray.length) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, byArray.length - n2, byArray2, 0, n2);
            return byArray2;
        }
        return byArray;
    }

    private static Object toBlob(Blob blob, Column column, DmdbConnection dmdbConnection) {
        if (J2DB.isOffRow(column.type, blob.length())) {
            return new OffRowBlobData(blob, dmdbConnection.getServerEncoding());
        }
        return blob.getBytes(1L, (int)blob.length());
    }

    private static Object toBlob(byte[] byArray, Column column, IDmdbConnection iDmdbConnection) {
        return J2DB.changeOffRowData(column, byArray, iDmdbConnection.getServerEncoding());
    }

    private static Object toClob(Clob clob, Column column, DmdbConnection dmdbConnection) {
        if (J2DB.isOffRow(column.type, clob.length())) {
            return new OffRowClobData(clob, dmdbConnection.getServerEncoding());
        }
        String string = clob.getSubString(1L, (int)clob.length());
        return ByteUtil.fromString(string, dmdbConnection.getServerEncoding());
    }

    private static Object toClob(String string, Column column, IDmdbConnection iDmdbConnection) {
        return J2DB.changeOffRowData(column, ByteUtil.fromString(string, iDmdbConnection.getServerEncoding()), iDmdbConnection.getServerEncoding());
    }

    private static Object toClob(byte[] byArray, Column column, IDmdbConnection iDmdbConnection) {
        return J2DB.changeOffRowData(column, J2DB.toVarchar(byArray), iDmdbConnection.getServerEncoding());
    }

    private static byte[] toVarbinary(byte[] byArray) {
        return byArray;
    }

    private static byte[] toVarbinary(String string) {
        return StringUtil.hexStringToBytes(string);
    }

    private static boolean isOffRow(int n2, long l2) {
        return (n2 == 12 || n2 == 19) && l2 > 2048L;
    }

    private static Object changeOffRowData(Column column, byte[] byArray, Charset charset) {
        Object object;
        if (J2DB.isOffRow(column.type, byArray.length)) {
            OffRowBytesData offRowBytesData;
            object = offRowBytesData;
            offRowBytesData = new OffRowBytesData(byArray, charset);
        } else {
            object = byArray;
        }
        return object;
    }

    private static void checkReal(double d2) {
        if (d2 < -3.4E38 || d2 > 3.4E38) {
            DBError.EC_DATA_OVERFLOW.throwz(new Object[0]);
        }
    }

    private static void checkBigint(double d2) {
        if (d2 < -9.223372036854776E18 || d2 > 9.223372036854776E18) {
            DBError.EC_DATA_OVERFLOW.throwz(new Object[0]);
        }
    }

    private static void checkInt(double d2) {
        if (d2 < -2.147483648E9 || d2 > 2.147483647E9) {
            DBError.EC_DATA_OVERFLOW.throwz(new Object[0]);
        }
    }

    private static void checkSmallint(double d2) {
        if (d2 < -32768.0 || d2 > 32767.0) {
            DBError.EC_DATA_OVERFLOW.throwz(new Object[0]);
        }
    }

    private static void checkTinyint(double d2) {
        if (d2 < -128.0 || d2 > 127.0) {
            DBError.EC_DATA_OVERFLOW.throwz(new Object[0]);
        }
    }

    private static void checkReal(BigDecimal bigDecimal) {
        if (bigDecimal.compareTo(MIN_REAL_VALUE) < 0 || bigDecimal.compareTo(MAX_REAL_VALUE) > 0) {
            DBError.EC_DATA_OVERFLOW.throwz(new Object[0]);
        }
    }

    private static void checkBigint(BigDecimal bigDecimal) {
        if (bigDecimal.compareTo(MIN_BIGINT_VALUE) < 0 || bigDecimal.compareTo(MAX_BIGINT_VALUE) > 0) {
            DBError.EC_DATA_OVERFLOW.throwz(new Object[0]);
        }
    }

    private static void checkInt(BigDecimal bigDecimal) {
        if (bigDecimal.compareTo(MIN_INT_VALUE) < 0 || bigDecimal.compareTo(MAX_INT_VALUE) > 0) {
            DBError.EC_DATA_OVERFLOW.throwz(new Object[0]);
        }
    }

    private static void checkSmallint(BigDecimal bigDecimal) {
        if (bigDecimal.compareTo(MIN_SMALLINT_VALUE) < 0 || bigDecimal.compareTo(MAX_SMALLINT_VALUE) > 0) {
            DBError.EC_DATA_OVERFLOW.throwz(new Object[0]);
        }
    }

    private static void checkTinyint(BigDecimal bigDecimal) {
        if (bigDecimal.compareTo(MIN_TINYINT_VALUE) < 0 || bigDecimal.compareTo(MAX_TINYINT_VALUE) > 0) {
            DBError.EC_DATA_OVERFLOW.throwz(new Object[0]);
        }
    }

    private static byte[] checkLength(Column column, byte[] byArray, Charset charset) {
        return byArray;
    }
}

