/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbClob;
import dm.jdbc.util.ByteUtil;
import dm.jdbc.util.ConvertUtil;
import java.io.InputStream;
import java.sql.SQLException;

public class DmdbInputStream
extends InputStream {
    public static final int BINARY = 1;
    public static final int ASCII = 2;
    public static final int UNICODE = 3;
    private int type = 1;
    public static final int IS_BLOB = 1;
    public static final int IS_CLOB = 2;
    public static final int IS_BYTE = 3;
    private int objType;
    private Object obj = null;
    private long objPos;
    private long objLength;
    private boolean cut;
    private byte[] buf;
    private int bufPos = 0;
    private long avaliable;

    public DmdbInputStream(Object object) {
        this.obj = object;
        this.objPos = 0L;
        if (object instanceof DmdbBlob) {
            this.objType = 1;
            this.avaliable = this.objLength = ((DmdbBlob)object).do_length();
        } else if (object instanceof DmdbClob) {
            this.objType = 2;
            this.objLength = ((DmdbClob)object).do_length();
            this.avaliable = ((DmdbClob)object).bytesLength;
        } else if (object instanceof byte[]) {
            this.objType = 3;
            this.avaliable = this.objLength = (long)((byte[])object).length;
        } else {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
        }
    }

    protected DmdbInputStream(DmdbBlob dmdbBlob, long l2, long l3) {
        this(dmdbBlob);
        this.objPos = l2 - 1L;
        this.objLength = Math.min(this.objLength, this.objPos + l3);
        this.cut = this.objPos > 0L || this.objLength < dmdbBlob.do_length();
        this.avaliable = this.objLength - this.objPos;
    }

    public DmdbInputStream(Object object, int n2) {
        this(object);
        this.type = n2;
    }

    public Object useRealObject(long l2) {
        switch (this.objType) {
            case 1: 
            case 2: {
                if (this.objPos != 0L || this.cut || -1L != l2 && l2 < this.objLength) break;
                return this.obj;
            }
        }
        return this;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        if (n2 < 0 || n3 < 0 || n3 > byArray.length - n2) {
            throw new IndexOutOfBoundsException();
        }
        if (this.avaliable <= 0L) {
            return -1;
        }
        int n4 = 0;
        while (n4 < n3) {
            int n5 = this.bufLeaveLen();
            if (n5 == 0 && (n5 = this.fillBuffer()) <= 0) break;
            int n6 = n3 - n4;
            int n7 = Math.min(n6, n5);
            System.arraycopy(this.buf, this.bufPos, byArray, n2, n7);
            this.bufPos += n7;
            n2 += n7;
            n4 += n7;
        }
        this.avaliable -= (long)n4;
        return n4 == 0 ? -1 : n4;
    }

    @Override
    public int read() {
        byte[] byArray = new byte[1];
        int n2 = this.read(byArray);
        if (n2 == -1) {
            return -1;
        }
        return byArray[0] & 0xFF;
    }

    @Override
    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int available() {
        return this.obj instanceof DmdbClob ? 0 : (this.avaliable > Integer.MAX_VALUE ? 0 : (int)this.avaliable);
    }

    @Override
    public long skip(long l2) {
        if (this.objType == 2) {
            return super.skip(l2);
        }
        long l3 = Math.min(this.avaliable, l2);
        if (l3 <= 0L) {
            return 0L;
        }
        int n2 = this.bufLeaveLen();
        if (l3 < (long)n2) {
            this.bufPos = (int)((long)this.bufPos + l3);
        } else {
            this.objPos += l3 - (long)n2;
            this.fillBuffer();
        }
        return l3;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized void mark(int n2) {
        super.mark(n2);
    }

    @Override
    public synchronized void reset() {
        super.reset();
    }

    private int bufLeaveLen() {
        return this.buf == null ? 0 : this.buf.length - this.bufPos;
    }

    private int fillBuffer() {
        switch (this.objType) {
            case 1: {
                return this.readFromBlob(32640);
            }
            case 2: {
                return this.readFromClob(16320);
            }
            case 3: {
                return this.readFromBytes();
            }
        }
        DBError.throwIOException(DBError.ECJDBC_DATA_CONVERTION_ERROR.reason);
        return 0;
    }

    private int readFromBytes() {
        long l2 = this.objLength - this.objPos;
        int n2 = 0;
        if (l2 <= 0L) {
            return -1;
        }
        this.buf = (byte[])this.obj;
        n2 = this.buf == null ? 0 : this.buf.length;
        this.objPos += (long)n2;
        this.bufPos = 0;
        return n2;
    }

    private int readFromBlob(int n2) {
        int n3;
        long l2;
        DmdbBlob dmdbBlob;
        block3: {
            dmdbBlob = (DmdbBlob)this.obj;
            l2 = this.objLength - this.objPos;
            n3 = 0;
            if (l2 > 0L) break block3;
            return -1;
        }
        try {
            n2 = (int)Math.min(l2, (long)n2);
            this.buf = dmdbBlob.do_getBytes(this.objPos + 1L, n2);
            n3 = this.buf == null ? 0 : this.buf.length;
            this.objPos += (long)n3;
            this.bufPos = 0;
        }
        catch (SQLException sQLException) {
            System.out.println("objPos: " + this.objPos + ", destLen: " + n2);
            DBError.throwIOException(sQLException.getMessage());
        }
        return n3;
    }

    private int readFromClob(int n2) {
        int n3;
        long l2;
        DmdbClob dmdbClob;
        block3: {
            dmdbClob = (DmdbClob)this.obj;
            l2 = this.objLength - this.objPos;
            n3 = 0;
            if (l2 > 0L) break block3;
            return -1;
        }
        try {
            n2 = (int)Math.min(l2, (long)n2);
            String string = dmdbClob.do_getSubString(this.objPos + 1L, n2);
            this.buf = this.type == 2 ? (string == null ? new byte[]{} : ConvertUtil.StringToAsciiBytes(string)) : (this.type == 3 ? (string == null ? new byte[]{} : ConvertUtil.StringToUnicodeBytes(string)) : (string == null ? new byte[]{} : ByteUtil.fromString(string, dmdbClob.serverEncoding)));
            n3 = this.buf == null ? 0 : this.buf.length;
            this.objPos += (long)n2;
            this.bufPos = 0;
        }
        catch (SQLException sQLException) {
            DBError.throwIOException(sQLException.getMessage());
        }
        return n3;
    }
}

