/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.filter.stat.util;

import dm.jdbc.filter.stat.util.JSONUtils;
import dm.jdbc.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TableFormator {
    public static final int COL_MAX_LEN = 32;

    public static void main(String[] args) {
        String[] titles;
        String[] fields = titles = new String[]{"ID", "SQL", "DESC"};
        HashMap<String, String> obj = new HashMap<String, String>();
        obj.put(fields[0], "123");
        obj.put(fields[1], "select \r\n1    from dual;");
        obj.put(fields[2], "\u8fbe\u68a6\u6570\u636e\u5e93");
        ArrayList<Map<String, Object>> objList = new ArrayList<Map<String, Object>>();
        objList.add(obj);
        TableFormator.addTitles(objList, titles, fields);
        System.out.println(TableFormator.toTable(objList, fields, null, true, false));
    }

    public static int[] calcColLens(List<Map<String, Object>> objList, String[] titles, int maxColLen) {
        int colLen = 0;
        String colVal = null;
        int[] colLens = new int[titles.length];
        for (Map<String, Object> obj : objList) {
            int i2 = 0;
            while (i2 < titles.length) {
                colVal = TableFormator.getColValue(obj.get(titles[i2]));
                colLen = colVal.length();
                if (colLen > colLens[i2]) {
                    colLens[i2] = colLen;
                }
                ++i2;
            }
        }
        if (maxColLen > 0) {
            int i3 = 0;
            while (i3 < titles.length) {
                if (colLens[i3] > maxColLen) {
                    colLens[i3] = maxColLen;
                }
                ++i3;
            }
        }
        return colLens;
    }

    public static void addTitles(List<Map<String, Object>> objList, String[] titles, String[] fields) {
        HashMap<String, String> titleMap = new HashMap<String, String>(fields.length);
        int i2 = 0;
        while (i2 < fields.length) {
            titleMap.put(fields[i2], titles[i2]);
            ++i2;
        }
        objList.add(0, titleMap);
    }

    public static String toTable(List<Map<String, Object>> objList, String[] fields, int[] colLens, boolean showAll, boolean append) {
        if (fields == null || objList == null) {
            return "";
        }
        if (colLens == null) {
            colLens = TableFormator.calcColLens(objList, fields, 32);
        }
        StringBuilder output = new StringBuilder();
        if (!append) {
            TableFormator.sepLine(output, colLens);
        }
        Iterator<Map<String, Object>> iterator = objList.iterator();
        while (iterator.hasNext()) {
            Map obj;
            Map objMore = obj = iterator.next();
            while (objMore != null) {
                objMore = TableFormator.formateLine(output, objMore, fields, colLens, showAll);
            }
            TableFormator.sepLine(output, colLens);
        }
        return output.toString();
    }

    private static Map formateLine(StringBuilder output, Map obj, String[] fields, int[] colLens, boolean showAll) {
        boolean hasMore = false;
        HashMap<String, String> objMore = new HashMap<String, String>();
        int colLen = 0;
        String colVal = null;
        int i2 = 0;
        while (i2 < fields.length) {
            colVal = TableFormator.getColValue(obj.get(fields[i2]));
            colLen = colVal.length();
            if (colLen <= colLens[i2]) {
                output.append('|');
                output.append(colVal);
                TableFormator.blanks(output, colLens[i2] - colLen);
                if (showAll) {
                    objMore.put(fields[i2], "");
                }
            } else {
                output.append('|');
                if (showAll) {
                    output.append(colVal.substring(0, colLens[i2]));
                    objMore.put(fields[i2], colVal.substring(colLens[i2]));
                    hasMore = true;
                } else {
                    output.append(String.valueOf(colVal.substring(0, colLens[i2] - 3)) + "...");
                }
            }
            ++i2;
        }
        output.append('|');
        output.append(StringUtil.LINE_SEPARATOR);
        if (hasMore) {
            return objMore;
        }
        return null;
    }

    private static void sepLine(StringBuilder output, int[] colLens) {
        output.append('+');
        int[] nArray = colLens;
        int n2 = colLens.length;
        int n3 = 0;
        while (n3 < n2) {
            int colLen = nArray[n3];
            int i2 = 0;
            while (i2 < colLen) {
                output.append('-');
                ++i2;
            }
            output.append('+');
            ++n3;
        }
        output.append(StringUtil.LINE_SEPARATOR);
    }

    private static void blanks(StringBuilder output, int count) {
        while (count > 0) {
            output.append(' ');
            --count;
        }
    }

    private static String getColValue(Object colObj) {
        String colVal = colObj == null ? "null" : (colObj.getClass().isArray() ? JSONUtils.toJSONString(colObj) : colObj.toString());
        colVal = colVal.replace('\t', ' ');
        colVal = colVal.replace('\n', ' ');
        colVal = colVal.replace('\r', ' ');
        return colVal;
    }
}

