/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.filter;

import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmDriver;
import dm.jdbc.driver.DmdbCallableStatement;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbIntervalDT;
import dm.jdbc.driver.DmdbIntervalYM;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.driver.DmdbTimestamp;
import dm.jdbc.filter.BaseFilter;
import dm.jdbc.filter.FilterChain;
import dm.jdbc.internal.conf.DmProperties;
import dm.jdbc.internal.conf.EP;
import dm.jdbc.util.StringUtil;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Map;
import java.util.concurrent.Executor;

public class DscParallelFilter
extends BaseFilter {
    private DscParallelFilter() {
    }

    public static DscParallelFilter getInstance() {
        return DscParallelFilterThreadHolder.instance;
    }

    private boolean doReconnect(DmdbConnection connection, SQLException e2) throws SQLException {
        if (e2.getErrorCode() != DBError.EC_SWITCH_TO_EP_SEQNO.errCode) {
            throw e2;
        }
        String errMsg = e2.getMessage();
        int idx = errMsg.lastIndexOf("_");
        connection.switchToEpSeqno = Integer.parseInt(StringUtil.trimToEmpty(errMsg.substring(idx + 1)));
        return true;
    }

    private DmdbPreparedStatement getCurrent(DmdbPreparedStatement preparedStatement) {
        return (DmdbPreparedStatement)preparedStatement.tempMap.get(preparedStatement.connection.switchToEpSeqno);
    }

    private DmdbCallableStatement getCurrent(DmdbCallableStatement callableStatement) {
        return (DmdbCallableStatement)callableStatement.tempMap.get(callableStatement.connection.switchToEpSeqno);
    }

    private DmdbStatement getCurrent(DmdbStatement statement) {
        return statement.tempMap.get(statement.connection.switchToEpSeqno);
    }

    private DmdbConnection getCurrent(DmdbConnection connection) {
        return connection.tempMap.get(connection.switchToEpSeqno);
    }

    @Override
    public Connection Driver_connect(FilterChain filterChain, DmDriver driver, DmProperties props) throws SQLException {
        final DmdbConnection connection = (DmdbConnection)super.Driver_connect(filterChain, driver, props);
        if (connection.epGroup == null || connection.epGroup.epList.size() == 0) {
            return connection;
        }
        DscParallelFilter.doTaskParallel(connection.epGroup.epList.toArray(new EP[0]), new BaseFilter.FilterCallback<EP>(){

            @Override
            public void run(EP ep) throws SQLException {
                if (StringUtil.equalsIgnoreCase(ep.host, connection.host) && ep.port == connection.port) {
                    connection.tempMap.put(ep.epSeqno, connection);
                } else {
                    DmdbConnection conn = new DmdbConnection(connection.props);
                    ep.connect(conn);
                    connection.tempMap.put(ep.epSeqno, conn);
                }
            }
        });
        connection.switchToEpSeqno = connection.ep.epSeqno;
        return connection;
    }

    @Override
    public void Connection_close(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        DscParallelFilter.doTaskParallel(connection.tempMap.values().toArray(new DmdbConnection[0]), new BaseFilter.FilterCallback<DmdbConnection>(){

            @Override
            public void run(DmdbConnection siteObject) throws SQLException {
                siteObject.do_close();
            }
        });
    }

    @Override
    public void Connection_commit(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        DscParallelFilter.doTaskParallel(connection.tempMap.values().toArray(new DmdbConnection[0]), new BaseFilter.FilterCallback<DmdbConnection>(){

            @Override
            public void run(DmdbConnection siteObject) throws SQLException {
                siteObject.do_commit();
            }
        });
    }

    @Override
    public void Connection_rollback(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        DscParallelFilter.doTaskParallel(connection.tempMap.values().toArray(new DmdbConnection[0]), new BaseFilter.FilterCallback<DmdbConnection>(){

            @Override
            public void run(DmdbConnection siteObject) throws SQLException {
                siteObject.do_rollback();
            }
        });
    }

    @Override
    public void Connection_setAutoCommit(FilterChain filterChain, DmdbConnection connection, final boolean autoCommit) throws SQLException {
        DscParallelFilter.doTaskParallel(connection.tempMap.values().toArray(new DmdbConnection[0]), new BaseFilter.FilterCallback<DmdbConnection>(){

            @Override
            public void run(DmdbConnection siteObject) throws SQLException {
                siteObject.do_setAutoCommit(autoCommit);
            }
        });
    }

    @Override
    public void Connection_setHoldability(FilterChain filterChain, DmdbConnection connection, final int holdability) throws SQLException {
        DscParallelFilter.doTaskParallel(connection.tempMap.values().toArray(new DmdbConnection[0]), new BaseFilter.FilterCallback<DmdbConnection>(){

            @Override
            public void run(DmdbConnection siteObject) throws SQLException {
                siteObject.do_setHoldability(holdability);
            }
        });
    }

    @Override
    public void Connection_setReadOnly(FilterChain filterChain, DmdbConnection connection, final boolean readOnly) throws SQLException {
        DscParallelFilter.doTaskParallel(connection.tempMap.values().toArray(new DmdbConnection[0]), new BaseFilter.FilterCallback<DmdbConnection>(){

            @Override
            public void run(DmdbConnection siteObject) throws SQLException {
                siteObject.do_setReadOnly(readOnly);
            }
        });
    }

    @Override
    public void Connection_setSchema(FilterChain filterChain, DmdbConnection connection, final String schema) throws SQLException {
        DscParallelFilter.doTaskParallel(connection.tempMap.values().toArray(new DmdbConnection[0]), new BaseFilter.FilterCallback<DmdbConnection>(){

            @Override
            public void run(DmdbConnection siteObject) throws SQLException {
                siteObject.do_setSchema(schema);
            }
        });
    }

    @Override
    public void Connection_setTransactionIsolation(FilterChain filterChain, DmdbConnection connection, final int level) throws SQLException {
        DscParallelFilter.doTaskParallel(connection.tempMap.values().toArray(new DmdbConnection[0]), new BaseFilter.FilterCallback<DmdbConnection>(){

            @Override
            public void run(DmdbConnection siteObject) throws SQLException {
                siteObject.do_setTransactionIsolation(level);
            }
        });
    }

    @Override
    public void Connection_clearWarnings(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        DscParallelFilter.doTaskParallel(connection.tempMap.values().toArray(new DmdbConnection[0]), new BaseFilter.FilterCallback<DmdbConnection>(){

            @Override
            public void run(DmdbConnection siteObject) throws SQLException {
                siteObject.do_clearWarnings();
            }
        });
    }

    @Override
    public void Connection_setTypeMap(FilterChain filterChain, DmdbConnection connection, final Map<String, Class<?>> map) throws SQLException {
        DscParallelFilter.doTaskParallel(connection.tempMap.values().toArray(new DmdbConnection[0]), new BaseFilter.FilterCallback<DmdbConnection>(){

            @Override
            public void run(DmdbConnection siteObject) throws SQLException {
                siteObject.do_setTypeMap(map);
            }
        });
    }

    @Override
    public Savepoint Connection_setSavepoint(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return null;
    }

    @Override
    public Savepoint Connection_setSavepoint(FilterChain filterChain, DmdbConnection connection, String name) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return null;
    }

    @Override
    public void Connection_rollback(FilterChain filterChain, DmdbConnection connection, Savepoint savepoint) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public void Connection_releaseSavepoint(FilterChain filterChain, DmdbConnection connection, Savepoint savepoint) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public void Connection_setNetworkTimeout(FilterChain filterChain, DmdbConnection connection, final Executor executor, final int milliseconds) throws SQLException {
        DscParallelFilter.doTaskParallel(connection.tempMap.values().toArray(new DmdbConnection[0]), new BaseFilter.FilterCallback<DmdbConnection>(){

            @Override
            public void run(DmdbConnection siteObject) throws SQLException {
                siteObject.do_setNetworkTimeout(executor, milliseconds);
            }
        });
    }

    @Override
    public Statement Connection_createStatement(FilterChain filterChain, final DmdbConnection connection, final int resultSetType, final int resultSetConcurrency) throws SQLException {
        final DmdbStatement stmt = connection.do_createStatement(resultSetType, resultSetConcurrency);
        DscParallelFilter.doTaskParallel(connection.tempMap.values().toArray(new DmdbConnection[0]), new BaseFilter.FilterCallback<DmdbConnection>(){

            @Override
            public void run(DmdbConnection siteObject) throws SQLException {
                if (siteObject == connection) {
                    stmt.tempMap.put(siteObject.ep.epSeqno, stmt);
                } else {
                    stmt.tempMap.put(siteObject.ep.epSeqno, siteObject.do_createStatement(resultSetType, resultSetConcurrency));
                }
            }
        });
        return stmt;
    }

    @Override
    public Statement Connection_createStatement(FilterChain filterChain, final DmdbConnection connection) throws SQLException {
        final DmdbStatement stmt = connection.do_createStatement();
        DscParallelFilter.doTaskParallel(connection.tempMap.values().toArray(new DmdbConnection[0]), new BaseFilter.FilterCallback<DmdbConnection>(){

            @Override
            public void run(DmdbConnection siteObject) throws SQLException {
                if (siteObject == connection) {
                    stmt.tempMap.put(siteObject.ep.epSeqno, stmt);
                } else {
                    stmt.tempMap.put(siteObject.ep.epSeqno, siteObject.do_createStatement());
                }
            }
        });
        return stmt;
    }

    @Override
    public Statement Connection_createStatement(FilterChain filterChain, final DmdbConnection connection, final int resultSetType, final int resultSetConcurrency, final int resultSetHoldability) throws SQLException {
        final DmdbStatement stmt = connection.do_createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        DscParallelFilter.doTaskParallel(connection.tempMap.values().toArray(new DmdbConnection[0]), new BaseFilter.FilterCallback<DmdbConnection>(){

            @Override
            public void run(DmdbConnection siteObject) throws SQLException {
                if (siteObject == connection) {
                    stmt.tempMap.put(siteObject.ep.epSeqno, stmt);
                } else {
                    stmt.tempMap.put(siteObject.ep.epSeqno, siteObject.do_createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
                }
            }
        });
        return stmt;
    }

    @Override
    public CallableStatement Connection_prepareCall(FilterChain filterChain, final DmdbConnection connection, final String sql) throws SQLException {
        final DmdbCallableStatement cstmt = connection.do_prepareCall(sql);
        DscParallelFilter.doTaskParallel(connection.tempMap.values().toArray(new DmdbConnection[0]), new BaseFilter.FilterCallback<DmdbConnection>(){

            @Override
            public void run(DmdbConnection siteObject) throws SQLException {
                if (siteObject == connection) {
                    cstmt.tempMap.put(siteObject.ep.epSeqno, cstmt);
                } else {
                    cstmt.tempMap.put(siteObject.ep.epSeqno, siteObject.do_prepareCall(sql));
                }
            }
        });
        return cstmt;
    }

    @Override
    public CallableStatement Connection_prepareCall(FilterChain filterChain, final DmdbConnection connection, final String sql, final int resultSetType, final int resultSetConcurrency, final int resultSetHoldability) throws SQLException {
        final DmdbCallableStatement cstmt = connection.do_prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        DscParallelFilter.doTaskParallel(connection.tempMap.values().toArray(new DmdbConnection[0]), new BaseFilter.FilterCallback<DmdbConnection>(){

            @Override
            public void run(DmdbConnection siteObject) throws SQLException {
                if (siteObject == connection) {
                    cstmt.tempMap.put(siteObject.ep.epSeqno, cstmt);
                } else {
                    cstmt.tempMap.put(siteObject.ep.epSeqno, siteObject.do_prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
                }
            }
        });
        return cstmt;
    }

    @Override
    public CallableStatement Connection_prepareCall(FilterChain filterChain, final DmdbConnection connection, final String sql, final int resultSetType, final int resultSetConcurrency) throws SQLException {
        final DmdbCallableStatement cstmt = connection.do_prepareCall(sql, resultSetType, resultSetConcurrency);
        DscParallelFilter.doTaskParallel(connection.tempMap.values().toArray(new DmdbConnection[0]), new BaseFilter.FilterCallback<DmdbConnection>(){

            @Override
            public void run(DmdbConnection siteObject) throws SQLException {
                if (siteObject == connection) {
                    cstmt.tempMap.put(siteObject.ep.epSeqno, cstmt);
                } else {
                    cstmt.tempMap.put(siteObject.ep.epSeqno, siteObject.do_prepareCall(sql, resultSetType, resultSetConcurrency));
                }
            }
        });
        return cstmt;
    }

    @Override
    public PreparedStatement Connection_prepareStatement(FilterChain filterChain, final DmdbConnection connection, final String sql, final int[] columnIndexes) throws SQLException {
        final DmdbPreparedStatement pstmt = connection.do_prepareStatement(sql, columnIndexes);
        DscParallelFilter.doTaskParallel(connection.tempMap.values().toArray(new DmdbConnection[0]), new BaseFilter.FilterCallback<DmdbConnection>(){

            @Override
            public void run(DmdbConnection siteObject) throws SQLException {
                if (siteObject == connection) {
                    pstmt.tempMap.put(siteObject.ep.epSeqno, pstmt);
                } else {
                    pstmt.tempMap.put(siteObject.ep.epSeqno, siteObject.do_prepareStatement(sql, columnIndexes));
                }
            }
        });
        return pstmt;
    }

    @Override
    public PreparedStatement Connection_prepareStatement(FilterChain filterChain, final DmdbConnection connection, final String sql, final String[] columnNames) throws SQLException {
        final DmdbPreparedStatement pstmt = connection.do_prepareStatement(sql, columnNames);
        DscParallelFilter.doTaskParallel(connection.tempMap.values().toArray(new DmdbConnection[0]), new BaseFilter.FilterCallback<DmdbConnection>(){

            @Override
            public void run(DmdbConnection siteObject) throws SQLException {
                if (siteObject == connection) {
                    pstmt.tempMap.put(siteObject.ep.epSeqno, pstmt);
                } else {
                    pstmt.tempMap.put(siteObject.ep.epSeqno, siteObject.do_prepareStatement(sql, columnNames));
                }
            }
        });
        return pstmt;
    }

    @Override
    public PreparedStatement Connection_prepareStatement(FilterChain filterChain, final DmdbConnection connection, final String sql) throws SQLException {
        final DmdbPreparedStatement pstmt = connection.do_prepareStatement(sql);
        DscParallelFilter.doTaskParallel(connection.tempMap.values().toArray(new DmdbConnection[0]), new BaseFilter.FilterCallback<DmdbConnection>(){

            @Override
            public void run(DmdbConnection siteObject) throws SQLException {
                if (siteObject == connection) {
                    pstmt.tempMap.put(siteObject.ep.epSeqno, pstmt);
                } else {
                    pstmt.tempMap.put(siteObject.ep.epSeqno, siteObject.do_prepareStatement(sql));
                }
            }
        });
        return pstmt;
    }

    @Override
    public PreparedStatement Connection_prepareStatement(FilterChain filterChain, final DmdbConnection connection, final String sql, final int resultSetType, final int resultSetConcurrency) throws SQLException {
        final DmdbPreparedStatement pstmt = connection.do_prepareStatement(sql, resultSetType, resultSetConcurrency);
        DscParallelFilter.doTaskParallel(connection.tempMap.values().toArray(new DmdbConnection[0]), new BaseFilter.FilterCallback<DmdbConnection>(){

            @Override
            public void run(DmdbConnection siteObject) throws SQLException {
                if (siteObject == connection) {
                    pstmt.tempMap.put(siteObject.ep.epSeqno, pstmt);
                } else {
                    pstmt.tempMap.put(siteObject.ep.epSeqno, siteObject.do_prepareStatement(sql, resultSetType, resultSetConcurrency));
                }
            }
        });
        return pstmt;
    }

    @Override
    public PreparedStatement Connection_prepareStatement(FilterChain filterChain, final DmdbConnection connection, final String sql, final int resultSetType, final int resultSetConcurrency, final int resultSetHoldability) throws SQLException {
        final DmdbPreparedStatement pstmt = connection.do_prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        DscParallelFilter.doTaskParallel(connection.tempMap.values().toArray(new DmdbConnection[0]), new BaseFilter.FilterCallback<DmdbConnection>(){

            @Override
            public void run(DmdbConnection siteObject) throws SQLException {
                if (siteObject == connection) {
                    pstmt.tempMap.put(siteObject.ep.epSeqno, pstmt);
                } else {
                    pstmt.tempMap.put(siteObject.ep.epSeqno, siteObject.do_prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
                }
            }
        });
        return pstmt;
    }

    @Override
    public PreparedStatement Connection_prepareStatement(FilterChain filterChain, final DmdbConnection connection, final String sql, final int autoGeneratedKeys) throws SQLException {
        final DmdbPreparedStatement pstmt = connection.do_prepareStatement(sql, autoGeneratedKeys);
        DscParallelFilter.doTaskParallel(connection.tempMap.values().toArray(new DmdbConnection[0]), new BaseFilter.FilterCallback<DmdbConnection>(){

            @Override
            public void run(DmdbConnection siteObject) throws SQLException {
                if (siteObject == connection) {
                    pstmt.tempMap.put(siteObject.ep.epSeqno, pstmt);
                } else {
                    pstmt.tempMap.put(siteObject.ep.epSeqno, siteObject.do_prepareStatement(sql, autoGeneratedKeys));
                }
            }
        });
        return pstmt;
    }

    @Override
    public void PreparedStatement_clearParameters(FilterChain filterChain, DmdbPreparedStatement preparedStatement) throws SQLException {
        DscParallelFilter.doTaskParallel(preparedStatement.tempMap.values().toArray(new DmdbPreparedStatement[0]), new BaseFilter.FilterCallback<DmdbPreparedStatement>(){

            @Override
            public void run(DmdbPreparedStatement siteObject) throws SQLException {
                siteObject.do_clearParameters();
            }
        });
    }

    @Override
    public boolean Statement_execute(FilterChain filterChain, DmdbStatement statement, String sql) throws SQLException {
        boolean ret;
        block2: {
            ret = false;
            try {
                ret = this.getCurrent(statement).do_execute(sql);
            }
            catch (SQLException e2) {
                if (!this.doReconnect(statement.connection, e2)) break block2;
                ret = this.getCurrent(statement).do_execute(sql);
            }
        }
        return ret;
    }

    @Override
    public boolean Statement_execute(FilterChain filterChain, DmdbStatement statement, String sql, int autoGeneratedKeys) throws SQLException {
        boolean ret;
        block2: {
            ret = false;
            try {
                ret = this.getCurrent(statement).do_execute(sql, autoGeneratedKeys);
            }
            catch (SQLException e2) {
                if (!this.doReconnect(statement.connection, e2)) break block2;
                ret = this.getCurrent(statement).do_execute(sql, autoGeneratedKeys);
            }
        }
        return ret;
    }

    @Override
    public boolean Statement_execute(FilterChain filterChain, DmdbStatement statement, String sql, int[] columnIndexes) throws SQLException {
        boolean ret;
        block2: {
            ret = false;
            try {
                ret = this.getCurrent(statement).do_execute(sql, columnIndexes);
            }
            catch (SQLException e2) {
                if (!this.doReconnect(statement.connection, e2)) break block2;
                ret = this.getCurrent(statement).do_execute(sql, columnIndexes);
            }
        }
        return ret;
    }

    @Override
    public boolean Statement_execute(FilterChain filterChain, DmdbStatement statement, String sql, String[] columnNames) throws SQLException {
        boolean ret;
        block2: {
            ret = false;
            try {
                ret = this.getCurrent(statement).do_execute(sql, columnNames);
            }
            catch (SQLException e2) {
                if (!this.doReconnect(statement.connection, e2)) break block2;
                ret = this.getCurrent(statement).do_execute(sql, columnNames);
            }
        }
        return ret;
    }

    @Override
    public int[] Statement_executeBatch(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        int[] ret;
        block2: {
            ret = null;
            try {
                ret = this.getCurrent(statement).do_executeBatch();
            }
            catch (SQLException e2) {
                if (!this.doReconnect(statement.connection, e2)) break block2;
                ret = this.getCurrent(statement).do_executeBatch();
            }
        }
        return ret;
    }

    @Override
    public long[] Statement_executeLargeBatch(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        long[] ret;
        block2: {
            ret = null;
            try {
                ret = this.getCurrent(statement).do_executeLargeBatch();
            }
            catch (SQLException e2) {
                if (!this.doReconnect(statement.connection, e2)) break block2;
                ret = this.getCurrent(statement).do_executeLargeBatch();
            }
        }
        return ret;
    }

    @Override
    public long Statement_executeLargeUpdate(FilterChain filterChain, DmdbStatement statement, String sql, int autoGeneratedKeys) throws SQLException {
        long ret;
        block2: {
            ret = 0L;
            try {
                ret = this.getCurrent(statement).do_executeLargeUpdate(sql, autoGeneratedKeys);
            }
            catch (SQLException e2) {
                if (!this.doReconnect(statement.connection, e2)) break block2;
                ret = this.getCurrent(statement).do_executeLargeUpdate(sql, autoGeneratedKeys);
            }
        }
        return ret;
    }

    @Override
    public long Statement_executeLargeUpdate(FilterChain filterChain, DmdbStatement statement, String sql) throws SQLException {
        long ret;
        block2: {
            ret = 0L;
            try {
                ret = this.getCurrent(statement).do_executeLargeUpdate(sql);
            }
            catch (SQLException e2) {
                if (!this.doReconnect(statement.connection, e2)) break block2;
                ret = this.getCurrent(statement).do_executeLargeUpdate(sql);
            }
        }
        return ret;
    }

    @Override
    public long Statement_executeLargeUpdate(FilterChain filterChain, DmdbStatement statement, String sql, int[] columnIndexes) throws SQLException {
        long ret;
        block2: {
            ret = 0L;
            try {
                ret = this.getCurrent(statement).do_executeLargeUpdate(sql, columnIndexes);
            }
            catch (SQLException e2) {
                if (!this.doReconnect(statement.connection, e2)) break block2;
                ret = this.getCurrent(statement).do_executeLargeUpdate(sql, columnIndexes);
            }
        }
        return ret;
    }

    @Override
    public long Statement_executeLargeUpdate(FilterChain filterChain, DmdbStatement statement, String sql, String[] columnNames) throws SQLException {
        long ret;
        block2: {
            ret = 0L;
            try {
                ret = this.getCurrent(statement).do_executeLargeUpdate(sql, columnNames);
            }
            catch (SQLException e2) {
                if (!this.doReconnect(statement.connection, e2)) break block2;
                ret = this.getCurrent(statement).do_executeLargeUpdate(sql, columnNames);
            }
        }
        return ret;
    }

    @Override
    public ResultSet Statement_executeQuery(FilterChain filterChain, DmdbStatement statement, String sql) throws SQLException {
        DmdbResultSet ret;
        block2: {
            ret = null;
            try {
                ret = this.getCurrent(statement).do_executeQuery(sql);
            }
            catch (SQLException e2) {
                if (!this.doReconnect(statement.connection, e2)) break block2;
                ret = this.getCurrent(statement).do_executeQuery(sql);
            }
        }
        return ret;
    }

    @Override
    public int Statement_executeUpdate(FilterChain filterChain, DmdbStatement statement, String sql, int autoGeneratedKeys) throws SQLException {
        int ret;
        block2: {
            ret = 0;
            try {
                ret = this.getCurrent(statement).do_executeUpdate(sql, autoGeneratedKeys);
            }
            catch (SQLException e2) {
                if (!this.doReconnect(statement.connection, e2)) break block2;
                ret = this.getCurrent(statement).do_executeUpdate(sql, autoGeneratedKeys);
            }
        }
        return ret;
    }

    @Override
    public int Statement_executeUpdate(FilterChain filterChain, DmdbStatement statement, String sql, String[] columnNames) throws SQLException {
        int ret;
        block2: {
            ret = 0;
            try {
                ret = this.getCurrent(statement).do_executeUpdate(sql, columnNames);
            }
            catch (SQLException e2) {
                if (!this.doReconnect(statement.connection, e2)) break block2;
                ret = this.getCurrent(statement).do_executeUpdate(sql, columnNames);
            }
        }
        return ret;
    }

    @Override
    public int Statement_executeUpdate(FilterChain filterChain, DmdbStatement statement, String sql, int[] columnIndexes) throws SQLException {
        int ret;
        block2: {
            ret = 0;
            try {
                ret = this.getCurrent(statement).do_executeUpdate(sql, columnIndexes);
            }
            catch (SQLException e2) {
                if (!this.doReconnect(statement.connection, e2)) break block2;
                ret = this.getCurrent(statement).do_executeUpdate(sql, columnIndexes);
            }
        }
        return ret;
    }

    @Override
    public int Statement_executeUpdate(FilterChain filterChain, DmdbStatement statement, String sql) throws SQLException {
        int ret;
        block2: {
            ret = 0;
            try {
                ret = this.getCurrent(statement).do_executeUpdate(sql);
            }
            catch (SQLException e2) {
                if (!this.doReconnect(statement.connection, e2)) break block2;
                ret = this.getCurrent(statement).do_executeUpdate(sql);
            }
        }
        return ret;
    }

    @Override
    public boolean PreparedStatement_execute(FilterChain filterChain, DmdbPreparedStatement preparedStatement) throws SQLException {
        boolean ret;
        block2: {
            ret = false;
            try {
                ret = this.getCurrent(preparedStatement).do_execute();
            }
            catch (SQLException e2) {
                if (!this.doReconnect(preparedStatement.connection, e2)) break block2;
                ret = this.getCurrent(preparedStatement).do_execute();
            }
        }
        return ret;
    }

    @Override
    public int[] PreparedStatement_executeBatch(FilterChain filterChain, DmdbPreparedStatement preparedStatement) throws SQLException {
        int[] ret;
        block2: {
            ret = null;
            try {
                ret = this.getCurrent(preparedStatement).do_executeBatch();
            }
            catch (SQLException e2) {
                if (!this.doReconnect(preparedStatement.connection, e2)) break block2;
                ret = this.getCurrent(preparedStatement).do_executeBatch();
            }
        }
        return ret;
    }

    @Override
    public long[] PreparedStatement_executeLargeBatch(FilterChain filterChain, DmdbPreparedStatement preparedStatement) throws SQLException {
        long[] ret;
        block2: {
            ret = null;
            try {
                ret = this.getCurrent(preparedStatement).do_executeLargeBatch();
            }
            catch (SQLException e2) {
                if (!this.doReconnect(preparedStatement.connection, e2)) break block2;
                ret = this.getCurrent(preparedStatement).do_executeLargeBatch();
            }
        }
        return ret;
    }

    @Override
    public long PreparedStatement_executeLargeUpdate(FilterChain filterChain, DmdbPreparedStatement preparedStatement) throws SQLException {
        long ret;
        block2: {
            ret = 0L;
            try {
                ret = this.getCurrent(preparedStatement).do_executeLargeUpdate();
            }
            catch (SQLException e2) {
                if (!this.doReconnect(preparedStatement.connection, e2)) break block2;
                ret = this.getCurrent(preparedStatement).do_executeLargeUpdate();
            }
        }
        return ret;
    }

    @Override
    public ResultSet PreparedStatement_executeQuery(FilterChain filterChain, DmdbPreparedStatement preparedStatement) throws SQLException {
        DmdbResultSet ret;
        block2: {
            ret = null;
            try {
                ret = this.getCurrent(preparedStatement).do_executeQuery();
            }
            catch (SQLException e2) {
                if (!this.doReconnect(preparedStatement.connection, e2)) break block2;
                ret = this.getCurrent(preparedStatement).do_executeQuery();
            }
        }
        return ret;
    }

    @Override
    public int PreparedStatement_executeUpdate(FilterChain filterChain, DmdbPreparedStatement preparedStatement) throws SQLException {
        int ret;
        block6: {
            ret = 0;
            try {
                ret = this.getCurrent(preparedStatement).do_executeUpdate();
            }
            catch (SQLException e2) {
                if (e2.getErrorCode() == -6111) {
                    System.out.println("Params/execParams: " + Arrays.toString(preparedStatement.serverParameters) + "/" + Arrays.toString(preparedStatement.bindParameters));
                }
                if (!this.doReconnect(preparedStatement.connection, e2)) break block6;
                try {
                    ret = this.getCurrent(preparedStatement).do_executeUpdate();
                }
                catch (SQLException se) {
                    if (se.getErrorCode() == -6111) {
                        System.out.println("reconnect Params/execParams: " + Arrays.toString(preparedStatement.serverParameters) + "/" + Arrays.toString(preparedStatement.bindParameters));
                    }
                    throw se;
                }
            }
        }
        return ret;
    }

    @Override
    public void Statement_close(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        DscParallelFilter.doTaskParallel(statement.tempMap.values().toArray(new DmdbStatement[0]), new BaseFilter.FilterCallback<DmdbStatement>(){

            @Override
            public void run(DmdbStatement siteObject) throws SQLException {
                siteObject.do_close();
            }
        });
    }

    @Override
    public void Statement_setCursorName(FilterChain filterChain, DmdbStatement statement, final String name) throws SQLException {
        DscParallelFilter.doTaskParallel(statement.tempMap.values().toArray(new DmdbStatement[0]), new BaseFilter.FilterCallback<DmdbStatement>(){

            @Override
            public void run(DmdbStatement siteObject) throws SQLException {
                siteObject.do_setCursorName(name);
            }
        });
    }

    @Override
    public void Statement_setEscapeProcessing(FilterChain filterChain, DmdbStatement statement, final boolean enable) throws SQLException {
        DscParallelFilter.doTaskParallel(statement.tempMap.values().toArray(new DmdbStatement[0]), new BaseFilter.FilterCallback<DmdbStatement>(){

            @Override
            public void run(DmdbStatement siteObject) throws SQLException {
                siteObject.do_setEscapeProcessing(enable);
            }
        });
    }

    @Override
    public void Statement_setFetchDirection(FilterChain filterChain, DmdbStatement statement, final int direction) throws SQLException {
        DscParallelFilter.doTaskParallel(statement.tempMap.values().toArray(new DmdbStatement[0]), new BaseFilter.FilterCallback<DmdbStatement>(){

            @Override
            public void run(DmdbStatement siteObject) throws SQLException {
                siteObject.do_setFetchDirection(direction);
            }
        });
    }

    @Override
    public void Statement_setFetchSize(FilterChain filterChain, DmdbStatement statement, final int rows) throws SQLException {
        DscParallelFilter.doTaskParallel(statement.tempMap.values().toArray(new DmdbStatement[0]), new BaseFilter.FilterCallback<DmdbStatement>(){

            @Override
            public void run(DmdbStatement siteObject) throws SQLException {
                siteObject.do_setFetchSize(rows);
            }
        });
    }

    @Override
    public void Statement_setLargeMaxRows(FilterChain filterChain, DmdbStatement statement, final long max) throws SQLException {
        DscParallelFilter.doTaskParallel(statement.tempMap.values().toArray(new DmdbStatement[0]), new BaseFilter.FilterCallback<DmdbStatement>(){

            @Override
            public void run(DmdbStatement siteObject) throws SQLException {
                siteObject.do_setLargeMaxRows(max);
            }
        });
    }

    @Override
    public void Statement_setMaxFieldSize(FilterChain filterChain, DmdbStatement statement, final int max) throws SQLException {
        DscParallelFilter.doTaskParallel(statement.tempMap.values().toArray(new DmdbStatement[0]), new BaseFilter.FilterCallback<DmdbStatement>(){

            @Override
            public void run(DmdbStatement siteObject) throws SQLException {
                siteObject.do_setMaxFieldSize(max);
            }
        });
    }

    @Override
    public void Statement_setMaxRows(FilterChain filterChain, DmdbStatement statement, final int max) throws SQLException {
        DscParallelFilter.doTaskParallel(statement.tempMap.values().toArray(new DmdbStatement[0]), new BaseFilter.FilterCallback<DmdbStatement>(){

            @Override
            public void run(DmdbStatement siteObject) throws SQLException {
                siteObject.do_setMaxRows(max);
            }
        });
    }

    @Override
    public void Statement_setQueryTimeout(FilterChain filterChain, DmdbStatement statement, final int seconds) throws SQLException {
        DscParallelFilter.doTaskParallel(statement.tempMap.values().toArray(new DmdbStatement[0]), new BaseFilter.FilterCallback<DmdbStatement>(){

            @Override
            public void run(DmdbStatement siteObject) throws SQLException {
                siteObject.do_setQueryTimeout(seconds);
            }
        });
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex, int sqlType) throws SQLException {
        this.getCurrent(callableStatement).do_registerOutParameter(parameterIndex, sqlType);
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex, int sqlType, int scale) throws SQLException {
        this.getCurrent(callableStatement).do_registerOutParameter(parameterIndex, sqlType, scale);
    }

    @Override
    public boolean CallableStatement_wasNull(FilterChain filterChain, DmdbCallableStatement callableStatement) throws SQLException {
        return this.getCurrent(callableStatement).do_wasNull();
    }

    @Override
    public String CallableStatement_getString(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return this.getCurrent(callableStatement).do_getString(parameterIndex);
    }

    @Override
    public boolean CallableStatement_getBoolean(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return this.getCurrent(callableStatement).do_getBoolean(parameterIndex);
    }

    @Override
    public byte CallableStatement_getByte(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return this.getCurrent(callableStatement).do_getByte(parameterIndex);
    }

    @Override
    public short CallableStatement_getShort(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return this.getCurrent(callableStatement).do_getShort(parameterIndex);
    }

    @Override
    public int CallableStatement_getInt(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return this.getCurrent(callableStatement).do_getInt(parameterIndex);
    }

    @Override
    public long CallableStatement_getLong(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return this.getCurrent(callableStatement).do_getLong(parameterIndex);
    }

    @Override
    public float CallableStatement_getFloat(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return this.getCurrent(callableStatement).do_getFloat(parameterIndex);
    }

    @Override
    public double CallableStatement_getDouble(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return this.getCurrent(callableStatement).do_getDouble(parameterIndex);
    }

    @Override
    public BigDecimal CallableStatement_getBigDecimal(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex, int scale) throws SQLException {
        return this.getCurrent(callableStatement).do_getBigDecimal(parameterIndex, scale);
    }

    @Override
    public byte[] CallableStatement_getBytes(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return this.getCurrent(callableStatement).do_getBytes(parameterIndex);
    }

    @Override
    public Date CallableStatement_getDate(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return this.getCurrent(callableStatement).do_getDate(parameterIndex);
    }

    @Override
    public Time CallableStatement_getTime(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return this.getCurrent(callableStatement).do_getTime(parameterIndex);
    }

    @Override
    public Timestamp CallableStatement_getTimestamp(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return this.getCurrent(callableStatement).do_getTimestamp(parameterIndex);
    }

    @Override
    public Object CallableStatement_getObject(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return this.getCurrent(callableStatement).do_getObject(parameterIndex);
    }

    @Override
    public BigDecimal CallableStatement_getBigDecimal(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return this.getCurrent(callableStatement).do_getBigDecimal(parameterIndex);
    }

    @Override
    public Object CallableStatement_getObject(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex, Map<String, Class<?>> map) throws SQLException {
        return this.getCurrent(callableStatement).do_getObject(parameterIndex, map);
    }

    @Override
    public Ref CallableStatement_getRef(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return this.getCurrent(callableStatement).do_getRef(parameterIndex);
    }

    @Override
    public Blob CallableStatement_getBlob(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return this.getCurrent(callableStatement).do_getBlob(parameterIndex);
    }

    @Override
    public Clob CallableStatement_getClob(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return this.getCurrent(callableStatement).do_getClob(parameterIndex);
    }

    @Override
    public Array CallableStatement_getArray(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return this.getCurrent(callableStatement).do_getArray(parameterIndex);
    }

    @Override
    public Date CallableStatement_getDate(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex, Calendar cal) throws SQLException {
        return this.getCurrent(callableStatement).do_getDate(parameterIndex, cal);
    }

    @Override
    public Time CallableStatement_getTime(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex, Calendar cal) throws SQLException {
        return this.getCurrent(callableStatement).do_getTime(parameterIndex, cal);
    }

    @Override
    public Timestamp CallableStatement_getTimestamp(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex, Calendar cal) throws SQLException {
        return this.getCurrent(callableStatement).do_getTimestamp(parameterIndex, cal);
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.getCurrent(callableStatement).do_registerOutParameter(parameterIndex, sqlType, typeName);
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, int sqlType) throws SQLException {
        this.getCurrent(callableStatement).do_registerOutParameter(parameterName, sqlType);
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, int sqlType, int scale) throws SQLException {
        this.getCurrent(callableStatement).do_registerOutParameter(parameterName, sqlType, scale);
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, int sqlType, String typeName) throws SQLException {
        this.getCurrent(callableStatement).do_registerOutParameter(parameterName, sqlType, typeName);
    }

    @Override
    public URL CallableStatement_getURL(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return this.getCurrent(callableStatement).do_getURL(parameterIndex);
    }

    @Override
    public void CallableStatement_setURL(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, URL val) throws SQLException {
        this.getCurrent(callableStatement).do_setURL(parameterName, val);
    }

    @Override
    public void CallableStatement_setNull(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, int sqlType) throws SQLException {
        this.getCurrent(callableStatement).do_setNull(parameterName, sqlType);
    }

    @Override
    public void CallableStatement_setBoolean(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, boolean x2) throws SQLException {
        this.getCurrent(callableStatement).do_setBoolean(parameterName, x2);
    }

    @Override
    public void CallableStatement_setByte(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, byte x2) throws SQLException {
        this.getCurrent(callableStatement).do_setByte(parameterName, x2);
    }

    @Override
    public void CallableStatement_setShort(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, short x2) throws SQLException {
        this.getCurrent(callableStatement).do_setShort(parameterName, x2);
    }

    @Override
    public void CallableStatement_setInt(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, int x2) throws SQLException {
        this.getCurrent(callableStatement).do_setInt(parameterName, x2);
    }

    @Override
    public void CallableStatement_setLong(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, long x2) throws SQLException {
        this.getCurrent(callableStatement).do_setLong(parameterName, x2);
    }

    @Override
    public void CallableStatement_setFloat(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, float x2) throws SQLException {
        this.getCurrent(callableStatement).do_setFloat(parameterName, x2);
    }

    @Override
    public void CallableStatement_setDouble(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, double x2) throws SQLException {
        this.getCurrent(callableStatement).do_setDouble(parameterName, x2);
    }

    @Override
    public void CallableStatement_setBigDecimal(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, BigDecimal x2) throws SQLException {
        this.getCurrent(callableStatement).do_setBigDecimal(parameterName, x2);
    }

    @Override
    public void CallableStatement_setString(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, String x2) throws SQLException {
        this.getCurrent(callableStatement).do_setString(parameterName, x2);
    }

    @Override
    public void CallableStatement_setBytes(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, byte[] x2) throws SQLException {
        this.getCurrent(callableStatement).do_setBytes(parameterName, x2);
    }

    @Override
    public void CallableStatement_setDate(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Date x2) throws SQLException {
        this.getCurrent(callableStatement).do_setDate(parameterName, x2);
    }

    @Override
    public void CallableStatement_setTime(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Time x2) throws SQLException {
        this.getCurrent(callableStatement).do_setTime(parameterName, x2);
    }

    @Override
    public void CallableStatement_setTimestamp(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Timestamp x2) throws SQLException {
        this.getCurrent(callableStatement).do_setTimestamp(parameterName, x2);
    }

    @Override
    public void CallableStatement_setAsciiStream(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, InputStream x2, int length) throws SQLException {
        this.getCurrent(callableStatement).do_setAsciiStream(parameterName, x2, length);
    }

    @Override
    public void CallableStatement_setBinaryStream(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, InputStream x2, int length) throws SQLException {
        this.getCurrent(callableStatement).do_setBinaryStream(parameterName, x2, length);
    }

    @Override
    public void CallableStatement_setObject(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Object x2, int targetSqlType, int scale) throws SQLException {
        this.getCurrent(callableStatement).do_setObject(parameterName, x2, targetSqlType, scale);
    }

    @Override
    public void CallableStatement_setObject(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Object x2, int targetSqlType) throws SQLException {
        this.getCurrent(callableStatement).do_setObject(parameterName, x2, targetSqlType);
    }

    @Override
    public void CallableStatement_setObject(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Object x2) throws SQLException {
        this.getCurrent(callableStatement).do_setObject(parameterName, x2);
    }

    @Override
    public void CallableStatement_setCharacterStream(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Reader reader, int length) throws SQLException {
        this.getCurrent(callableStatement).do_setCharacterStream(parameterName, reader, length);
    }

    @Override
    public void CallableStatement_setDate(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Date x2, Calendar cal) throws SQLException {
        this.getCurrent(callableStatement).do_setDate(parameterName, x2, cal);
    }

    @Override
    public void CallableStatement_setTime(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Time x2, Calendar cal) throws SQLException {
        this.getCurrent(callableStatement).do_setTime(parameterName, x2, cal);
    }

    @Override
    public void CallableStatement_setTimestamp(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Timestamp x2, Calendar cal) throws SQLException {
        this.getCurrent(callableStatement).do_setTimestamp(parameterName, x2, cal);
    }

    @Override
    public void CallableStatement_setNull(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, int sqlType, String typeName) throws SQLException {
        this.getCurrent(callableStatement).do_setNull(parameterName, sqlType, typeName);
    }

    @Override
    public String CallableStatement_getString(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return this.getCurrent(callableStatement).do_getString(parameterName);
    }

    @Override
    public boolean CallableStatement_getBoolean(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return this.getCurrent(callableStatement).do_getBoolean(parameterName);
    }

    @Override
    public byte CallableStatement_getByte(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return this.getCurrent(callableStatement).do_getByte(parameterName);
    }

    @Override
    public short CallableStatement_getShort(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return this.getCurrent(callableStatement).do_getShort(parameterName);
    }

    @Override
    public int CallableStatement_getInt(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return this.getCurrent(callableStatement).do_getInt(parameterName);
    }

    @Override
    public long CallableStatement_getLong(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return this.getCurrent(callableStatement).do_getLong(parameterName);
    }

    @Override
    public float CallableStatement_getFloat(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return this.getCurrent(callableStatement).do_getFloat(parameterName);
    }

    @Override
    public double CallableStatement_getDouble(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return this.getCurrent(callableStatement).do_getDouble(parameterName);
    }

    @Override
    public byte[] CallableStatement_getBytes(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return this.getCurrent(callableStatement).do_getBytes(parameterName);
    }

    @Override
    public Date CallableStatement_getDate(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return this.getCurrent(callableStatement).do_getDate(parameterName);
    }

    @Override
    public Time CallableStatement_getTime(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return this.getCurrent(callableStatement).do_getTime(parameterName);
    }

    @Override
    public Timestamp CallableStatement_getTimestamp(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return this.getCurrent(callableStatement).do_getTimestamp(parameterName);
    }

    @Override
    public Object CallableStatement_getObject(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return this.getCurrent(callableStatement).do_getObject(parameterName);
    }

    @Override
    public BigDecimal CallableStatement_getBigDecimal(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return this.getCurrent(callableStatement).do_getBigDecimal(parameterName);
    }

    @Override
    public Object CallableStatement_getObject(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Map<String, Class<?>> map) throws SQLException {
        return this.getCurrent(callableStatement).do_getObject(parameterName, map);
    }

    @Override
    public Ref CallableStatement_getRef(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return this.getCurrent(callableStatement).do_getRef(parameterName);
    }

    @Override
    public Blob CallableStatement_getBlob(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return this.getCurrent(callableStatement).do_getBlob(parameterName);
    }

    @Override
    public Clob CallableStatement_getClob(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return this.getCurrent(callableStatement).do_getClob(parameterName);
    }

    @Override
    public Array CallableStatement_getArray(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return this.getCurrent(callableStatement).do_getArray(parameterName);
    }

    @Override
    public Date CallableStatement_getDate(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Calendar cal) throws SQLException {
        return this.getCurrent(callableStatement).do_getDate(parameterName, cal);
    }

    @Override
    public Time CallableStatement_getTime(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Calendar cal) throws SQLException {
        return this.getCurrent(callableStatement).do_getTime(parameterName, cal);
    }

    @Override
    public Timestamp CallableStatement_getTimestamp(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Calendar cal) throws SQLException {
        return this.getCurrent(callableStatement).do_getTimestamp(parameterName, cal);
    }

    @Override
    public URL CallableStatement_getURL(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return this.getCurrent(callableStatement).do_getURL(parameterName);
    }

    @Override
    public RowId CallableStatement_getRowId(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return this.getCurrent(callableStatement).do_getRowId(parameterIndex);
    }

    @Override
    public RowId CallableStatement_getRowId(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return this.getCurrent(callableStatement).do_getRowId(parameterName);
    }

    @Override
    public void CallableStatement_setRowId(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, RowId x2) throws SQLException {
        this.getCurrent(callableStatement).do_setRowId(parameterName, x2);
    }

    @Override
    public void CallableStatement_setNString(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, String value) throws SQLException {
        this.getCurrent(callableStatement).do_setNString(parameterName, value);
    }

    @Override
    public void CallableStatement_setNCharacterStream(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Reader value, long length) throws SQLException {
        this.getCurrent(callableStatement).do_setNCharacterStream(parameterName, value, length);
    }

    @Override
    public void CallableStatement_setNClob(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, NClob value) throws SQLException {
        this.getCurrent(callableStatement).do_setNClob(parameterName, value);
    }

    @Override
    public void CallableStatement_setClob(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Reader reader, long length) throws SQLException {
        this.getCurrent(callableStatement).do_setClob(parameterName, reader, length);
    }

    @Override
    public void CallableStatement_setBlob(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, InputStream inputStream, long length) throws SQLException {
        this.getCurrent(callableStatement).do_setBlob(parameterName, inputStream, length);
    }

    @Override
    public void CallableStatement_setNClob(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Reader reader, long length) throws SQLException {
        this.getCurrent(callableStatement).do_setNClob(parameterName, reader, length);
    }

    @Override
    public NClob CallableStatement_getNClob(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return this.getCurrent(callableStatement).do_getNClob(parameterIndex);
    }

    @Override
    public NClob CallableStatement_getNClob(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return this.getCurrent(callableStatement).do_getNClob(parameterName);
    }

    @Override
    public void CallableStatement_setSQLXML(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, SQLXML xmlObject) throws SQLException {
        this.getCurrent(callableStatement).do_setSQLXML(parameterName, xmlObject);
    }

    @Override
    public SQLXML CallableStatement_getSQLXML(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return this.getCurrent(callableStatement).do_getSQLXML(parameterIndex);
    }

    @Override
    public SQLXML CallableStatement_getSQLXML(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return this.getCurrent(callableStatement).do_getSQLXML(parameterName);
    }

    @Override
    public String CallableStatement_getNString(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return this.getCurrent(callableStatement).do_getNString(parameterIndex);
    }

    @Override
    public String CallableStatement_getNString(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return this.getCurrent(callableStatement).do_getNString(parameterName);
    }

    @Override
    public Reader CallableStatement_getNCharacterStream(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return this.getCurrent(callableStatement).do_getNCharacterStream(parameterIndex);
    }

    @Override
    public Reader CallableStatement_getNCharacterStream(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return this.getCurrent(callableStatement).do_getNCharacterStream(parameterName);
    }

    @Override
    public Reader CallableStatement_getCharacterStream(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return this.getCurrent(callableStatement).do_getCharacterStream(parameterIndex);
    }

    @Override
    public Reader CallableStatement_getCharacterStream(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return this.getCurrent(callableStatement).do_getCharacterStream(parameterName);
    }

    @Override
    public void CallableStatement_setBlob(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Blob x2) throws SQLException {
        this.getCurrent(callableStatement).do_setBlob(parameterName, x2);
    }

    @Override
    public void CallableStatement_setClob(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Clob x2) throws SQLException {
        this.getCurrent(callableStatement).do_setClob(parameterName, x2);
    }

    @Override
    public void CallableStatement_setAsciiStream(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, InputStream x2, long length) throws SQLException {
        this.getCurrent(callableStatement).do_setAsciiStream(parameterName, x2, length);
    }

    @Override
    public void CallableStatement_setBinaryStream(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, InputStream x2, long length) throws SQLException {
        this.getCurrent(callableStatement).do_setBinaryStream(parameterName, x2, length);
    }

    @Override
    public void CallableStatement_setCharacterStream(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Reader reader, long length) throws SQLException {
        this.getCurrent(callableStatement).do_setCharacterStream(parameterName, reader, length);
    }

    @Override
    public void CallableStatement_setAsciiStream(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, InputStream x2) throws SQLException {
        this.getCurrent(callableStatement).do_setAsciiStream(parameterName, x2);
    }

    @Override
    public void CallableStatement_setBinaryStream(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, InputStream x2) throws SQLException {
        this.getCurrent(callableStatement).do_setBinaryStream(parameterName, x2);
    }

    @Override
    public void CallableStatement_setCharacterStream(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Reader reader) throws SQLException {
        this.getCurrent(callableStatement).do_setCharacterStream(parameterName, reader);
    }

    @Override
    public void CallableStatement_setNCharacterStream(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Reader value) throws SQLException {
        this.getCurrent(callableStatement).do_setNCharacterStream(parameterName, value);
    }

    @Override
    public void CallableStatement_setClob(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Reader reader) throws SQLException {
        this.getCurrent(callableStatement).do_setClob(parameterName, reader);
    }

    @Override
    public void CallableStatement_setBlob(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, InputStream inputStream) throws SQLException {
        this.getCurrent(callableStatement).do_setBlob(parameterName, inputStream);
    }

    @Override
    public void CallableStatement_setNClob(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Reader reader) throws SQLException {
        this.getCurrent(callableStatement).do_setNClob(parameterName, reader);
    }

    @Override
    public <T> T CallableStatement_getObject(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex, Class<T> type) throws SQLException {
        return this.getCurrent(callableStatement).do_getObject(parameterIndex, type);
    }

    @Override
    public <T> T CallableStatement_getObject(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Class<T> type) throws SQLException {
        return this.getCurrent(callableStatement).do_getObject(parameterName, type);
    }

    @Override
    public void CallableStatement_setObject(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Object x2, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.getCurrent(callableStatement).do_setObject(parameterName, x2, targetSqlType, scaleOrLength);
    }

    @Override
    public void CallableStatement_setObject(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Object x2, SQLType targetSqlType) throws SQLException {
        this.getCurrent(callableStatement).do_setObject(parameterName, x2, targetSqlType);
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex, SQLType sqlType) throws SQLException {
        this.getCurrent(callableStatement).do_registerOutParameter(parameterIndex, sqlType);
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex, SQLType sqlType, int scale) throws SQLException {
        this.getCurrent(callableStatement).do_registerOutParameter(parameterIndex, sqlType, scale);
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex, SQLType sqlType, String typeName) throws SQLException {
        this.getCurrent(callableStatement).do_registerOutParameter(parameterIndex, sqlType, typeName);
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, SQLType sqlType) throws SQLException {
        this.getCurrent(callableStatement).do_registerOutParameter(parameterName, sqlType);
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, SQLType sqlType, int scale) throws SQLException {
        this.getCurrent(callableStatement).do_registerOutParameter(parameterName, sqlType, scale);
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, SQLType sqlType, String typeName) throws SQLException {
        this.getCurrent(callableStatement).do_registerOutParameter(parameterName, sqlType, typeName);
    }

    @Override
    public DmdbIntervalYM CallableStatement_getINTERVALYM(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return this.getCurrent(callableStatement).do_getINTERVALYM(parameterIndex);
    }

    @Override
    public DmdbIntervalDT CallableStatement_getINTERVALDT(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return this.getCurrent(callableStatement).do_getINTERVALDT(parameterIndex);
    }

    @Override
    public DmdbTimestamp CallableStatement_getTIMESTAMP(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return this.getCurrent(callableStatement).do_getTIMESTAMP(parameterIndex);
    }

    @Override
    public ResultSet CallableStatement_getCursor(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return this.getCurrent(callableStatement).do_getCursor(parameterIndex);
    }

    @Override
    public SQLWarning Connection_getWarnings(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        return this.getCurrent(connection).do_getWarnings();
    }

    @Override
    public void Connection_abort(FilterChain filterChain, DmdbConnection connection, Executor executor) throws SQLException {
        this.getCurrent(connection).do_abort(executor);
    }

    @Override
    public void Connection_reset(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        this.getCurrent(connection).do_reset();
    }

    @Override
    public void PreparedStatement_setNull(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, int sqlType) throws SQLException {
        this.getCurrent(preparedStatement).do_setNull(parameterIndex, sqlType);
    }

    @Override
    public void PreparedStatement_setBoolean(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, boolean x2) throws SQLException {
        this.getCurrent(preparedStatement).do_setBoolean(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setByte(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, byte x2) throws SQLException {
        this.getCurrent(preparedStatement).do_setByte(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setShort(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, short x2) throws SQLException {
        this.getCurrent(preparedStatement).do_setShort(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setInt(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, int x2) throws SQLException {
        this.getCurrent(preparedStatement).do_setInt(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setLong(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, long x2) throws SQLException {
        this.getCurrent(preparedStatement).do_setLong(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setFloat(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, float x2) throws SQLException {
        this.getCurrent(preparedStatement).do_setFloat(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setDouble(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, double x2) throws SQLException {
        this.getCurrent(preparedStatement).do_setDouble(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setBigDecimal(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, BigDecimal x2) throws SQLException {
        this.getCurrent(preparedStatement).do_setBigDecimal(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setString(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, String x2) throws SQLException {
        this.getCurrent(preparedStatement).do_setString(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setBytes(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, byte[] x2) throws SQLException {
        this.getCurrent(preparedStatement).do_setBytes(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setDate(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Date x2) throws SQLException {
        this.getCurrent(preparedStatement).do_setDate(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setTime(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Time x2) throws SQLException {
        this.getCurrent(preparedStatement).do_setTime(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setTimestamp(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Timestamp x2) throws SQLException {
        this.getCurrent(preparedStatement).do_setTimestamp(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setAsciiStream(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2, int length) throws SQLException {
        this.getCurrent(preparedStatement).do_setAsciiStream(parameterIndex, x2, length);
    }

    @Override
    public void PreparedStatement_setUnicodeStream(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2, int length) throws SQLException {
        this.getCurrent(preparedStatement).do_setUnicodeStream(parameterIndex, x2, length);
    }

    @Override
    public void PreparedStatement_setBinaryStream(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2, int length) throws SQLException {
        this.getCurrent(preparedStatement).do_setBinaryStream(parameterIndex, x2, length);
    }

    @Override
    public void PreparedStatement_setObject(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Object x2, int targetSqlType) throws SQLException {
        this.getCurrent(preparedStatement).do_setObject(parameterIndex, x2, targetSqlType);
    }

    @Override
    public void PreparedStatement_setObject(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Object x2) throws SQLException {
        this.getCurrent(preparedStatement).do_setObject(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_addBatch(FilterChain filterChain, DmdbPreparedStatement preparedStatement) throws SQLException {
        this.getCurrent(preparedStatement).do_addBatch();
    }

    @Override
    public void PreparedStatement_setCharacterStream(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader, int length) throws SQLException {
        this.getCurrent(preparedStatement).do_setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void PreparedStatement_setRef(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Ref x2) throws SQLException {
        this.getCurrent(preparedStatement).do_setRef(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setBlob(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Blob x2) throws SQLException {
        this.getCurrent(preparedStatement).do_setBlob(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setClob(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Clob x2) throws SQLException {
        this.getCurrent(preparedStatement).do_setClob(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setArray(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Array x2) throws SQLException {
        this.getCurrent(preparedStatement).do_setArray(parameterIndex, x2);
    }

    @Override
    public ResultSetMetaData PreparedStatement_getMetaData(FilterChain filterChain, DmdbPreparedStatement preparedStatement) throws SQLException {
        return this.getCurrent(preparedStatement).do_getMetaData();
    }

    @Override
    public void PreparedStatement_setDate(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Date x2, Calendar cal) throws SQLException {
        this.getCurrent(preparedStatement).do_setDate(parameterIndex, x2, cal);
    }

    @Override
    public void PreparedStatement_setTime(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Time x2, Calendar cal) throws SQLException {
        this.getCurrent(preparedStatement).do_setTime(parameterIndex, x2, cal);
    }

    @Override
    public void PreparedStatement_setTimestamp(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Timestamp x2, Calendar cal) throws SQLException {
        this.getCurrent(preparedStatement).do_setTimestamp(parameterIndex, x2, cal);
    }

    @Override
    public void PreparedStatement_setNull(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.getCurrent(preparedStatement).do_setNull(parameterIndex, sqlType, typeName);
    }

    @Override
    public void PreparedStatement_setURL(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, URL x2) throws SQLException {
        this.getCurrent(preparedStatement).do_setURL(parameterIndex, x2);
    }

    @Override
    public ParameterMetaData PreparedStatement_getParameterMetaData(FilterChain filterChain, DmdbPreparedStatement preparedStatement) throws SQLException {
        return this.getCurrent(preparedStatement).do_getParameterMetaData();
    }

    @Override
    public void PreparedStatement_setRowId(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, RowId x2) throws SQLException {
        this.getCurrent(preparedStatement).do_setRowId(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setNString(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, String value) throws SQLException {
        this.getCurrent(preparedStatement).do_setNString(parameterIndex, value);
    }

    @Override
    public void PreparedStatement_setNCharacterStream(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Reader value, long length) throws SQLException {
        this.getCurrent(preparedStatement).do_setNCharacterStream(parameterIndex, value, length);
    }

    @Override
    public void PreparedStatement_setNClob(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, NClob value) throws SQLException {
        this.getCurrent(preparedStatement).do_setNClob(parameterIndex, value);
    }

    @Override
    public void PreparedStatement_setClob(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader, long length) throws SQLException {
        this.getCurrent(preparedStatement).do_setClob(parameterIndex, reader, length);
    }

    @Override
    public void PreparedStatement_setBlob(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.getCurrent(preparedStatement).do_setBlob(parameterIndex, inputStream, length);
    }

    @Override
    public void PreparedStatement_setNClob(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader, long length) throws SQLException {
        this.getCurrent(preparedStatement).do_setNClob(parameterIndex, reader, length);
    }

    @Override
    public void PreparedStatement_setSQLXML(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.getCurrent(preparedStatement).do_setSQLXML(parameterIndex, xmlObject);
    }

    @Override
    public void PreparedStatement_setObject(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Object x2, int targetSqlType, int scaleOrLength) throws SQLException {
        this.getCurrent(preparedStatement).do_setObject(parameterIndex, x2, targetSqlType, scaleOrLength);
    }

    @Override
    public void PreparedStatement_setAsciiStream(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2, long length) throws SQLException {
        this.getCurrent(preparedStatement).do_setAsciiStream(parameterIndex, x2, length);
    }

    @Override
    public void PreparedStatement_setBinaryStream(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2, long length) throws SQLException {
        this.getCurrent(preparedStatement).do_setBinaryStream(parameterIndex, x2, length);
    }

    @Override
    public void PreparedStatement_setCharacterStream(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader, long length) throws SQLException {
        this.getCurrent(preparedStatement).do_setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void PreparedStatement_setAsciiStream(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2) throws SQLException {
        this.getCurrent(preparedStatement).do_setAsciiStream(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setBinaryStream(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2) throws SQLException {
        this.getCurrent(preparedStatement).do_setBinaryStream(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setCharacterStream(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader) throws SQLException {
        this.getCurrent(preparedStatement).do_setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void PreparedStatement_setNCharacterStream(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Reader value) throws SQLException {
        this.getCurrent(preparedStatement).do_setNCharacterStream(parameterIndex, value);
    }

    @Override
    public void PreparedStatement_setClob(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader) throws SQLException {
        this.getCurrent(preparedStatement).do_setClob(parameterIndex, reader);
    }

    @Override
    public void PreparedStatement_setBlob(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream inputStream) throws SQLException {
        this.getCurrent(preparedStatement).do_setBlob(parameterIndex, inputStream);
    }

    @Override
    public void PreparedStatement_setNClob(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader) throws SQLException {
        this.getCurrent(preparedStatement).do_setNClob(parameterIndex, reader);
    }

    @Override
    public void PreparedStatement_setObject(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Object x2, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.getCurrent(preparedStatement).do_setObject(parameterIndex, x2, targetSqlType, scaleOrLength);
    }

    @Override
    public void PreparedStatement_setObject(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Object x2, SQLType targetSqlType) throws SQLException {
        this.getCurrent(preparedStatement).do_setObject(parameterIndex, x2, targetSqlType);
    }

    @Override
    public void PreparedStatement_preCompile(FilterChain filterChain, DmdbPreparedStatement preparedStatement, String sql) throws SQLException {
        this.getCurrent(preparedStatement).do_preCompile(sql);
    }

    @Override
    public void PreparedStatement_setTIMESTAMP(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, DmdbTimestamp x2) throws SQLException {
        this.getCurrent(preparedStatement).do_setTIMESTAMP(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setINTERVALYM(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, DmdbIntervalYM x2) throws SQLException {
        this.getCurrent(preparedStatement).do_setINTERVALYM(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setINTERVALDT(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, DmdbIntervalDT x2) throws SQLException {
        this.getCurrent(preparedStatement).do_setINTERVALDT(parameterIndex, x2);
    }

    @Override
    public int Statement_getMaxFieldSize(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return this.getCurrent(statement).do_getMaxFieldSize();
    }

    @Override
    public int Statement_getMaxRows(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return this.getCurrent(statement).do_getMaxRows();
    }

    @Override
    public int Statement_getQueryTimeout(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return this.getCurrent(statement).do_getQueryTimeout();
    }

    @Override
    public void Statement_cancel(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        this.getCurrent(statement).do_cancel();
    }

    @Override
    public SQLWarning Statement_getWarnings(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return this.getCurrent(statement).do_getWarnings();
    }

    @Override
    public void Statement_clearWarnings(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        this.getCurrent(statement).do_clearWarnings();
    }

    @Override
    public ResultSet Statement_getResultSet(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return this.getCurrent(statement).do_getResultSet();
    }

    @Override
    public int Statement_getUpdateCount(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return this.getCurrent(statement).do_getUpdateCount();
    }

    @Override
    public boolean Statement_getMoreResults(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return this.getCurrent(statement).do_getMoreResults();
    }

    @Override
    public int Statement_getFetchDirection(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return this.getCurrent(statement).do_getFetchDirection();
    }

    @Override
    public int Statement_getFetchSize(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return this.getCurrent(statement).do_getFetchSize();
    }

    @Override
    public int Statement_getResultSetConcurrency(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return this.getCurrent(statement).do_getResultSetConcurrency();
    }

    @Override
    public int Statement_getResultSetType(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return this.getCurrent(statement).do_getResultSetType();
    }

    @Override
    public void Statement_addBatch(FilterChain filterChain, DmdbStatement statement, String sql) throws SQLException {
        this.getCurrent(statement).do_addBatch(sql);
    }

    @Override
    public void Statement_clearBatch(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        DscParallelFilter.doTaskParallel(statement.tempMap.values().toArray(new DmdbStatement[0]), new BaseFilter.FilterCallback<DmdbStatement>(){

            @Override
            public void run(DmdbStatement siteObject) throws SQLException {
                siteObject.do_clearBatch();
            }
        });
    }

    @Override
    public boolean Statement_getMoreResults(FilterChain filterChain, DmdbStatement statement, int current) throws SQLException {
        return this.getCurrent(statement).do_getMoreResults(current);
    }

    @Override
    public ResultSet Statement_getGeneratedKeys(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return this.getCurrent(statement).do_getGeneratedKeys();
    }

    @Override
    public int Statement_getResultSetHoldability(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return this.getCurrent(statement).do_getResultSetHoldability();
    }

    @Override
    public boolean Statement_isClosed(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return this.getCurrent(statement).do_isClosed();
    }

    @Override
    public long Statement_getLargeUpdateCount(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return this.getCurrent(statement).do_getLargeUpdateCount();
    }

    @Override
    public long Statement_getLargeMaxRows(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return this.getCurrent(statement).do_getLargeMaxRows();
    }

    @Override
    public long Statement_getExecuteId(FilterChain filterChain, DmdbStatement statement) {
        return this.getCurrent(statement).do_getExecuteId();
    }

    @Override
    public String Statement_getPrintMsg(FilterChain filterChain, DmdbStatement statement) {
        return this.getCurrent(statement).do_getPrintMsg();
    }

    @Override
    public int Statement_getSqlType(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return this.getCurrent(statement).do_getSqlType();
    }

    @Override
    public ResultSet[] Statement_getResultSets(FilterChain filterChain, DmdbStatement statement) {
        return this.getCurrent(statement).do_getResultSets();
    }

    /* synthetic */ DscParallelFilter(DscParallelFilter dscParallelFilter) {
        this();
    }

    private static class DscParallelFilterThreadHolder {
        private static final DscParallelFilter instance = new DscParallelFilter(null);

        private DscParallelFilterThreadHolder() {
        }
    }
}

