/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.filter.fldr;

import dm.jdbc.driver.Configuration;
import dm.jdbc.driver.DmDriver;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.filter.fldr.Callback;
import dm.jdbc.filter.fldr.DmServerInfo;
import dm.jdbc.filter.fldr.FldrTableInfo;
import dm.jdbc.filter.fldr.FldrTask;
import dm.jdbc.filter.fldr.HashCode;
import dm.jdbc.internal.conf.DmProperties;
import dm.jdbc.internal.desc.Parameter;
import dm.jdbc.util.DriverUtil;
import dm.jdbc.util.MiscUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class FldrManager {
    public static final String SQL_GET_MPP_PRIMARY_EPS_1 = "select distinct mailIni.INST_IP, mailIni.INST_PORT, mppItem.ep_seqno FROM (select * from V$MPP_CFG_ITEM where SF_GET_EP_SEQNO(rowid)=sf_get_self_ep_seqno()) mppItem,  (select * from V$DM_MAL_INI where SF_GET_EP_SEQNO(rowid)=sf_get_self_ep_seqno()) mailIni WHERE mppItem.inst_name = mailIni.inst_name order by mppItem.ep_seqno asc;";
    public static final String SQL_GET_MPP_PRIMARY_EPS_2 = "select distinct mailIni.MAL_INST_HOST, mailIni.MAL_INST_PORT, mppItem.ep_seqno FROM (select * from V$MPP_CFG_ITEM where SF_GET_EP_SEQNO(rowid)=sf_get_self_ep_seqno()) mppItem,  (select * from V$DM_MAL_INI where SF_GET_EP_SEQNO(rowid)=sf_get_self_ep_seqno()) mailIni WHERE mppItem.inst_name = mailIni.mal_inst_name order by mppItem.ep_seqno asc;";

    public static void createConnection(final DmdbConnection conn) throws SQLException {
        List<DmServerInfo> serverList = FldrManager.getMppPrimarySites(conn);
        if (serverList == null || serverList.size() == 0) {
            return;
        }
        conn.fldrInfo.fldrExecutor = Executors.newFixedThreadPool(Math.min(Runtime.getRuntime().availableProcessors(), serverList.size()));
        if (conn.fldrInfo.fldrConnMap != null) {
            conn.fldrInfo.fldrConnMap.clear();
        } else {
            conn.fldrInfo.fldrConnMap = new ConcurrentHashMap();
        }
        FldrManager.doTaskOnEverySite(conn.fldrInfo.fldrExecutor, serverList, serverList.size(), new Callback<DmServerInfo>(){

            @Override
            void run(DmServerInfo serverInfo) throws SQLException {
                DmProperties props = (DmProperties)conn.props.clone();
                props.setProperty(Configuration.user.getName(), conn.user);
                props.setProperty(Configuration.password.getName(), conn.password);
                props.setProperty(Configuration.mppLocal.getName(), "true");
                props.setProperty(Configuration.host.getName(), serverInfo.getSvrName());
                props.setProperty(Configuration.port.getName(), String.valueOf(serverInfo.getSvrPort()));
                props.setProperty(Configuration.epGroup.getName(), null);
                conn.fldrInfo.fldrConnMap.put(serverInfo.getEpSeqno(), DmDriver.driver.do_connect(props));
            }
        });
        conn.fldrInfo.setFldrConnSize(conn.fldrInfo.fldrConnMap.size());
    }

    public static void prepareStatement(final DmdbPreparedStatement pstmt, final String sql, final int resultSetType, final int resultSetConcurrency, final int resultSetHoldability) throws SQLException {
        DmdbConnection conn = pstmt.connection;
        ConcurrentHashMap<Integer, DmdbConnection> connList = conn.fldrInfo.fldrConnMap;
        int siteCount = conn.fldrInfo.getFldrConnSize();
        if (connList == null || siteCount == 0 || conn.fldrInfo.fldrExecutor == null) {
            return;
        }
        pstmt.fldrInfo.fldrStmtMap = new ConcurrentHashMap();
        FldrManager.doTaskOnEverySite(conn.fldrInfo.fldrExecutor, connList.entrySet(), siteCount, new Callback<Map.Entry<Integer, DmdbConnection>>(){

            @Override
            void run(Map.Entry<Integer, DmdbConnection> site) throws SQLException {
                pstmt.fldrInfo.fldrStmtMap.put(site.getKey(), site.getValue().do_prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
            }
        });
        pstmt.fldrInfo.setFldrStmtSize(pstmt.fldrInfo.fldrStmtMap.size());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void fldrPrepareSql(DmdbConnection connection, String sql, PreparedStatement pstmt) throws SQLException {
        if (connection.fldrInfo.fldrConnMap == null || connection.fldrInfo.getFldrConnSize() <= 0) return;
        int retType = ((DmdbPreparedStatement)pstmt).getRetType();
        if (retType == 157 && connection.isMppFldrInsertEnable()) {
            FldrTableInfo fldrTableInfo;
            ((DmdbPreparedStatement)pstmt).fldrInfo.fldrTableInfo = fldrTableInfo = connection.dbAccess.b((DmdbPreparedStatement)pstmt);
            try {
                if (fldrTableInfo == null || !fldrTableInfo.isCanFastInsert()) return;
                connection.dbAccess.a(((DmdbPreparedStatement)pstmt).fldrInfo.fldrTableInfo);
                if (!FldrManager.canFldrForInsert((DmdbPreparedStatement)pstmt)) return;
                System.out.println("JDBC mppOpt enabled");
                FldrManager.prepareStatement((DmdbPreparedStatement)pstmt, sql, pstmt.getResultSetType(), pstmt.getResultSetConcurrency(), pstmt.getResultSetHoldability());
                return;
            }
            catch (SQLException e2) {
                ((DmdbPreparedStatement)pstmt).fldrInfo.clearFldr();
                throw e2;
            }
        } else {
            if (retType != 160 || !connection.isMppFldrSelectEnable()) return;
            FldrManager.prepareStatement((DmdbPreparedStatement)pstmt, sql, pstmt.getResultSetType(), pstmt.getResultSetConcurrency(), pstmt.getResultSetHoldability());
        }
    }

    public static int[] executeBatch(DmdbPreparedStatement pstmt) throws SQLException {
        if (!FldrManager.canFldrForInsert(pstmt)) {
            return pstmt.do_executeBatch();
        }
        ArrayList<DmdbStatement> stmtRunList = new ArrayList<DmdbStatement>();
        int batchSize = 0;
        for (DmdbStatement pstmtBase : pstmt.fldrInfo.fldrStmtMap.values()) {
            if (((DmdbPreparedStatement)pstmtBase).getBatchSize() <= 0) continue;
            batchSize += ((DmdbPreparedStatement)pstmtBase).getBatchSize();
            stmtRunList.add(pstmtBase);
        }
        FldrManager.doTaskOnEverySite(pstmt.connection.fldrInfo.fldrExecutor, stmtRunList, stmtRunList.size(), new Callback<DmdbStatement>(){

            @Override
            void run(DmdbStatement siteObject) throws SQLException {
                siteObject.do_executeBatch();
            }
        });
        int[] updateCounts = new int[batchSize];
        Arrays.fill(updateCounts, -2);
        return updateCounts;
    }

    public static List<DmServerInfo> getMppPrimarySites(DmdbConnection conn) throws SQLException {
        ArrayList<DmServerInfo> serverList;
        block9: {
            DmdbResultSet rs;
            block8: {
                rs = null;
                serverList = new ArrayList<DmServerInfo>();
                try {
                    try {
                        rs = DriverUtil.executeQuery(conn, SQL_GET_MPP_PRIMARY_EPS_2);
                        while (rs.next()) {
                            DmServerInfo server = new DmServerInfo(rs.getString(1), Integer.parseInt(rs.getString(2)));
                            server.setEpSeqno(rs.getInt(3));
                            serverList.add(server);
                        }
                        break block8;
                    }
                    catch (Exception exception) {
                        serverList.clear();
                        try {
                            rs = DriverUtil.executeQuery(conn, SQL_GET_MPP_PRIMARY_EPS_1);
                            while (rs.next()) {
                                DmServerInfo server = new DmServerInfo(rs.getString(1), Integer.parseInt(rs.getString(2)));
                                server.setEpSeqno(rs.getInt(3));
                                serverList.add(server);
                            }
                        }
                        catch (Exception exception2) {
                            serverList.clear();
                        }
                    }
                }
                catch (Throwable throwable) {
                    MiscUtil.close(rs);
                    throw throwable;
                }
                MiscUtil.close((ResultSet)rs);
                break block9;
            }
            MiscUtil.close((ResultSet)rs);
        }
        return serverList;
    }

    public static void addBatch(DmdbPreparedStatement preparedStatement) throws SQLException {
        DmdbPreparedStatement sitePstmt;
        if (!FldrManager.canFldrForInsert(preparedStatement)) {
            return;
        }
        Object[] curRowObjects = preparedStatement.curRowDatas;
        int epSeqno = -1;
        if (preparedStatement.fldrInfo.fldrTableInfo != null) {
            int disType = preparedStatement.fldrInfo.fldrTableInfo.getDisType();
            if (disType == 2) {
                epSeqno = FldrManager.calcHashDisEpSeqno(preparedStatement, curRowObjects);
            } else if (disType == 1) {
                epSeqno = FldrManager.calcRandDisEpSeqno(preparedStatement, curRowObjects);
            }
        }
        if ((sitePstmt = (DmdbPreparedStatement)preparedStatement.fldrInfo.fldrStmtMap.get(epSeqno)) != null) {
            int i2 = 0;
            while (i2 < curRowObjects.length) {
                sitePstmt.do_setOriginal(i2 + 1, preparedStatement.bindParameters[i2], curRowObjects[i2]);
                ++i2;
            }
        } else {
            throw new SQLException("No pstmt for ep_seqno: " + epSeqno);
        }
        sitePstmt.do_addBatch();
    }

    private static int calcRandDisEpSeqno(DmdbPreparedStatement preparedStatement, Object[] curRowObjects) throws SQLException {
        int rowIndex = preparedStatement.irow;
        return rowIndex % preparedStatement.fldrInfo.getFldrStmtSize();
    }

    private static int calcHashDisEpSeqno(DmdbPreparedStatement preparedStatement, Object[] curRowObjects) throws SQLException {
        int[] disColIds = preparedStatement.fldrInfo.fldrTableInfo.getDisColIds();
        int[] prepareColIds = preparedStatement.fldrInfo.fldrTableInfo.getPrepareColIds();
        int[] hashMap = preparedStatement.fldrInfo.fldrTableInfo.getHashMap();
        long fold = 0L;
        if (disColIds != null && disColIds.length > 0 && prepareColIds != null && prepareColIds.length > 0 && hashMap != null && hashMap.length > 0) {
            long[] folds = new long[disColIds.length];
            int n2 = 0;
            while (n2 < disColIds.length) {
                int i2 = 0;
                while (i2 < prepareColIds.length) {
                    if (disColIds[n2] == prepareColIds[i2]) {
                        Parameter paramDesc = preparedStatement.bindParameters[i2];
                        folds[n2] = HashCode.hc_get_fold_fun(paramDesc, curRowObjects[i2], preparedStatement.connection);
                    }
                    ++i2;
                }
                ++n2;
            }
            fold = HashCode.hc_calc_fold_value(folds);
            return hashMap[(int)(fold % (long)hashMap.length)];
        }
        return -1;
    }

    public static boolean canFldrForSelect(DmdbStatement pstmt) throws SQLException {
        return pstmt.connection.isMppFldrSelectEnable() && pstmt.fldrInfo.getFldrStmtSize() > 0;
    }

    public static boolean canFldrForInsert(DmdbPreparedStatement pstmt) throws SQLException {
        if (!pstmt.connection.isMppFldrInsertEnable()) {
            return false;
        }
        FldrTableInfo fldrTableInfo = pstmt.fldrInfo.fldrTableInfo;
        if (fldrTableInfo == null || !fldrTableInfo.isCanFastInsert()) {
            return false;
        }
        if (fldrTableInfo.getDisType() == 1) {
            return true;
        }
        if (fldrTableInfo.getDisType() == 2) {
            return fldrTableInfo.isIncludeAllDisCols();
        }
        return false;
    }

    public static void createStatement(final DmdbStatement stmt, final int resultSetType, final int resultSetConcurrency, final int resultSetHoldability) throws SQLException {
        if (!stmt.connection.isMppFldrSelectEnable()) {
            return;
        }
        DmdbConnection conn = stmt.connection;
        ConcurrentHashMap<Integer, DmdbConnection> connList = conn.fldrInfo.fldrConnMap;
        int siteCount = conn.fldrInfo.getFldrConnSize();
        if (connList == null || siteCount == 0 || conn.fldrInfo.fldrExecutor == null) {
            return;
        }
        if (stmt.fldrInfo.fldrStmtMap != null) {
            stmt.fldrInfo.fldrStmtMap.clear();
        } else {
            stmt.fldrInfo.fldrStmtMap = new ConcurrentHashMap();
        }
        FldrManager.doTaskOnEverySite(conn.fldrInfo.fldrExecutor, connList.entrySet(), siteCount, new Callback<Map.Entry<Integer, DmdbConnection>>(){

            @Override
            void run(Map.Entry<Integer, DmdbConnection> siteObject) throws SQLException {
                stmt.fldrInfo.fldrStmtMap.put(siteObject.getKey(), siteObject.getValue().do_createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
            }
        });
        stmt.fldrInfo.setFldrStmtSize(stmt.fldrInfo.fldrStmtMap.size());
    }

    public static <T> boolean doTaskOnEverySite(ExecutorService executor, Collection<T> list, int siteCount, final Callback<T> callback) throws SQLException {
        if (siteCount == 0 || executor == null) {
            return false;
        }
        CountDownLatch countDownLatch = new CountDownLatch(siteCount);
        FldrTask[] tasks = new FldrTask[siteCount];
        int i2 = 0;
        for (final T siteObj : list) {
            tasks[i2] = new FldrTask(countDownLatch){

                @Override
                protected void doTask() throws SQLException {
                    callback.run(siteObj);
                }
            };
            executor.execute(tasks[i2]);
            ++i2;
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {}
        boolean success = true;
        FldrTask[] fldrTaskArray = tasks;
        int n2 = tasks.length;
        int n3 = 0;
        while (n3 < n2) {
            FldrTask task = fldrTaskArray[n3];
            if (!task.isSuccess()) {
                if (task.getError() != null) {
                    throw task.getError();
                }
                success = false;
                break;
            }
            ++n3;
        }
        return success;
    }
}

