/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.filter.fldr;

import java.sql.SQLException;
import java.util.concurrent.CountDownLatch;

public abstract class FldrTask
implements Runnable {
    private boolean success = false;
    private SQLException error = null;
    private CountDownLatch countDownLatch;

    public FldrTask(CountDownLatch countDownLatch) {
        this.countDownLatch = countDownLatch;
    }

    @Override
    public void run() {
        try {
            try {
                this.doTask();
                this.setSuccess(true);
            }
            catch (SQLException e2) {
                this.setError(e2);
                this.setSuccess(false);
                this.countDownLatch.countDown();
            }
        }
        finally {
            this.countDownLatch.countDown();
        }
    }

    protected abstract void doTask() throws SQLException;

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setError(SQLException error) {
        this.error = error;
    }

    public SQLException getError() {
        return this.error;
    }
}

