/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.internal.parser;

import dm.jdbc.internal.convert.J2DB;
import dm.jdbc.internal.parser.DmLexer;
import dm.jdbc.internal.parser.LVal;
import dm.jdbc.internal.parser.MysqlLexer;
import dm.jdbc.internal.parser.SQLParameter;
import dm.jdbc.util.ByteUtil;
import dm.jdbc.util.StringUtil;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;

public class SQLProcessor {
    public static List<LVal> lex(String sql) throws IOException {
        DmLexer lexer = new DmLexer(new StringReader(sql), false);
        int position = 0;
        LVal lval = null;
        ArrayList<LVal> lvalList = new ArrayList<LVal>(32);
        while ((lval = lexer.yylex()) != null) {
            lval.position = position++;
            lvalList.add(lval);
        }
        return lvalList;
    }

    public static int getParameterCount(String sql) throws IOException {
        DmLexer lexer = new DmLexer(new StringReader(sql), false);
        int position = 0;
        LVal lval = null;
        ArrayList<LVal> lvalList = new ArrayList<LVal>(32);
        int paramNum = 0;
        while ((lval = lexer.yylex()) != null) {
            if (lval.type == LVal.Type.NORMAL && (StringUtil.equals("?", lval.value) || StringUtil.equals(":", lval.value))) {
                ++paramNum;
            }
            lval.position = position++;
            lvalList.add(lval);
        }
        return paramNum;
    }

    public static List<LVal> lexSkipWhitespace(String sql, int n2) throws IOException {
        int count = n2;
        DmLexer lexer = new DmLexer(new StringReader(sql), false);
        int position = 0;
        LVal lval = null;
        ArrayList<LVal> lvalList = new ArrayList<LVal>(32);
        while ((lval = lexer.yylex()) != null) {
            lval.position = position++;
            if (lval.type == LVal.Type.WHITESPACE_OR_COMMENT) continue;
            lvalList.add(lval);
            if (n2 > 0 && --count == 0) break;
        }
        return lvalList;
    }

    public static String escape(String sql, String[] keywords) throws IOException {
        if ((keywords == null || keywords.length == 0) && sql.indexOf("{") == -1) {
            return sql;
        }
        HashMap keywordMap = null;
        if (keywords != null && keywords.length > 0) {
            keywordMap = new HashMap();
            String[] stringArray = keywords;
            int n2 = keywords.length;
            int n3 = 0;
            while (n3 < n2) {
                String keyword = stringArray[n3];
                keywordMap.put(keyword.toUpperCase(), null);
                ++n3;
            }
        }
        StringBuilder nsql = new StringBuilder();
        Stack<Boolean> stack = new Stack<Boolean>();
        List<LVal> lvalList = SQLProcessor.lex(sql);
        int i2 = 0;
        while (i2 < lvalList.size()) {
            LVal lval0 = lvalList.get(i2);
            if (lval0.type == LVal.Type.NORMAL) {
                if (StringUtil.equals(lval0.value, "{")) {
                    LVal lval2;
                    LVal lval1 = SQLProcessor.next(lvalList, i2 + 1);
                    if (lval1 == null || lval1.type != LVal.Type.NORMAL) {
                        stack.push(false);
                        nsql.append(lval0.value);
                    } else if (StringUtil.equalsIgnoreCase(lval1.value, "escape") || StringUtil.equalsIgnoreCase(lval1.value, "call")) {
                        stack.push(true);
                    } else if (StringUtil.equalsIgnoreCase(lval1.value, "oj")) {
                        stack.push(true);
                        lval1.value = "";
                        lval1.type = LVal.Type.WHITESPACE_OR_COMMENT;
                    } else if (StringUtil.equalsIgnoreCase(lval1.value, "d")) {
                        stack.push(true);
                        lval1.value = "date";
                    } else if (StringUtil.equalsIgnoreCase(lval1.value, "t")) {
                        stack.push(true);
                        lval1.value = "time";
                    } else if (StringUtil.equalsIgnoreCase(lval1.value, "ts")) {
                        stack.push(true);
                        lval1.value = "datetime";
                    } else if (StringUtil.equalsIgnoreCase(lval1.value, "fn")) {
                        stack.push(true);
                        lval1.value = "";
                        lval1.type = LVal.Type.WHITESPACE_OR_COMMENT;
                        lval2 = SQLProcessor.next(lvalList, lval1.position + 1);
                        if (lval2 != null && lval2.type == LVal.Type.NORMAL && StringUtil.equalsIgnoreCase(lval2.value, "database")) {
                            lval2.value = "cur_database";
                        }
                    } else if (StringUtil.equals(lval1.value, "?")) {
                        lval2 = SQLProcessor.next(lvalList, lval1.position + 1);
                        if (lval2 != null && lval2.type == LVal.Type.NORMAL && StringUtil.equalsIgnoreCase(lval2.value, "=")) {
                            LVal lval3 = SQLProcessor.next(lvalList, lval2.position + 1);
                            if (lval3 != null && lval3.type == LVal.Type.NORMAL && StringUtil.equalsIgnoreCase(lval3.value, "call")) {
                                stack.push(true);
                                lval3.value = "";
                                lval3.type = LVal.Type.WHITESPACE_OR_COMMENT;
                            } else {
                                stack.push(false);
                                nsql.append(lval0.value);
                            }
                        } else {
                            stack.push(false);
                            nsql.append(lval0.value);
                        }
                    } else {
                        stack.push(false);
                        nsql.append(lval0.value);
                    }
                } else if (StringUtil.equals(lval0.value, "}")) {
                    if (stack.isEmpty() || !((Boolean)stack.pop()).booleanValue()) {
                        nsql.append(lval0.value);
                    }
                } else if (keywordMap != null && keywordMap.containsKey(lval0.value.toUpperCase())) {
                    nsql.append("\"" + StringUtil.processDoubleQuoteOfName(lval0.value.toUpperCase()) + "\"");
                } else {
                    nsql.append(lval0.value);
                }
            } else if (lval0.type == LVal.Type.STRING) {
                nsql.append("'" + StringUtil.processSingleQuoteOfName(lval0.value) + '\'');
            } else {
                nsql.append(lval0.value);
            }
            ++i2;
        }
        return nsql.toString();
    }

    private static LVal next(List<LVal> lvalList, int start) {
        LVal lval = null;
        int size = lvalList.size();
        int i2 = start;
        while (i2 < size) {
            lval = lvalList.get(i2);
            if (lval.type != LVal.Type.WHITESPACE_OR_COMMENT) break;
            ++i2;
        }
        return lval;
    }

    public static String execOpt(String sql, List<SQLParameter> paramList, Charset serverEncoding, boolean notAllowOrgParam) throws Exception {
        try {
            StringBuilder nsql = new StringBuilder();
            List<LVal> lvalList = SQLProcessor.lex(sql);
            if (lvalList == null || lvalList.size() == 0) {
                return sql;
            }
            String firstWord = lvalList.get((int)0).value;
            if (!(firstWord.equalsIgnoreCase("INSERT") || firstWord.equalsIgnoreCase("SELECT") || firstWord.equalsIgnoreCase("UPDATE") || firstWord.equalsIgnoreCase("DELETE"))) {
                return sql;
            }
            int breakIndex = 0;
            int i2 = 0;
            while (i2 < lvalList.size()) {
                if (paramList.size() > 65536) {
                    paramList.clear();
                    return sql;
                }
                LVal lval = lvalList.get(i2);
                switch (lval.type) {
                    case INT: {
                        nsql.append("?");
                        Number value = new Long(lval.value);
                        if ((Long)value <= Integer.MAX_VALUE && (Long)value >= Integer.MIN_VALUE) {
                            paramList.add(new SQLParameter(J2DB.toInt((Long)value), 7, 4));
                            break;
                        }
                        paramList.add(new SQLParameter(J2DB.toBigint((Long)value), 8, 8));
                        break;
                    }
                    case DOUBLE: {
                        nsql.append("?");
                        Number value = new Double(lval.value);
                        paramList.add(new SQLParameter(J2DB.toDouble((Double)value), 11, 8));
                        break;
                    }
                    case DECIMAL: {
                        nsql.append("?");
                        paramList.add(new SQLParameter(J2DB.toDecimal(lval.value, 0, 0), 9, 0));
                        break;
                    }
                    case STRING: {
                        if (lval.value.length() > Short.MAX_VALUE) {
                            nsql.append("'" + StringUtil.processSingleQuoteOfName(lval.value) + "'");
                            break;
                        }
                        nsql.append("?");
                        paramList.add(new SQLParameter(ByteUtil.fromString(lval.value, serverEncoding), 2, Short.MAX_VALUE));
                        break;
                    }
                    case HEX_INT: {
                        nsql.append(lval.value);
                        break;
                    }
                    default: {
                        if (notAllowOrgParam && (StringUtil.equals(lval.value, "?") || StringUtil.equals(lval.value, ":"))) {
                            paramList.clear();
                            return sql;
                        }
                        nsql.append(lval.value);
                    }
                }
                if (breakIndex > 0) break;
                ++i2;
            }
            if (breakIndex > 0) {
                i2 = breakIndex + 1;
                while (i2 < lvalList.size()) {
                    nsql.append(lvalList.get((int)i2).value);
                    ++i2;
                }
            }
            return nsql.toString();
        }
        catch (Exception e2) {
            paramList.clear();
            throw e2;
        }
    }

    public static boolean hasConst(String sql) throws IOException, SQLException {
        List<LVal> lvalList = SQLProcessor.lex(sql);
        if (lvalList == null || lvalList.size() == 0) {
            return false;
        }
        int i2 = 0;
        while (i2 < lvalList.size()) {
            LVal lval = lvalList.get(i2);
            switch (lval.type) {
                case INT: 
                case DOUBLE: 
                case DECIMAL: 
                case STRING: 
                case HEX_INT: 
                case NULL: {
                    return true;
                }
            }
            ++i2;
        }
        return false;
    }

    public static String toMysql(String sql) throws IOException {
        StringBuilder nsql = new StringBuilder(sql.length());
        List<LVal> wordList = SQLProcessor.mysqlLex(sql);
        for (LVal lval : wordList) {
            if (lval.type == LVal.Type.DOUBLE_QUOTE_STRING) {
                String temp = lval.value;
                temp = "'" + StringUtil.processSingleQuoteOfName(temp) + "'";
                nsql.append(temp);
                continue;
            }
            if (lval.type == LVal.Type.STRING) {
                nsql.append(lval.value);
                continue;
            }
            nsql.append(lval.value);
        }
        return nsql.toString();
    }

    public static List<LVal> mysqlLex(String sql) throws IOException {
        MysqlLexer lexer = new MysqlLexer(new StringReader(sql), false);
        int position = 0;
        LVal lval = null;
        ArrayList<LVal> lvalList = new ArrayList<LVal>(32);
        while ((lval = lexer.yylex()) != null) {
            lval.position = position++;
            lvalList.add(lval);
        }
        return lvalList;
    }

    public static void main(String[] args) throws IOException, SQLException {
        String sql = "select * from test where id = \"\"\"\" and name = '''sfsf'";
        System.out.println(SQLProcessor.toMysql(sql));
    }
}

