/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.config.service;

import com.dangdang.config.service.ConfigGroup;
import com.dangdang.config.service.observer.IObserver;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GeneralConfigGroup
extends ConcurrentHashMap<String, String>
implements ConfigGroup {
    private static final long serialVersionUID = 1L;
    private ConfigGroup internalConfigGroup;
    protected boolean enumerable = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(GeneralConfigGroup.class);
    private long lastLoadTime;
    private final List<IObserver> watchers = new ArrayList<IObserver>();

    protected GeneralConfigGroup(ConfigGroup internalConfigGroup) {
        this.internalConfigGroup = internalConfigGroup;
    }

    public long getLastLoadTime() {
        return this.lastLoadTime;
    }

    @Override
    public final String get(String key) {
        String val = (String)super.get(key);
        if (val == null && this.internalConfigGroup != null) {
            val = this.internalConfigGroup.get(key);
        }
        return val;
    }

    @Override
    public final String get(Object key) {
        return this.get(key.toString());
    }

    protected final void cleanAndPutAll(Map<? extends String, ? extends String> configs) {
        this.lastLoadTime = System.currentTimeMillis();
        if (configs != null && configs.size() > 0) {
            if (this.size() > 0) {
                for (String string : new HashSet(this.keySet())) {
                    if (configs.containsKey(string)) continue;
                    super.remove(string);
                }
            }
            for (Map.Entry<String, String> entry : configs.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        } else {
            LOGGER.debug("Config group has none keys, clear.");
            super.clear();
        }
    }

    @Override
    public final String put(String key, String value) {
        if (value != null) {
            value = value.trim();
        }
        String preValue = (String)super.get(key);
        if (value != null && !value.equals(preValue)) {
            LOGGER.debug("Key " + key + " change from {} to {}", (Object)preValue, (Object)value);
            super.put(key, value);
            if (preValue != null) {
                this.notify(key, value);
            }
        }
        return preValue;
    }

    @Override
    public void register(IObserver watcher) {
        if (watcher == null) {
            throw new IllegalArgumentException("watcher cannot be null");
        }
        this.watchers.add(watcher);
    }

    @Override
    public void notify(final String key, final String value) {
        for (final IObserver watcher : this.watchers) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    watcher.notified(key, value);
                }
            }).start();
        }
    }

    @Override
    public String remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEnumerable() {
        return this.enumerable;
    }
}

