/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.config.service.file;

import com.dangdang.config.service.file.FileConfigGroup;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileChangeEventListener
implements Runnable {
    private WatchService watcher;
    private FileConfigGroup configGroup;
    private Path watchedFile;
    private static final Logger LOGGER = LoggerFactory.getLogger(FileChangeEventListener.class);

    public FileChangeEventListener(WatchService watcher, FileConfigGroup configGroup, Path watchedFile) {
        this.watcher = watcher;
        this.configGroup = configGroup;
        this.watchedFile = watchedFile;
    }

    @Override
    public void run() {
        WatchKey key;
        boolean status;
        do {
            try {
                key = this.watcher.take();
            }
            catch (InterruptedException x) {
                return;
            }
            for (WatchEvent<?> event : key.pollEvents()) {
                WatchEvent.Kind<?> kind = event.kind();
                if (kind != StandardWatchEventKinds.ENTRY_MODIFY) continue;
                WatchEvent<?> ev = event;
                Path filename = (Path)ev.context();
                LOGGER.debug("File {} changed.", (Object)filename);
                if (!this.isSameFile(filename, this.watchedFile)) continue;
                this.configGroup.initConfigs();
            }
        } while (status = key.reset());
    }

    private boolean isSameFile(Path file1, Path file2) {
        return file1.getFileName().equals(file2.getFileName());
    }
}

