/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.config.service.file;

import com.dangdang.config.service.file.protocol.ProtocolNames;

public class FileLocation {
    private String file;
    private String protocol;
    private static final String COLON = ":";

    public FileLocation(String file, String protocol) {
        this.file = file;
        this.protocol = protocol;
    }

    public static FileLocation fromLocation(String location) {
        if (!location.contains(COLON)) {
            return new FileLocation(location, ProtocolNames.FILE);
        }
        int i = location.indexOf(COLON);
        String protocol = location.substring(0, i);
        String file = location.substring(i + 1);
        return new FileLocation(file, protocol.toLowerCase());
    }

    public String getFile() {
        return this.file;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String toString() {
        return "FileLocation [file=" + this.file + ", protocol=" + this.protocol + "]";
    }
}

