/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.config.service.zookeeper;

import com.dangdang.config.service.zookeeper.ZookeeperConfigGroup;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Properties;
import org.apache.curator.utils.ZKPaths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigLocalCache {
    private String localCachePath;
    private static final String SUFFIX = ".cache";
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigLocalCache.class);

    public ConfigLocalCache(String localCacheFolder, String rootNode) {
        this.localCachePath = ZKPaths.makePath((String)localCacheFolder, (String)rootNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveLocalCache(ZookeeperConfigGroup configNode, String node) {
        String localFilePath = this.genCacheFilePath(node);
        LOGGER.debug("Saving cache to file: {}", (Object)localFilePath);
        Map<String, String> data = configNode.exportProperties();
        if (data != null && data.size() > 0) {
            Properties properties = new Properties();
            for (Map.Entry<String, String> entry : data.entrySet()) {
                properties.put(entry.getKey(), entry.getValue());
            }
            Writer writer = null;
            try {
                writer = new OutputStreamWriter((OutputStream)new FileOutputStream(localFilePath), "UTF-8");
                properties.store(writer, String.format("Local cache of configs group: %s", node));
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private String genCacheFilePath(String node) {
        this.checkFolderExistence();
        StringBuilder builder = new StringBuilder();
        builder.append(this.localCachePath);
        builder.append(File.separatorChar);
        builder.append(node);
        builder.append(SUFFIX);
        return builder.toString();
    }

    private void checkFolderExistence() {
        File file = new File(this.localCachePath);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public String toString() {
        return "ConfigLocalCache{localCachePath='" + this.localCachePath + '\'' + '}';
    }
}

