/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.config.service.zookeeper;

import com.dangdang.config.service.zookeeper.ZookeeperConfigGroup;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.CuratorEvent;
import org.apache.curator.framework.api.CuratorListener;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigNodeEventListener
implements CuratorListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigNodeEventListener.class);
    private final ZookeeperConfigGroup configNode;

    public ConfigNodeEventListener(ZookeeperConfigGroup configNode) {
        this.configNode = configNode;
    }

    public void eventReceived(CuratorFramework client, CuratorEvent event) throws Exception {
        WatchedEvent watchedEvent;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(event.toString());
        }
        if ((watchedEvent = event.getWatchedEvent()) != null) {
            LOGGER.debug("Watched event: {}" + watchedEvent);
            if (watchedEvent.getState() == Watcher.Event.KeeperState.SyncConnected) {
                boolean someChange = false;
                switch (watchedEvent.getType()) {
                    case NodeChildrenChanged: {
                        this.configNode.loadNode();
                        someChange = true;
                        break;
                    }
                    case NodeDataChanged: {
                        this.configNode.reloadKey(watchedEvent.getPath());
                        someChange = true;
                        break;
                    }
                }
                if (someChange && this.configNode.getConfigLocalCache() != null) {
                    this.configNode.getConfigLocalCache().saveLocalCache(this.configNode, this.configNode.getNode());
                }
            }
        }
    }
}

