/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.config.service.zookeeper;

import com.dangdang.config.service.ConfigGroup;
import com.dangdang.config.service.GeneralConfigGroup;
import com.dangdang.config.service.util.Tuple;
import com.dangdang.config.service.zookeeper.ConfigLocalCache;
import com.dangdang.config.service.zookeeper.ConfigNodeEventListener;
import com.dangdang.config.service.zookeeper.ZookeeperConfigProfile;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PreDestroy;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.CuratorListener;
import org.apache.curator.framework.api.GetChildrenBuilder;
import org.apache.curator.framework.api.GetDataBuilder;
import org.apache.curator.utils.ZKPaths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperConfigGroup
extends GeneralConfigGroup {
    private static final long serialVersionUID = 1L;
    private ZookeeperConfigProfile configProfile;
    private String node;
    private CuratorFramework client;
    private ConfigLocalCache configLocalCache;
    static final Logger LOGGER = LoggerFactory.getLogger(ZookeeperConfigGroup.class);
    private CuratorListener listener = new ConfigNodeEventListener(this);

    public ZookeeperConfigGroup(ZookeeperConfigProfile configProfile, String node, boolean enumerable) {
        this(configProfile, node);
        this.enumerable = enumerable;
    }

    public ZookeeperConfigGroup(ZookeeperConfigProfile configProfile, String node) {
        this(null, configProfile, node);
    }

    public ZookeeperConfigGroup(ConfigGroup internalConfigGroup, ZookeeperConfigProfile configProfile, String node) {
        super(internalConfigGroup);
        this.configProfile = configProfile;
        this.node = node;
        if (configProfile.isOpenLocalCache()) {
            this.configLocalCache = new ConfigLocalCache(System.getProperty("user.home") + "/.config-toolkit", configProfile.getRootNode());
        }
        this.initConfigs();
    }

    private void initConfigs() {
        this.client = CuratorFrameworkFactory.newClient((String)this.configProfile.getConnectStr(), (RetryPolicy)this.configProfile.getRetryPolicy());
        this.client.start();
        this.client.getCuratorListenable().addListener((Object)this.listener);
        LOGGER.debug("Loading properties for node: {}", (Object)this.node);
        this.loadNode();
        if (this.configLocalCache != null) {
            this.configLocalCache.saveLocalCache(this, this.node);
        }
    }

    void loadNode() {
        String nodePath = ZKPaths.makePath((String)this.configProfile.getVersionedRootNode(), (String)this.node);
        GetChildrenBuilder childrenBuilder = this.client.getChildren();
        try {
            List children = (List)((BackgroundPathable)childrenBuilder.watched()).forPath(nodePath);
            if (children != null) {
                HashMap<String, String> configs = new HashMap<String, String>();
                for (String child : children) {
                    Tuple<String, String> keyValue = this.loadKey(ZKPaths.makePath((String)nodePath, (String)child));
                    if (keyValue == null) continue;
                    configs.put(keyValue.getFirst(), keyValue.getSecond());
                }
                this.cleanAndPutAll(configs);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    void reloadKey(String nodePath) {
        try {
            Tuple<String, String> keyValue = this.loadKey(nodePath);
            if (keyValue != null) {
                super.put(keyValue.getFirst(), keyValue.getSecond());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Tuple<String, String> loadKey(String nodePath) throws Exception {
        String nodeName = ZKPaths.getNodeFromPath((String)nodePath);
        Set<String> keysSpecified = this.configProfile.getKeysSpecified();
        switch (this.configProfile.getKeyLoadingMode()) {
            case INCLUDE: {
                if (keysSpecified != null && keysSpecified.contains(nodeName)) break;
                return null;
            }
            case EXCLUDE: {
                if (!keysSpecified.contains(nodeName)) break;
                return null;
            }
            case ALL: {
                break;
            }
        }
        GetDataBuilder data = this.client.getData();
        String value = new String((byte[])((BackgroundPathable)data.watched()).forPath(nodePath), "UTF-8");
        return new Tuple<String, String>(nodeName, value);
    }

    public String getNode() {
        return this.node;
    }

    public ConfigLocalCache getConfigLocalCache() {
        return this.configLocalCache;
    }

    public Map<String, String> exportProperties() {
        return new HashMap<String, String>(this);
    }

    @Override
    @PreDestroy
    public void close() {
        if (this.client != null) {
            this.client.getCuratorListenable().removeListener((Object)this.listener);
            this.client.close();
        }
    }
}

