/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.jdbc.core.resultset;

import com.dangdang.ddframe.rdb.sharding.jdbc.core.resultset.GeneratedKeysResultSetMetaData;
import com.dangdang.ddframe.rdb.sharding.jdbc.unsupported.AbstractUnsupportedGeneratedKeysResultSet;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Iterator;

public class GeneratedKeysResultSet
extends AbstractUnsupportedGeneratedKeysResultSet {
    private final Iterator<Number> generatedKeys;
    private final String generatedKeyColumn;
    private final Statement statement;
    private boolean closed;
    private Number currentGeneratedKey;

    public GeneratedKeysResultSet() {
        this.generatedKeys = Collections.emptyList().iterator();
        this.generatedKeyColumn = null;
        this.statement = null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.closed || !this.generatedKeys.hasNext()) {
            this.currentGeneratedKey = null;
            return false;
        }
        this.currentGeneratedKey = this.generatedKeys.next();
        return true;
    }

    @Override
    public void close() throws SQLException {
        this.closed = true;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkState();
        return new GeneratedKeysResultSetMetaData(this.generatedKeyColumn);
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.checkState();
        return false;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.checkStateForGetData();
        return this.currentGeneratedKey.toString();
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.getString(1);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        this.checkStateForGetData();
        return this.currentGeneratedKey.byteValue();
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return this.getByte(1);
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.checkStateForGetData();
        return this.currentGeneratedKey.shortValue();
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return this.getShort(1);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.checkStateForGetData();
        return this.currentGeneratedKey.intValue();
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return this.getInt(1);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.checkStateForGetData();
        return this.currentGeneratedKey.longValue();
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.getLong(1);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.checkStateForGetData();
        return this.currentGeneratedKey.floatValue();
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.getFloat(1);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.checkStateForGetData();
        return this.currentGeneratedKey.doubleValue();
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.getDouble(1);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        this.checkStateForGetData();
        return new BigDecimal(this.currentGeneratedKey.longValue()).setScale(scale, 4);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return this.getBigDecimal(1, scale);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.checkStateForGetData();
        return new BigDecimal(this.currentGeneratedKey.longValue());
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.getBigDecimal(1);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.checkStateForGetData();
        return this.getString(columnIndex).getBytes();
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.getBytes(1);
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.checkStateForGetData();
        return this.currentGeneratedKey;
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(1);
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        this.checkState();
        return 1;
    }

    @Override
    public int getType() throws SQLException {
        this.checkState();
        return 1003;
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.checkState();
        return 1007;
    }

    @Override
    public Statement getStatement() throws SQLException {
        this.checkState();
        return this.statement;
    }

    private void checkState() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"ResultSet has closed.");
    }

    private void checkStateForGetData() {
        this.checkState();
        Preconditions.checkNotNull((Object)this.currentGeneratedKey, (Object)"ResultSet should call next or has no more data.");
    }

    @ConstructorProperties(value={"generatedKeys", "generatedKeyColumn", "statement"})
    public GeneratedKeysResultSet(Iterator<Number> generatedKeys, String generatedKeyColumn, Statement statement) {
        this.generatedKeys = generatedKeys;
        this.generatedKeyColumn = generatedKeyColumn;
        this.statement = statement;
    }
}

