/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parsing.parser.clause;

import com.dangdang.ddframe.rdb.sharding.parsing.lexer.LexerEngine;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.Literals;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.Symbol;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.clause.SQLClauseParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.expression.SQLExpression;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.expression.SQLIdentifierExpression;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.expression.SQLIgnoreExpression;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.expression.SQLNumberExpression;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.expression.SQLPlaceholderExpression;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.expression.SQLPropertyExpression;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.expression.SQLTextExpression;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.sql.SQLStatement;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.token.TableToken;
import com.dangdang.ddframe.rdb.sharding.util.NumberUtil;
import com.dangdang.ddframe.rdb.sharding.util.SQLUtil;
import java.beans.ConstructorProperties;

public final class ExpressionClauseParser
implements SQLClauseParser {
    private final LexerEngine lexerEngine;

    public SQLExpression parse(SQLStatement sqlStatement) {
        int beginPosition = this.lexerEngine.getCurrentToken().getEndPosition();
        SQLExpression result = this.parseExpression(sqlStatement);
        if (result instanceof SQLPropertyExpression) {
            this.setTableToken(sqlStatement, beginPosition, (SQLPropertyExpression)result);
        }
        return result;
    }

    private SQLExpression parseExpression(SQLStatement sqlStatement) {
        String literals = this.lexerEngine.getCurrentToken().getLiterals();
        int beginPosition = this.lexerEngine.getCurrentToken().getEndPosition() - literals.length();
        SQLExpression expression = this.getExpression(literals, sqlStatement);
        this.lexerEngine.nextToken();
        if (this.lexerEngine.skipIfEqual(Symbol.DOT)) {
            String property = this.lexerEngine.getCurrentToken().getLiterals();
            this.lexerEngine.nextToken();
            return this.skipIfCompositeExpression(sqlStatement) ? new SQLIgnoreExpression(this.lexerEngine.getInput().substring(beginPosition, this.lexerEngine.getCurrentToken().getEndPosition())) : new SQLPropertyExpression(new SQLIdentifierExpression(literals), property);
        }
        if (this.lexerEngine.equalAny(Symbol.LEFT_PAREN)) {
            this.lexerEngine.skipParentheses(sqlStatement);
            this.skipRestCompositeExpression(sqlStatement);
            return new SQLIgnoreExpression(this.lexerEngine.getInput().substring(beginPosition, this.lexerEngine.getCurrentToken().getEndPosition() - this.lexerEngine.getCurrentToken().getLiterals().length()).trim());
        }
        return this.skipIfCompositeExpression(sqlStatement) ? new SQLIgnoreExpression(this.lexerEngine.getInput().substring(beginPosition, this.lexerEngine.getCurrentToken().getEndPosition())) : expression;
    }

    private SQLExpression getExpression(String literals, SQLStatement sqlStatement) {
        if (this.lexerEngine.equalAny(Symbol.QUESTION)) {
            sqlStatement.increaseParametersIndex();
            return new SQLPlaceholderExpression(sqlStatement.getParametersIndex() - 1);
        }
        if (this.lexerEngine.equalAny(Literals.CHARS)) {
            return new SQLTextExpression(literals);
        }
        if (this.lexerEngine.equalAny(Literals.INT)) {
            return new SQLNumberExpression(NumberUtil.getExactlyNumber(literals, 10));
        }
        if (this.lexerEngine.equalAny(Literals.FLOAT)) {
            return new SQLNumberExpression(Double.parseDouble(literals));
        }
        if (this.lexerEngine.equalAny(Literals.HEX)) {
            return new SQLNumberExpression(NumberUtil.getExactlyNumber(literals, 16));
        }
        if (this.lexerEngine.equalAny(Literals.IDENTIFIER)) {
            return new SQLIdentifierExpression(SQLUtil.getExactlyValue(literals));
        }
        return new SQLIgnoreExpression(literals);
    }

    private boolean skipIfCompositeExpression(SQLStatement sqlStatement) {
        if (this.lexerEngine.equalAny(Symbol.PLUS, Symbol.SUB, Symbol.STAR, Symbol.SLASH, Symbol.PERCENT, Symbol.AMP, Symbol.BAR, Symbol.DOUBLE_AMP, Symbol.DOUBLE_BAR, Symbol.CARET, Symbol.DOT, Symbol.LEFT_PAREN)) {
            this.lexerEngine.skipParentheses(sqlStatement);
            this.skipRestCompositeExpression(sqlStatement);
            return true;
        }
        return false;
    }

    private void skipRestCompositeExpression(SQLStatement sqlStatement) {
        while (this.lexerEngine.skipIfEqual(Symbol.PLUS, Symbol.SUB, Symbol.STAR, Symbol.SLASH, Symbol.PERCENT, Symbol.AMP, Symbol.BAR, Symbol.DOUBLE_AMP, Symbol.DOUBLE_BAR, Symbol.CARET, Symbol.DOT)) {
            if (this.lexerEngine.equalAny(Symbol.QUESTION)) {
                sqlStatement.increaseParametersIndex();
            }
            this.lexerEngine.nextToken();
            this.lexerEngine.skipParentheses(sqlStatement);
        }
    }

    private void setTableToken(SQLStatement sqlStatement, int beginPosition, SQLPropertyExpression propertyExpr) {
        String owner = propertyExpr.getOwner().getName();
        if (sqlStatement.getTables().getTableNames().contains(SQLUtil.getExactlyValue(propertyExpr.getOwner().getName()))) {
            sqlStatement.getSqlTokens().add(new TableToken(beginPosition - owner.length(), owner));
        }
    }

    @ConstructorProperties(value={"lexerEngine"})
    public ExpressionClauseParser(LexerEngine lexerEngine) {
        this.lexerEngine = lexerEngine;
    }
}

