/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parsing.parser.context.table;

import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.table.Table;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;

public final class Tables {
    private final List<Table> tables = new ArrayList<Table>();

    public void add(Table table) {
        this.tables.add(table);
    }

    public boolean isEmpty() {
        return this.tables.isEmpty();
    }

    public boolean isSingleTable() {
        return 1 == this.tables.size();
    }

    public String getSingleTableName() {
        Preconditions.checkArgument((!this.isEmpty() ? 1 : 0) != 0);
        return this.tables.get(0).getName();
    }

    public Collection<String> getTableNames() {
        TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (Table each : this.tables) {
            result.add(each.getName());
        }
        return result;
    }

    public Optional<Table> find(String tableNameOrAlias) {
        Optional<Table> tableFromName = this.findTableFromName(tableNameOrAlias);
        return tableFromName.isPresent() ? tableFromName : this.findTableFromAlias(tableNameOrAlias);
    }

    private Optional<Table> findTableFromName(String name) {
        for (Table each : this.tables) {
            if (!each.getName().equalsIgnoreCase(name)) continue;
            return Optional.of((Object)each);
        }
        return Optional.absent();
    }

    private Optional<Table> findTableFromAlias(String alias) {
        for (Table each : this.tables) {
            if (!each.getAlias().isPresent() || !((String)each.getAlias().get()).equalsIgnoreCase(alias)) continue;
            return Optional.of((Object)each);
        }
        return Optional.absent();
    }

    public String toString() {
        return "Tables(tables=" + this.tables + ")";
    }
}

