/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parsing.parser.dialect.oracle.clause;

import com.dangdang.ddframe.rdb.sharding.parsing.lexer.LexerEngine;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.dialect.oracle.OracleKeyword;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.DefaultKeyword;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.Symbol;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.clause.ExpressionClauseParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.clause.SQLClauseParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.sql.dql.select.SelectStatement;

public final class OracleForClauseParser
implements SQLClauseParser {
    private final LexerEngine lexerEngine;
    private final ExpressionClauseParser expressionClauseParser;

    public OracleForClauseParser(LexerEngine lexerEngine) {
        this.lexerEngine = lexerEngine;
        this.expressionClauseParser = new ExpressionClauseParser(lexerEngine);
    }

    public void parse(SelectStatement selectStatement) {
        if (!this.lexerEngine.skipIfEqual(DefaultKeyword.FOR)) {
            return;
        }
        this.lexerEngine.accept(DefaultKeyword.UPDATE);
        if (this.lexerEngine.skipIfEqual(DefaultKeyword.OF)) {
            do {
                this.expressionClauseParser.parse(selectStatement);
            } while (this.lexerEngine.skipIfEqual(Symbol.COMMA));
        }
        if (this.lexerEngine.equalAny(OracleKeyword.NOWAIT, OracleKeyword.WAIT)) {
            this.lexerEngine.nextToken();
        } else if (this.lexerEngine.skipIfEqual(OracleKeyword.SKIP)) {
            this.lexerEngine.accept(OracleKeyword.LOCKED);
        }
    }
}

