/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.policies;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.WriteType;
import com.datastax.driver.core.policies.RetryPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingRetryPolicy
implements RetryPolicy {
    private static final Logger logger = LoggerFactory.getLogger(LoggingRetryPolicy.class);
    private final RetryPolicy policy;

    public LoggingRetryPolicy(RetryPolicy policy) {
        this.policy = policy;
    }

    private static ConsistencyLevel cl(ConsistencyLevel cl, RetryPolicy.RetryDecision decision) {
        return decision.getRetryConsistencyLevel() == null ? cl : decision.getRetryConsistencyLevel();
    }

    @Override
    public RetryPolicy.RetryDecision onReadTimeout(Statement statement, ConsistencyLevel cl, int requiredResponses, int receivedResponses, boolean dataRetrieved, int nbRetry) {
        RetryPolicy.RetryDecision decision = this.policy.onReadTimeout(statement, cl, requiredResponses, receivedResponses, dataRetrieved, nbRetry);
        switch (decision.getType()) {
            case IGNORE: {
                String f1 = "Ignoring read timeout (initial consistency: %s, required responses: %d, received responses: %d, data retrieved: %b, retries: %d)";
                logger.info(String.format(f1, new Object[]{cl, requiredResponses, receivedResponses, dataRetrieved, nbRetry}));
                break;
            }
            case RETRY: {
                String f2 = "Retrying on read timeout at consistency %s (initial consistency: %s, required responses: %d, received responses: %d, data retrieved: %b, retries: %d)";
                logger.info(String.format(f2, new Object[]{LoggingRetryPolicy.cl(cl, decision), cl, requiredResponses, receivedResponses, dataRetrieved, nbRetry}));
            }
        }
        return decision;
    }

    @Override
    public RetryPolicy.RetryDecision onWriteTimeout(Statement statement, ConsistencyLevel cl, WriteType writeType, int requiredAcks, int receivedAcks, int nbRetry) {
        RetryPolicy.RetryDecision decision = this.policy.onWriteTimeout(statement, cl, writeType, requiredAcks, receivedAcks, nbRetry);
        switch (decision.getType()) {
            case IGNORE: {
                String f1 = "Ignoring write timeout (initial consistency: %s, write type: %s, required acknowledgments: %d, received acknowledgments: %d, retries: %d)";
                logger.info(String.format(f1, new Object[]{cl, writeType, requiredAcks, receivedAcks, nbRetry}));
                break;
            }
            case RETRY: {
                String f2 = "Retrying on write timeout at consistency %s(initial consistency: %s, write type: %s, required acknowledgments: %d, received acknowledgments: %d, retries: %d)";
                logger.info(String.format(f2, new Object[]{LoggingRetryPolicy.cl(cl, decision), cl, writeType, requiredAcks, receivedAcks, nbRetry}));
            }
        }
        return decision;
    }

    @Override
    public RetryPolicy.RetryDecision onUnavailable(Statement statement, ConsistencyLevel cl, int requiredReplica, int aliveReplica, int nbRetry) {
        RetryPolicy.RetryDecision decision = this.policy.onUnavailable(statement, cl, requiredReplica, aliveReplica, nbRetry);
        switch (decision.getType()) {
            case IGNORE: {
                String f1 = "Ignoring unavailable exception (initial consistency: %s, required replica: %d, alive replica: %d, retries: %d)";
                logger.info(String.format(f1, new Object[]{cl, requiredReplica, aliveReplica, nbRetry}));
                break;
            }
            case RETRY: {
                String f2 = "Retrying on unavailable exception at consistency %s (initial consistency: %s, required replica: %d, alive replica: %d, retries: %d)";
                logger.info(String.format(f2, new Object[]{LoggingRetryPolicy.cl(cl, decision), cl, requiredReplica, aliveReplica, nbRetry}));
            }
        }
        return decision;
    }
}

