/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.config.composite;

import com.datastax.oss.driver.api.core.config.DriverConfig;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.internal.core.config.composite.CompositeDriverExecutionProfile;
import com.datastax.oss.driver.shaded.guava.common.collect.Sets;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class CompositeDriverConfig
implements DriverConfig {
    private final DriverConfig primaryConfig;
    private final DriverConfig fallbackConfig;
    private final Map<String, CompositeDriverExecutionProfile> profiles = new ConcurrentHashMap<String, CompositeDriverExecutionProfile>();

    public CompositeDriverConfig(@NonNull DriverConfig primaryConfig, @NonNull DriverConfig fallbackConfig) {
        this.primaryConfig = Objects.requireNonNull(primaryConfig);
        this.fallbackConfig = Objects.requireNonNull(fallbackConfig);
    }

    @Override
    @NonNull
    public DriverExecutionProfile getProfile(@NonNull String profileName) {
        return this.profiles.compute(profileName, (k, v) -> v == null ? new CompositeDriverExecutionProfile(this.primaryConfig, this.fallbackConfig, profileName) : v.refresh());
    }

    @Override
    @NonNull
    public Map<String, ? extends DriverExecutionProfile> getProfiles() {
        for (String name : Sets.union(this.primaryConfig.getProfiles().keySet(), this.fallbackConfig.getProfiles().keySet())) {
            this.getProfile(name);
        }
        return Collections.unmodifiableMap(this.profiles);
    }
}

