/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.testinfra.ccm;

import com.datastax.oss.driver.api.core.DefaultProtocolVersion;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.Version;
import com.datastax.oss.driver.api.testinfra.CassandraResourceRule;
import com.datastax.oss.driver.api.testinfra.ccm.CcmBridge;
import com.datastax.oss.driver.api.testinfra.requirement.BackendType;
import com.datastax.oss.driver.api.testinfra.requirement.VersionRequirement;
import java.util.Collection;
import java.util.Optional;
import org.junit.AssumptionViolatedException;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public abstract class BaseCcmRule
extends CassandraResourceRule {
    protected final CcmBridge ccmBridge;

    BaseCcmRule(CcmBridge ccmBridge) {
        this.ccmBridge = ccmBridge;
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                ccmBridge.remove();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }));
    }

    protected void before() {
        this.ccmBridge.create();
        this.ccmBridge.start();
    }

    protected void after() {
        this.ccmBridge.remove();
    }

    public Statement apply(Statement base, Description description) {
        final BackendType backend = this.ccmBridge.getDseVersion().isPresent() ? BackendType.DSE : BackendType.CASSANDRA;
        final Version version = this.ccmBridge.getDseVersion().orElseGet(this.ccmBridge::getCassandraVersion);
        final Collection<VersionRequirement> requirements = VersionRequirement.fromAnnotations(description);
        if (VersionRequirement.meetsAny(requirements, backend, version)) {
            return super.apply(base, description);
        }
        return new Statement(){

            public void evaluate() {
                throw new AssumptionViolatedException(VersionRequirement.buildReasonString(requirements, backend, version));
            }
        };
    }

    public Version getCassandraVersion() {
        return this.ccmBridge.getCassandraVersion();
    }

    public Optional<Version> getDseVersion() {
        return this.ccmBridge.getDseVersion();
    }

    @Override
    public ProtocolVersion getHighestProtocolVersion() {
        if (this.ccmBridge.getCassandraVersion().compareTo(Version.V2_2_0) >= 0) {
            return DefaultProtocolVersion.V4;
        }
        return DefaultProtocolVersion.V3;
    }
}

