/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.testinfra.ccm;

import com.datastax.oss.driver.api.testinfra.ccm.BaseCcmRule;
import com.datastax.oss.driver.api.testinfra.ccm.CcmBridge;
import java.util.concurrent.atomic.AtomicReference;

public class CustomCcmRule
extends BaseCcmRule {
    private static final AtomicReference<CustomCcmRule> CURRENT = new AtomicReference();

    CustomCcmRule(CcmBridge ccmBridge) {
        super(ccmBridge);
    }

    @Override
    protected void before() {
        if (CURRENT.get() == null && CURRENT.compareAndSet(null, this)) {
            super.before();
        } else if (CURRENT.get() != this) {
            throw new IllegalStateException("Attempting to use a Ccm rule while another is in use.  This is disallowed");
        }
    }

    @Override
    protected void after() {
        super.after();
        CURRENT.compareAndSet(this, null);
    }

    public CcmBridge getCcmBridge() {
        return this.ccmBridge;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final CcmBridge.Builder bridgeBuilder = CcmBridge.builder();

        public Builder withNodes(int ... nodes) {
            this.bridgeBuilder.withNodes(nodes);
            return this;
        }

        public Builder withCassandraConfiguration(String key, Object value) {
            this.bridgeBuilder.withCassandraConfiguration(key, value);
            return this;
        }

        public Builder withDseConfiguration(String key, Object value) {
            this.bridgeBuilder.withDseConfiguration(key, value);
            return this;
        }

        public Builder withDseConfiguration(String rawYaml) {
            this.bridgeBuilder.withDseConfiguration(rawYaml);
            return this;
        }

        public Builder withDseWorkloads(String ... workloads) {
            this.bridgeBuilder.withDseWorkloads(workloads);
            return this;
        }

        public Builder withJvmArgs(String ... jvmArgs) {
            this.bridgeBuilder.withJvmArgs(jvmArgs);
            return this;
        }

        public Builder withCreateOption(String option) {
            this.bridgeBuilder.withCreateOption(option);
            return this;
        }

        public Builder withSsl() {
            this.bridgeBuilder.withSsl();
            return this;
        }

        public Builder withSslLocalhostCn() {
            this.bridgeBuilder.withSslLocalhostCn();
            return this;
        }

        public Builder withSslAuth() {
            this.bridgeBuilder.withSslAuth();
            return this;
        }

        public CustomCcmRule build() {
            return new CustomCcmRule(this.bridgeBuilder.build());
        }
    }
}

