/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.data;

import com.deepoove.poi.data.NumberingFormat;
import com.deepoove.poi.data.NumberingItemRenderData;
import com.deepoove.poi.data.ParagraphRenderData;
import com.deepoove.poi.data.Paragraphs;
import com.deepoove.poi.data.RenderData;
import com.deepoove.poi.data.TextRenderData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class NumberingRenderData
implements RenderData {
    private static final long serialVersionUID = 1L;
    private List<NumberingFormat> multiFormats = new ArrayList<NumberingFormat>();
    private List<NumberingItemRenderData> items = new ArrayList<NumberingItemRenderData>();

    public NumberingRenderData() {
    }

    public NumberingRenderData(List<ParagraphRenderData> items) {
        this(NumberingFormat.BULLET, items);
    }

    public NumberingRenderData(NumberingFormat format, List<ParagraphRenderData> items) {
        this.multiFormats.add(format);
        if (null != items) {
            items.forEach(item -> this.items.add(new NumberingItemRenderData(0, (ParagraphRenderData)item)));
        }
    }

    public NumberingRenderData(TextRenderData ... text) {
        this(NumberingFormat.BULLET, text);
    }

    public NumberingRenderData(NumberingFormat format, TextRenderData ... text) {
        this.multiFormats.add(format);
        if (null != text) {
            this.items = Arrays.stream(text).map(data -> new NumberingItemRenderData(0, Paragraphs.of(data).create())).collect(Collectors.toList());
        }
    }

    public static NumberingRenderData build(TextRenderData ... text) {
        return new NumberingRenderData(NumberingFormat.BULLET, text);
    }

    public List<NumberingFormat> getFormats() {
        return this.multiFormats;
    }

    public void setFormats(List<NumberingFormat> formats) {
        this.multiFormats = formats;
    }

    public List<NumberingItemRenderData> getItems() {
        return this.items;
    }

    public void setItems(List<NumberingItemRenderData> items) {
        this.items = items;
    }
}

