/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.render.processor;

import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.config.PreRenderDataCastor;
import com.deepoove.poi.policy.RenderPolicy;
import com.deepoove.poi.template.ElementTemplate;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatePolicy {
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegatePolicy.class);

    public static void invoke(RenderPolicy policy, ElementTemplate eleTemplate, Object data, XWPFTemplate template) {
        Objects.requireNonNull(policy, "Cannot find render policy: [" + eleTemplate.getTagName() + "]");
        Object model = data;
        List<PreRenderDataCastor> preRenderDataCastors = template.getConfig().getPreRenderDataCastors();
        if (null != preRenderDataCastors) {
            for (PreRenderDataCastor preRenderDataCastor : preRenderDataCastors) {
                model = preRenderDataCastor.preCast(policy, model);
            }
        }
        LOGGER.info("Start render Template {}, Sign:{}, policy:{}", new Object[]{eleTemplate, DelegatePolicy.logChar(eleTemplate.getSign()), ClassUtils.getShortClassName(policy.getClass())});
        policy.render(eleTemplate, model, template);
    }

    private static String logChar(Character character) {
        return null == character ? "" : ('\u0000' == character.charValue() ? "" : character.toString());
    }
}

