/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.render.processor;

import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.render.compute.RenderDataCompute;
import com.deepoove.poi.render.processor.ElementProcessor;
import com.deepoove.poi.render.processor.InlineIterableProcessor;
import com.deepoove.poi.render.processor.IterableProcessor;
import com.deepoove.poi.render.processor.Visitor;
import com.deepoove.poi.resolver.Resolver;
import com.deepoove.poi.template.BlockTemplate;
import com.deepoove.poi.template.ChartTemplate;
import com.deepoove.poi.template.InlineIterableTemplate;
import com.deepoove.poi.template.IterableTemplate;
import com.deepoove.poi.template.MetaTemplate;
import com.deepoove.poi.template.PictImageTemplate;
import com.deepoove.poi.template.PictureTemplate;
import com.deepoove.poi.template.run.RunTemplate;
import com.deepoove.poi.xwpf.XWPFTextboxContent;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.xmlbeans.XmlObject;

public class DocumentProcessor
implements Visitor {
    private ElementProcessor elementProcessor;
    private IterableProcessor iterableProcessor;
    private InlineIterableProcessor inlineIterableProcessor;

    public DocumentProcessor(XWPFTemplate template, Resolver resolver, RenderDataCompute renderDataCompute) {
        this.elementProcessor = new ElementProcessor(template, resolver, renderDataCompute);
        this.iterableProcessor = new IterableProcessor(template, resolver, renderDataCompute);
        this.inlineIterableProcessor = new InlineIterableProcessor(template, resolver, renderDataCompute);
    }

    public void process(List<MetaTemplate> templates) {
        templates.forEach(template -> template.accept(this));
        Set<XWPFTextboxContent> textboxs = this.obtainTextboxes(templates);
        textboxs.forEach(content -> content.getXmlObject().set((XmlObject)content.getCTTxbxContent()));
    }

    private Set<XWPFTextboxContent> obtainTextboxes(List<MetaTemplate> templates) {
        HashSet<XWPFTextboxContent> textboxs = new HashSet<XWPFTextboxContent>();
        if (CollectionUtils.isEmpty(templates)) {
            return textboxs;
        }
        templates.forEach(template -> {
            RunTemplate checkTemplate;
            RunTemplate runTemplate = template instanceof RunTemplate ? (RunTemplate)template : (checkTemplate = template instanceof BlockTemplate ? ((BlockTemplate)template).getStartMark() : null);
            if (null != checkTemplate && checkTemplate.getRun().getParent() instanceof XWPFParagraph && checkTemplate.getRun().getParagraph().getBody() instanceof XWPFTextboxContent) {
                textboxs.add((XWPFTextboxContent)checkTemplate.getRun().getParagraph().getBody());
            }
        });
        return textboxs;
    }

    @Override
    public void visit(InlineIterableTemplate iterableTemplate) {
        iterableTemplate.accept(this.inlineIterableProcessor);
    }

    @Override
    public void visit(IterableTemplate iterableTemplate) {
        iterableTemplate.accept(this.iterableProcessor);
    }

    @Override
    public void visit(RunTemplate runTemplate) {
        runTemplate.accept(this.elementProcessor);
    }

    @Override
    public void visit(PictureTemplate pictureTemplate) {
        pictureTemplate.accept(this.elementProcessor);
    }

    @Override
    public void visit(PictImageTemplate pictImageTemplate) {
        pictImageTemplate.accept(this.elementProcessor);
    }

    @Override
    public void visit(ChartTemplate chartTemplate) {
        chartTemplate.accept(this.elementProcessor);
    }
}

