/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.xwpf;

import com.deepoove.poi.util.ReflectionUtils;
import com.deepoove.poi.xwpf.BodyContainer;
import com.deepoove.poi.xwpf.XWPFSection;
import java.util.List;
import org.apache.poi.ooxml.POIXMLDocumentPart;
import org.apache.poi.xwpf.usermodel.BodyElementType;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFFooter;
import org.apache.poi.xwpf.usermodel.XWPFHeader;
import org.apache.poi.xwpf.usermodel.XWPFHeaderFooter;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.XmlCursor;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBody;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHdrFtr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPr;

public class HeaderFooterBodyContainer
implements BodyContainer {
    private XWPFHeaderFooter headerFooter;

    public HeaderFooterBodyContainer(XWPFHeaderFooter hf) {
        this.headerFooter = hf;
    }

    @Override
    public void removeBodyElement(int pos) {
        List<IBodyElement> bodyElements = this.getBodyElements();
        if (pos >= 0 && pos < bodyElements.size()) {
            BodyElementType type = bodyElements.get(pos).getElementType();
            if (type == BodyElementType.TABLE) {
                this.headerFooter.removeTable((XWPFTable)bodyElements.get(pos));
            }
            if (type == BodyElementType.PARAGRAPH) {
                this.headerFooter.removeParagraph((XWPFParagraph)bodyElements.get(pos));
            }
        }
    }

    @Override
    public void setParagraph(XWPFParagraph p, int paraPos) {
        List paragraphs = (List)ReflectionUtils.getValue("paragraphs", this.headerFooter);
        paragraphs.set(paraPos, p);
        CTHdrFtr ctTc = this.headerFooter._getHdrFtr();
        ctTc.setPArray(paraPos, p.getCTP());
    }

    @Override
    public IBody getTarget() {
        return this.headerFooter;
    }

    @Override
    public void setTable(int pos, XWPFTable table) {
        List tables = (List)ReflectionUtils.getValue("tables", this.headerFooter);
        tables.set(pos, table);
        this.headerFooter._getHdrFtr().setTblArray(pos, table.getCTTbl());
    }

    @Override
    public XWPFTable insertNewTable(XWPFRun run, int row, int col) {
        int i;
        XmlCursor cursor = ((XWPFParagraph)run.getParent()).getCTP().newCursor();
        XWPFTable table = this.insertNewTbl(cursor);
        List rows = table.getRows();
        for (i = 0; i < rows.size(); ++i) {
            table.removeRow(i);
        }
        for (i = 0; i < row; ++i) {
            XWPFTableRow tabRow = table.getRow(i) == null ? table.createRow() : table.getRow(i);
            for (int k = 0; k < col; ++k) {
                if (tabRow.getCell(k) != null) continue;
                tabRow.createCell();
            }
        }
        return table;
    }

    @Override
    public XWPFSection closelySectPr(IBodyElement element) {
        CTBody body;
        XWPFDocument doc = this.headerFooter.getXWPFDocument();
        String relationId = doc.getRelationId((POIXMLDocumentPart)this.headerFooter);
        if (null != relationId) {
            List bodyElements = doc.getBodyElements();
            for (IBodyElement ele : bodyElements) {
                CTPPr pPr;
                XWPFParagraph para;
                CTP ctp;
                if (!(ele instanceof XWPFParagraph) || !(ctp = (para = (XWPFParagraph)ele).getCTP()).isSetPPr() || !(pPr = ctp.getPPr()).isSetSectPr()) continue;
                XWPFSection xwpfSection = new XWPFSection(pPr.getSectPr());
                if (!(this.headerFooter instanceof XWPFHeader ? xwpfSection.haveHeader(relationId) : this.headerFooter instanceof XWPFFooter && xwpfSection.haveFooter(relationId))) continue;
                return xwpfSection;
            }
        }
        if ((body = doc.getDocument().getBody()).isSetSectPr()) {
            return new XWPFSection(body.getSectPr());
        }
        return null;
    }

    @Override
    public int elementPageWidth(IBodyElement element) {
        XWPFSection section = this.closelySectPr(element);
        if (null == section) {
            throw new IllegalAccessError("Unable to read the page where the element is located.");
        }
        return section.getPageContentWidth().intValue();
    }
}

