/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.util;

import com.deepoove.poi.xwpf.XWPFStructuredDocumentTagContent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.xwpf.usermodel.IRunBody;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;

public final class ParagraphUtils {
    public static String trimLine(XWPFParagraph paragraph) {
        return ParagraphUtils.trimLine(paragraph.getText());
    }

    public static String trimLine(String value) {
        int st;
        int len = value.length();
        char[] val = value.toCharArray();
        for (st = 0; st < len && val[st] == '\n'; ++st) {
        }
        while (st < len && val[len - 1] == '\n') {
            --len;
        }
        return st > 0 || len < value.length() ? value.substring(st, len) : value;
    }

    public static Integer getRunPos(XWPFRun run) {
        List<XWPFRun> runs = ParagraphUtils.getRunList(run);
        for (int i = 0; i < runs.size(); ++i) {
            if (run != runs.get(i)) continue;
            return i;
        }
        return null;
    }

    private static List<XWPFRun> getRunList(XWPFRun run) {
        IRunBody parent = run.getParent();
        if (parent instanceof XWPFParagraph) {
            XWPFParagraph paragraph = (XWPFParagraph)parent;
            return paragraph.getRuns();
        }
        if (parent instanceof XWPFStructuredDocumentTagContent) {
            XWPFStructuredDocumentTagContent paragraph = (XWPFStructuredDocumentTagContent)parent;
            return paragraph.getRuns();
        }
        return new ArrayList<XWPFRun>();
    }

    public static boolean havePictures(XWPFParagraph paragraph) {
        List runs = paragraph.getRuns();
        for (XWPFRun run : runs) {
            if (!CollectionUtils.isNotEmpty((Collection)run.getEmbeddedPictures())) continue;
            return true;
        }
        return false;
    }

    public static boolean havePageBreak(XWPFParagraph paragraph) {
        List runs = paragraph.getRuns();
        for (XWPFRun run : runs) {
            if (!CollectionUtils.isNotEmpty((Collection)run.getCTR().getLastRenderedPageBreakList())) continue;
            return true;
        }
        return false;
    }

    public static boolean haveObject(XWPFParagraph paragraph) {
        List runs = paragraph.getRuns();
        for (XWPFRun run : runs) {
            if (!CollectionUtils.isNotEmpty((Collection)run.getCTR().getObjectList())) continue;
            return true;
        }
        return false;
    }
}

