/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.xwpf;

import com.deepoove.poi.util.ParagraphUtils;
import com.deepoove.poi.util.ReflectionUtils;
import com.deepoove.poi.xwpf.ParentContext;
import com.deepoove.poi.xwpf.XWPFParagraphWrapper;
import com.deepoove.poi.xwpf.XWPFSection;
import java.util.List;
import org.apache.poi.xwpf.usermodel.BodyElementType;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.IRunBody;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.xmlbeans.XmlCursor;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;

public interface BodyContainer
extends ParentContext {
    default public int getPosOfParagraphCTP(CTP ctp) {
        List bodyElements = this.getTarget().getBodyElements();
        for (int i = 0; i < bodyElements.size(); ++i) {
            IBodyElement current = (IBodyElement)bodyElements.get(i);
            if (current.getElementType() != BodyElementType.PARAGRAPH || !((XWPFParagraph)current).getCTP().equals(ctp)) continue;
            return i;
        }
        return -1;
    }

    default public int getPosOfParagraph(XWPFParagraph paragraph) {
        return this.getPosOfParagraphCTP(paragraph.getCTP());
    }

    default public List<IBodyElement> getBodyElements() {
        return (List)ReflectionUtils.getValue("bodyElements", this.getTarget());
    }

    public void removeBodyElement(int var1);

    default public XWPFParagraph insertNewParagraph(XmlCursor insertPostionCursor) {
        return this.getTarget().insertNewParagraph(insertPostionCursor);
    }

    default public XWPFParagraph insertNewParagraph(XWPFRun run) {
        XmlCursor cursor = ((XWPFParagraph)run.getParent()).getCTP().newCursor();
        return this.insertNewParagraph(cursor);
    }

    default public int getParaPos(XWPFParagraph paragraph) {
        List paragraphs = this.getTarget().getParagraphs();
        for (int i = 0; i < paragraphs.size(); ++i) {
            if (paragraphs.get(i) != paragraph) continue;
            return i;
        }
        return -1;
    }

    public void setParagraph(XWPFParagraph var1, int var2);

    public IBody getTarget();

    default public XWPFTable insertNewTbl(XmlCursor insertPostionCursor) {
        return this.getTarget().insertNewTbl(insertPostionCursor);
    }

    default public int getTablePos(XWPFTable table) {
        List tables = this.getTarget().getTables();
        for (int i = 0; i < tables.size(); ++i) {
            if (tables.get(i) != table) continue;
            return i;
        }
        return -1;
    }

    public void setTable(int var1, XWPFTable var2);

    default public void updateBodyElements(IBodyElement bodyElement, IBodyElement copy) {
        int pos = -1;
        List<IBodyElement> bodyElements = this.getBodyElements();
        for (int i = 0; i < bodyElements.size(); ++i) {
            if (bodyElements.get(i) != bodyElement) continue;
            pos = i;
        }
        if (-1 != pos) {
            bodyElements.set(pos, copy);
        }
    }

    public XWPFTable insertNewTable(XWPFRun var1, int var2, int var3);

    default public void clearPlaceholder(XWPFRun run) {
        this.clearPlaceholder(run, false);
    }

    default public void clearPlaceholder(XWPFRun run, boolean remove) {
        IRunBody parent = run.getParent();
        run.setText("", 0);
        if (parent instanceof XWPFParagraph) {
            if (remove) {
                new XWPFParagraphWrapper((XWPFParagraph)parent).removeRun(ParagraphUtils.getRunPos(run));
            }
            String paragraphText = ParagraphUtils.trimLine((XWPFParagraph)parent);
            boolean havePictures = ParagraphUtils.havePictures((XWPFParagraph)parent);
            boolean havePageBreak = ParagraphUtils.havePageBreak((XWPFParagraph)parent);
            boolean haveObject = ParagraphUtils.haveObject((XWPFParagraph)parent);
            if ("".equals(paragraphText) && !havePictures && !havePageBreak && !haveObject) {
                int pos = this.getPosOfParagraph((XWPFParagraph)parent);
                this.removeBodyElement(pos);
            }
        }
    }

    public XWPFSection closelySectPr(IBodyElement var1);

    public int elementPageWidth(IBodyElement var1);
}

