/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.policy;

import com.deepoove.poi.data.NumbericRenderData;
import com.deepoove.poi.data.PictureRenderData;
import com.deepoove.poi.data.RenderData;
import com.deepoove.poi.data.TextRenderData;
import com.deepoove.poi.data.style.Style;
import com.deepoove.poi.exception.RenderException;
import com.deepoove.poi.policy.AbstractRenderPolicy;
import com.deepoove.poi.policy.PictureRenderPolicy;
import com.deepoove.poi.policy.TextRenderPolicy;
import com.deepoove.poi.render.RenderContext;
import com.deepoove.poi.util.StyleUtils;
import com.deepoove.poi.xwpf.BodyContainer;
import com.deepoove.poi.xwpf.BodyContainerFactory;
import com.deepoove.poi.xwpf.NiceXWPFDocument;
import java.math.BigInteger;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;

public class NumbericRenderPolicy
extends AbstractRenderPolicy<NumbericRenderData> {
    @Override
    protected boolean validate(NumbericRenderData data) {
        return null != data && CollectionUtils.isNotEmpty(data.getNumbers());
    }

    @Override
    public void doRender(RenderContext<NumbericRenderData> context) throws Exception {
        Helper.renderNumberic(context.getRun(), context.getData());
    }

    @Override
    protected void afterRender(RenderContext<NumbericRenderData> context) {
        NumbericRenderPolicy.clearPlaceholder(context, true);
    }

    public static class Helper {
        public static void renderNumberic(XWPFRun run, NumbericRenderData numbericData) throws Exception {
            NiceXWPFDocument doc = (NiceXWPFDocument)run.getParent().getDocument();
            List<? extends RenderData> datas = numbericData.getNumbers();
            Style style = numbericData.getFmtStyle();
            BigInteger numID = doc.addNewNumbericId(numbericData.getNumFmt());
            BodyContainer bodyContainer = BodyContainerFactory.getBodyContainer(run);
            for (RenderData renderData : datas) {
                XWPFRun newRun = Helper.createRunLine(run, bodyContainer, style, numID);
                if (renderData instanceof PictureRenderData) {
                    PictureRenderPolicy.Helper.renderPicture(newRun, (PictureRenderData)renderData);
                    continue;
                }
                if (renderData instanceof TextRenderData) {
                    TextRenderPolicy.Helper.renderTextRun(newRun, renderData);
                    continue;
                }
                throw new RenderException("NumbericRender only support PictureRenderData and TextRenderData");
            }
        }

        private static XWPFRun createRunLine(XWPFRun run, BodyContainer bodyContainer, Style style, BigInteger numID) {
            XWPFParagraph paragraph = bodyContainer.insertNewParagraph(run);
            StyleUtils.styleParagraph(paragraph, style);
            paragraph.setNumID(numID);
            return paragraph.createRun();
        }
    }
}

