/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.policy.ref;

import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.policy.ref.OptionalTextPictureRefRenderPolicy;
import com.deepoove.poi.util.ByteUtils;
import com.deepoove.poi.util.ReflectionUtils;
import com.deepoove.poi.xwpf.NiceXWPFDocument;
import java.io.InputStream;
import java.util.List;
import org.apache.poi.xwpf.usermodel.XWPFFooter;
import org.apache.poi.xwpf.usermodel.XWPFHeader;
import org.apache.poi.xwpf.usermodel.XWPFHeaderFooter;
import org.apache.poi.xwpf.usermodel.XWPFPicture;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.openxmlformats.schemas.drawingml.x2006.main.CTBlip;
import org.openxmlformats.schemas.drawingml.x2006.main.CTBlipFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.picture.CTPicture;

public class ReplaceOptionalTextPictureRefRenderPolicy
extends OptionalTextPictureRefRenderPolicy {
    private final String optionalText;
    private byte[] data;
    private int format;

    public ReplaceOptionalTextPictureRefRenderPolicy(String optionalText, InputStream replaceStream, int fomart) {
        this(optionalText, ByteUtils.toByteArray(replaceStream), fomart);
    }

    public ReplaceOptionalTextPictureRefRenderPolicy(String optionalText, byte[] replaceData, int format) {
        this.optionalText = optionalText;
        this.data = replaceData;
        this.format = format;
    }

    @Override
    public String optionalText() {
        return this.optionalText;
    }

    @Override
    public void doRender(List<XWPFPicture> pictures, XWPFTemplate template) throws Exception {
        NiceXWPFDocument doc = template.getXWPFDocument();
        String docId = null;
        String hid = null;
        String fid = null;
        for (XWPFPicture t : pictures) {
            XWPFHeaderFooter headerFooter;
            this.logger.info("Replace the picture data for the reference object: {}", (Object)t);
            XWPFRun run = (XWPFRun)ReflectionUtils.getValue("run", t);
            if (run.getParent().getPart() instanceof XWPFHeader) {
                headerFooter = (XWPFHeaderFooter)run.getParent().getPart();
                this.setPictureReference(t, hid == null ? headerFooter.addPictureData(this.data, this.format) : hid);
                continue;
            }
            if (run.getParent().getPart() instanceof XWPFFooter) {
                headerFooter = (XWPFHeaderFooter)run.getParent().getPart();
                this.setPictureReference(t, fid == null ? headerFooter.addPictureData(this.data, this.format) : fid);
                continue;
            }
            this.setPictureReference(t, docId == null ? doc.addPictureData(this.data, this.format) : docId);
        }
    }

    private void setPictureReference(XWPFPicture t, String relationId) {
        CTPicture ctPic = t.getCTPicture();
        CTBlipFillProperties bill = ctPic.getBlipFill();
        CTBlip blip = bill.getBlip();
        blip.setEmbed(relationId);
    }
}

