/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.render.compute;

import com.deepoove.poi.config.Configure;
import com.deepoove.poi.render.compute.ELObjectRenderDataCompute;
import com.deepoove.poi.render.compute.RenderDataCompute;
import com.deepoove.poi.render.compute.RenderDataComputeFactory;
import com.deepoove.poi.render.compute.SpELRenderDataCompute;

public class DefaultRenderDataComputeFactory
implements RenderDataComputeFactory {
    private final Configure config;

    public DefaultRenderDataComputeFactory(Configure config) {
        this.config = config;
    }

    @Override
    public RenderDataCompute newCompute(Object model) {
        RenderDataCompute render = null;
        switch (this.config.getElMode()) {
            case SPEL_MODE: {
                render = new SpELRenderDataCompute(model);
                break;
            }
            case POI_TL_STICT_MODE: {
                render = new ELObjectRenderDataCompute(model, true);
                break;
            }
            default: {
                render = new ELObjectRenderDataCompute(model, false);
            }
        }
        return render;
    }
}

