/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.xwpf;

import com.deepoove.poi.util.ReflectionUtils;
import com.deepoove.poi.xwpf.BodyContainer;
import java.util.List;
import org.apache.poi.xwpf.usermodel.BodyElementType;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.XWPFHeaderFooter;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.XmlCursor;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHdrFtr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;

public class HeaderFooterBodyContainer
implements BodyContainer {
    XWPFHeaderFooter headerFooter;

    public HeaderFooterBodyContainer(XWPFHeaderFooter cell) {
        this.headerFooter = cell;
    }

    @Override
    public int getPosOfParagraphCTP(CTP startCtp) {
        List bodyElements = this.headerFooter.getBodyElements();
        for (int i = 0; i < bodyElements.size(); ++i) {
            IBodyElement current = (IBodyElement)bodyElements.get(i);
            if (current.getElementType() != BodyElementType.PARAGRAPH || !((XWPFParagraph)current).getCTP().equals(startCtp)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void removeBodyElement(int pos) {
        List<IBodyElement> bodyElements = this.getBodyElements();
        if (pos >= 0 && pos < bodyElements.size()) {
            BodyElementType type = bodyElements.get(pos).getElementType();
            if (type == BodyElementType.TABLE) {
                this.headerFooter.removeTable((XWPFTable)bodyElements.get(pos));
            }
            if (type == BodyElementType.PARAGRAPH) {
                this.headerFooter.removeParagraph((XWPFParagraph)bodyElements.get(pos));
            }
        }
    }

    @Override
    public int getPosOfParagraph(XWPFParagraph startParagraph) {
        return this.getPosOfParagraphCTP(startParagraph.getCTP());
    }

    @Override
    public List<IBodyElement> getBodyElements() {
        return (List)ReflectionUtils.getValue("bodyElements", this.headerFooter);
    }

    @Override
    public XWPFParagraph insertNewParagraph(XmlCursor insertPostionCursor) {
        return this.headerFooter.insertNewParagraph(insertPostionCursor);
    }

    @Override
    public int getParaPos(XWPFParagraph insertNewParagraph) {
        List paragraphs = this.headerFooter.getParagraphs();
        for (int i = 0; i < paragraphs.size(); ++i) {
            if (paragraphs.get(i) != insertNewParagraph) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void setParagraph(XWPFParagraph p, int paraPos) {
        List paragraphs = (List)ReflectionUtils.getValue("paragraphs", this.headerFooter);
        paragraphs.set(paraPos, p);
        CTHdrFtr ctTc = this.headerFooter._getHdrFtr();
        ctTc.setPArray(paraPos, p.getCTP());
    }

    @Override
    public IBody getTarget() {
        return this.headerFooter;
    }

    @Override
    public void updateBodyElements(IBodyElement insertNewParagraph, IBodyElement copy) {
        int pos = -1;
        List<IBodyElement> bodyElements = this.getBodyElements();
        for (int i = 0; i < bodyElements.size(); ++i) {
            if (bodyElements.get(i) != insertNewParagraph) continue;
            pos = i;
        }
        if (-1 != pos) {
            bodyElements.set(pos, copy);
        }
    }

    @Override
    public XWPFTable insertNewTbl(XmlCursor insertPostionCursor) {
        return this.headerFooter.insertNewTbl(insertPostionCursor);
    }

    @Override
    public int getTablePos(XWPFTable insertNewTbl) {
        List tables = this.headerFooter.getTables();
        for (int i = 0; i < tables.size(); ++i) {
            if (tables.get(i) != insertNewTbl) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void setTable(int pos, XWPFTable table) {
        List tables = (List)ReflectionUtils.getValue("tables", this.headerFooter);
        tables.set(pos, table);
        this.headerFooter._getHdrFtr().setTblArray(pos, table.getCTTbl());
    }

    @Override
    public XWPFTable insertNewTable(XWPFRun run, int row, int col) {
        int i;
        XmlCursor cursor = ((XWPFParagraph)run.getParent()).getCTP().newCursor();
        XWPFTable table = this.insertNewTbl(cursor);
        List rows = table.getRows();
        for (i = 0; i < rows.size(); ++i) {
            table.removeRow(i);
        }
        for (i = 0; i < row; ++i) {
            XWPFTableRow tabRow = table.getRow(i) == null ? table.createRow() : table.getRow(i);
            for (int k = 0; k < col; ++k) {
                if (tabRow.getCell(k) != null) continue;
                tabRow.createCell();
            }
        }
        return table;
    }
}

