/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache;

import java.util.List;
import net.oschina.j2cache.CacheBroadcastChannel;
import net.oschina.j2cache.CacheException;
import net.oschina.j2cache.CacheExpiredListener;
import net.oschina.j2cache.CacheFactory;
import net.oschina.j2cache.CacheObject;
import net.oschina.j2cache.broadcast.BroadcastType;
import net.oschina.j2cache.broadcast.JGroupBroadcastChannel;
import net.oschina.j2cache.broadcast.RedisBroadcastChannel;
import org.springframework.beans.factory.InitializingBean;

public abstract class CacheAbstractTemplate
implements InitializingBean {
    private String clusterName = "C_DEF";
    protected CacheFactory factory;
    private CacheBroadcastChannel broadcastChannel;
    private CacheExpiredListener listener;

    public abstract CacheObject get(String var1, String var2);

    public abstract void set(String var1, String var2, Object var3);

    public abstract void set(String var1, String var2, Object var3, Integer var4);

    public abstract void evict(String var1, String var2);

    public abstract void batchEvict(String var1, List var2);

    public abstract void clear(String var1);

    public abstract List keys(String var1);

    public void afterPropertiesSet() throws Exception {
        if (this.factory == null) {
            throw new CacheException("\u7f13\u5b58\u7684\u5de5\u5382\u7c7b\u5b9e\u4f8b\u4e0d\u80fd\u4e3anull.");
        }
        if (this.clusterName == null || "".equals(this.clusterName)) {
            this.clusterName = "C_DEF";
        }
        if (this.factory.isUseCluster()) {
            if (this.factory.getCacheBroadcast().equals((Object)BroadcastType.JGROUPS_MULTICAST)) {
                this.broadcastChannel = new JGroupBroadcastChannel(this.factory.getCache_jgroup_conf_file(), this.clusterName, this.factory);
            } else if (this.factory.getCacheBroadcast().equals((Object)BroadcastType.REDIS_PUBSUB)) {
                this.broadcastChannel = new RedisBroadcastChannel(this.clusterName, this.factory);
            }
        }
    }

    public void sendCmdBroadcast(byte optKey, String region, Object key) throws CacheException {
        if (this.broadcastChannel != null) {
            this.broadcastChannel.sendCmdBroadcast(optKey, region, key);
        }
    }

    public void setFactory(CacheFactory factory) {
        this.factory = factory;
    }

    public CacheBroadcastChannel getBroadcastChannel() {
        return this.broadcastChannel;
    }
}

