/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache;

import net.oschina.j2cache.Cache;
import net.oschina.j2cache.CacheExpiredListener;
import net.oschina.j2cache.CacheProvider;
import net.oschina.j2cache.broadcast.BroadcastType;
import net.oschina.j2cache.store.ehcache.EhCacheProvider;
import net.oschina.j2cache.store.redis.RedisCacheProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class CacheFactory
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(CacheFactory.class);
    private String cache_jgroup_conf_file = "/cache/cache/udp-newwork.xml";
    private String cache_ehcache_conf_file = "/conf/cache/ehcache.xml";
    private String cache_redis_conf_file = "/conf/cache/redis.properties";
    private boolean useCluster = true;
    private boolean openSecondCache = false;
    private BroadcastType cacheBroadcast;
    private CacheProvider provider_lv1;
    private CacheProvider provider_lv2;

    public CacheProvider getProvider(byte lvKey) {
        switch (lvKey) {
            case 1: {
                return this.provider_lv1;
            }
            case 2: {
                return this.provider_lv2;
            }
        }
        return this.provider_lv1;
    }

    public Cache getCache(byte lvKey, String regionName, boolean autoCreate, CacheExpiredListener listener) {
        return this.getProvider(lvKey).buildCache(regionName, autoCreate, listener);
    }

    public void afterPropertiesSet() throws Exception {
        if (this.openSecondCache) {
            Assert.notNull((Object)this.cache_redis_conf_file, (String)"\u4e8c\u7ea7\u7f13\u5b58\u5df2\u5f00\u542f\uff0c\u5176\u914d\u7f6e\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a null.");
        }
        if (this.useCluster) {
            if (this.cacheBroadcast == null) {
                throw new IllegalArgumentException("\u96c6\u7fa4\u6a21\u5f0f\u4e0b\uff0c\u5fc5\u987b\u8bbe\u7f6e\u7f13\u5b58\u7684 broadcast \u7c7b\u578b");
            }
            switch (this.cacheBroadcast) {
                case JGROUPS_MULTICAST: {
                    Assert.notNull((Object)this.cache_jgroup_conf_file, (String)"\u7ec4\u64ad\u7684\u7f51\u7edc\u914d\u7f6e\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a null.");
                    break;
                }
                case REDIS_PUBSUB: {
                    if (this.openSecondCache) break;
                    throw new IllegalArgumentException("\u672a\u5f00\u542f\u4e8c\u7ea7\u7f13\u5b58\u5b9e\u73b0\uff0c\u4e0d\u652f\u6301\u8be5 broadcast \u7c7b\u578b");
                }
                default: {
                    throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u5e7f\u64ad\u7c7b\u578b : " + (Object)((Object)this.cacheBroadcast));
                }
            }
        }
        Assert.notNull((Object)this.cache_ehcache_conf_file, (String)"\u4e00\u7ea7\u7f13\u5b58ehcache\u7684\u914d\u7f6e\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a null.");
        this.provider_lv1 = new EhCacheProvider();
        this.provider_lv1.start(this.cache_ehcache_conf_file);
        if (this.openSecondCache) {
            this.provider_lv2 = new RedisCacheProvider();
            this.provider_lv2.start(this.cache_redis_conf_file);
        }
        logger.info("\u7f13\u5b58\u521d\u59cb\u5316\u5b8c\u6210.");
    }

    public String getCache_jgroup_conf_file() {
        return this.cache_jgroup_conf_file;
    }

    public void setCache_jgroup_conf_file(String cache_jgroup_conf_file) {
        this.cache_jgroup_conf_file = cache_jgroup_conf_file;
    }

    public String getCache_ehcache_conf_file() {
        return this.cache_ehcache_conf_file;
    }

    public void setCache_ehcache_conf_file(String cache_ehcache_conf_file) {
        this.cache_ehcache_conf_file = cache_ehcache_conf_file;
    }

    public String getCache_redis_conf_file() {
        return this.cache_redis_conf_file;
    }

    public void setCache_redis_conf_file(String cache_redis_conf_file) {
        this.cache_redis_conf_file = cache_redis_conf_file;
    }

    public boolean isOpenSecondCache() {
        return this.openSecondCache;
    }

    public void setOpenSecondCache(boolean openSecondCache) {
        this.openSecondCache = openSecondCache;
    }

    public BroadcastType getCacheBroadcast() {
        return this.cacheBroadcast;
    }

    public void setCacheBroadcast(BroadcastType cacheBroadcast) {
        this.cacheBroadcast = cacheBroadcast;
    }

    public boolean isUseCluster() {
        return this.useCluster;
    }

    public void setUseCluster(boolean useCluster) {
        this.useCluster = useCluster;
    }
}

