/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache;

import java.util.List;
import net.oschina.j2cache.CacheAbstractTemplate;
import net.oschina.j2cache.CacheBox;
import net.oschina.j2cache.CacheExpiredListener;
import net.oschina.j2cache.CacheObject;
import net.oschina.j2cache.utils.StrExtUtils;

public class CacheTemplate
extends CacheAbstractTemplate {
    @Override
    public CacheObject get(String region, String key) {
        CacheObject co = new CacheObject();
        co.setRegion(region);
        co.setKey(key);
        if (!StrExtUtils.isNullOrEmpty(region) && !StrExtUtils.isNullOrEmpty(key)) {
            Object object = this.factory.getCache((byte)1, region, true, (CacheExpiredListener)((Object)this.getBroadcastChannel())).get(key);
            if (object == null && this.factory.isOpenSecondCache()) {
                object = this.factory.getCache((byte)2, region, true, null).get(key);
                co.setLv((byte)2);
            } else {
                co.setLv((byte)1);
            }
            if (object != null) {
                co.setUp((CacheBox)object);
            }
        }
        return co;
    }

    @Override
    public void set(String region, String key, Object value) {
        this.set(region, key, value, 0);
    }

    @Override
    public void set(String region, String key, Object value, Integer expired) {
        if (!StrExtUtils.isNullOrEmpty(region) && !StrExtUtils.isNullOrEmpty(key)) {
            if (value == null) {
                this.evict(region, key);
            } else {
                if (this.factory.isUseCluster()) {
                    this.sendCmdBroadcast((byte)1, region, key);
                }
                CacheBox cb = new CacheBox(value, expired);
                this.factory.getCache((byte)1, region, true, (CacheExpiredListener)((Object)this.getBroadcastChannel())).put(key, cb);
                if (this.factory.isOpenSecondCache()) {
                    this.factory.getCache((byte)2, region, true, null).put(key, cb);
                }
            }
        }
    }

    @Override
    public void evict(String region, String key) {
        this.factory.getCache((byte)1, region, true, (CacheExpiredListener)((Object)this.getBroadcastChannel())).evict(key);
        if (this.factory.isOpenSecondCache()) {
            this.factory.getCache((byte)2, region, true, null).evict(key);
        }
        if (this.factory.isUseCluster()) {
            this.sendCmdBroadcast((byte)1, region, key);
        }
    }

    @Override
    public void batchEvict(String region, List keys) {
        this.factory.getCache((byte)1, region, true, (CacheExpiredListener)((Object)this.getBroadcastChannel())).evict(keys);
        if (this.factory.isOpenSecondCache()) {
            this.factory.getCache((byte)2, region, true, null).evict(keys);
        }
        if (this.factory.isUseCluster()) {
            this.sendCmdBroadcast((byte)1, region, keys);
        }
    }

    @Override
    public void clear(String region) {
        this.factory.getCache((byte)1, region, true, (CacheExpiredListener)((Object)this.getBroadcastChannel())).clear();
        if (this.factory.isOpenSecondCache()) {
            this.factory.getCache((byte)2, region, true, null).clear();
        }
    }

    @Override
    public List keys(String region) {
        return this.factory.getCache((byte)1, region, true, (CacheExpiredListener)((Object)this.getBroadcastChannel())).keys();
    }
}

