/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.broadcast;

import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Command {
    private static final Logger logger = LoggerFactory.getLogger(Command.class);
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final byte operator;
    private final String region;
    private final String key;

    public Command(byte operator, String region, Object key) {
        this.operator = operator;
        this.region = region;
        this.key = String.valueOf(key);
    }

    public byte getOperator() {
        return this.operator;
    }

    public String getRegion() {
        return this.region;
    }

    public Object getKey() {
        return this.key;
    }

    public byte[] toBuff() {
        byte[] kBuff = this.key.getBytes(UTF_8);
        byte[] rBytes = this.region.getBytes(UTF_8);
        int rLen = rBytes.length;
        int kLen = kBuff.length;
        byte[] buff = new byte[5 + rLen + kLen];
        int idx = 0;
        buff[idx] = this.operator;
        buff[++idx] = (byte)(rLen >> 8);
        buff[++idx] = (byte)(rLen & 0xFF);
        System.arraycopy(rBytes, 0, buff, ++idx, rLen);
        idx += rLen;
        buff[idx++] = (byte)(kLen >> 8);
        buff[idx++] = (byte)(kLen & 0xFF);
        System.arraycopy(kBuff, 0, buff, idx, kLen);
        return buff;
    }

    public static Command parse(byte[] buff) {
        Command cmd = null;
        try {
            int idx = 0;
            byte operator = buff[idx];
            int rLen = buff[++idx] << 8;
            if ((rLen += buff[++idx]) > 0) {
                String region = new String(buff, ++idx, rLen, UTF_8);
                idx += rLen;
                int kLen = buff[idx++] << 8;
                if ((kLen += buff[idx++]) > 0) {
                    byte[] kBuff = new byte[kLen];
                    System.arraycopy(buff, idx, kBuff, 0, kLen);
                    String key = new String(kBuff, UTF_8);
                    cmd = new Command(operator, region, key);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u7f13\u5b58JGroup\u5e7f\u64ad\u4e8b\u4ef6\u6d88\u606f\u4e3aCommand\u5bf9\u8c61\u5931\u8d25.", (Throwable)e);
        }
        return cmd;
    }
}

