/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.broadcast;

import java.net.URL;
import java.util.List;
import net.oschina.j2cache.CacheBroadcastChannel;
import net.oschina.j2cache.CacheException;
import net.oschina.j2cache.CacheExpiredListener;
import net.oschina.j2cache.CacheFactory;
import net.oschina.j2cache.broadcast.BroadcastType;
import net.oschina.j2cache.broadcast.Command;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.ReceiverAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JGroupBroadcastChannel
extends ReceiverAdapter
implements CacheExpiredListener,
CacheBroadcastChannel {
    private static final Logger logger = LoggerFactory.getLogger(JGroupBroadcastChannel.class);
    private JChannel channel;
    private CacheFactory factory;

    public JGroupBroadcastChannel(String confFilePath, String clusterName, CacheFactory factory) throws Exception {
        if (confFilePath == null || "".equals(confFilePath)) {
            throw new CacheException(String.format("\u7ec4\u64ad\u7684\u7f51\u7edc\u914d\u7f6e\u6587\u4ef6\u52a0\u8f7d\u5931\u8d25: %s", confFilePath));
        }
        long startTime = System.currentTimeMillis();
        URL networkXML = this.getClass().getResource(confFilePath);
        if (networkXML == null) {
            networkXML = this.getClass().getClassLoader().getParent().getResource(confFilePath);
        }
        if (networkXML == null) {
            throw new CacheException(String.format("\u7ec4\u64ad\u7684\u7f51\u7edc\u914d\u7f6e\u6587\u4ef6\u52a0\u8f7d\u5931\u8d25: %s", confFilePath));
        }
        try {
            this.channel = new JChannel(networkXML);
        }
        catch (Exception e) {
            throw new CacheException("Cache JGroup network start fail.", e);
        }
        this.channel.setReceiver((Receiver)this);
        this.channel.connect(clusterName);
        this.factory = factory;
        logger.info("\u6210\u529f\u521b\u5efa\u7f13\u5b58\u5e7f\u64ad\u901a\u9053(JGroup Connection to channel) : {}, cluster name is : {}, \u8017\u65f6 : {} ms", new Object[]{this.channel.getAddress().toString(), clusterName, System.currentTimeMillis() - startTime});
    }

    public void receive(Message msg) {
        byte[] buff = msg.getBuffer();
        if (buff.length < 1) {
            logger.warn("Cache JGroup Message is empty.");
            return;
        }
        if (msg.getSrc().equals(this.channel.getAddress())) {
            return;
        }
        try {
            Command cmd = Command.parse(buff);
            if (cmd == null) {
                return;
            }
            switch (cmd.getOperator()) {
                case 1: {
                    this.onDeleteCacheKey(cmd.getRegion(), cmd.getKey());
                    break;
                }
                default: {
                    logger.warn("\u5c1a\u672a\u652f\u6301\u7684\u6d88\u606f\u7c7b\u578b : {}", (Object)cmd.getOperator());
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error("\u672a\u80fd\u6b63\u786e\u5904\u7406\u63a5\u6536\u5230\u7684JGroup\u6d88\u606f.", (Throwable)e);
        }
    }

    @Override
    public void notifyElementExpired(String region, Object key) {
        logger.debug("\u7f13\u5b58\u6570\u636e\u8fc7\u671f -> region:{}, key:{}", (Object)region, key);
        if (this.factory.isOpenSecondCache()) {
            if (key instanceof List) {
                this.factory.getProvider((byte)2).buildCache(region, false, null).evict((List)key);
            } else {
                this.factory.getProvider((byte)2).buildCache(region, false, null).evict(key);
            }
        }
        if (this.factory.isUseCluster() && BroadcastType.JGROUPS_MULTICAST.equals((Object)this.factory.getCacheBroadcast())) {
            this.sendCmdBroadcast((byte)1, region, key);
        }
    }

    @Override
    public void onDeleteCacheKey(String region, Object key) {
        if (key instanceof List) {
            this.factory.getProvider((byte)1).buildCache(region, true, this).evict((List)key);
        } else {
            this.factory.getProvider((byte)1).buildCache(region, true, this).evict(key);
        }
    }

    @Override
    public void sendCmdBroadcast(byte optKey, String region, Object key) throws CacheException {
        Command cmd = new Command(optKey, region, key);
        Message msg = new Message(null, null, cmd.toBuff());
        try {
            this.channel.send(msg);
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001 \u4ee3\u7801\u4e3a [{}] \u7684JGroup\u4e8b\u4ef6\u6d88\u606f\u5931\u8d25 -> region:{}, key:{}", new Object[]{optKey, region, key, e});
        }
    }
}

