/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.broadcast;

import java.util.List;
import net.oschina.j2cache.CacheBroadcastChannel;
import net.oschina.j2cache.CacheException;
import net.oschina.j2cache.CacheExpiredListener;
import net.oschina.j2cache.CacheFactory;
import net.oschina.j2cache.broadcast.BroadcastType;
import net.oschina.j2cache.broadcast.Command;
import net.oschina.j2cache.store.redis.RedisCacheProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.BinaryJedisPubSub;
import redis.clients.jedis.Jedis;
import redis.clients.util.SafeEncoder;

public class RedisBroadcastChannel
extends BinaryJedisPubSub
implements CacheExpiredListener,
CacheBroadcastChannel {
    private static final Logger logger = LoggerFactory.getLogger(RedisBroadcastChannel.class);
    private CacheFactory factory;
    private String clusterName;
    private final Thread threadSubscribe;

    public RedisBroadcastChannel(final String clusterName, CacheFactory factory) {
        this.factory = factory;
        this.clusterName = clusterName;
        try {
            long startTime = System.currentTimeMillis();
            this.threadSubscribe = new Thread(new Runnable(){

                @Override
                public void run() {
                    Jedis jedis = RedisCacheProvider.getResource();
                    jedis.subscribe((BinaryJedisPubSub)RedisBroadcastChannel.this, (byte[][])new byte[][]{SafeEncoder.encode((String)clusterName)});
                    RedisCacheProvider.returnResource(jedis);
                }
            });
            this.threadSubscribe.start();
            logger.info("\u6210\u529f\u521b\u5efa\u7f13\u5b58\u5e7f\u64ad\u901a\u9053(Redis pub/sub) : {}, \u8017\u65f6 : {}", (Object)clusterName, (Object)(System.currentTimeMillis() - startTime));
        }
        catch (Exception e) {
            throw new CacheException("\u521d\u59cb\u5316Redis Subscribe\u7ebf\u7a0b\u5931\u8d25.", e);
        }
    }

    @Override
    public void onDeleteCacheKey(String region, Object key) throws CacheException {
        if (key instanceof List) {
            this.factory.getProvider((byte)1).buildCache(region, true, this).evict((List)key);
        } else {
            this.factory.getProvider((byte)1).buildCache(region, true, this).evict(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendCmdBroadcast(byte optKey, String region, Object key) throws CacheException {
        Command cmd = new Command(optKey, region, key);
        Jedis jedis = RedisCacheProvider.getResource();
        try {
            jedis.publish(SafeEncoder.encode((String)this.clusterName), cmd.toBuff());
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001 \u4ee3\u7801\u4e3a [{}] \u7684 Redis Pub/Sub \u4e8b\u4ef6\u6d88\u606f\u5931\u8d25 -> region:{}, key:{}", new Object[]{optKey, region, key, e});
        }
        finally {
            RedisCacheProvider.returnResource(jedis);
        }
    }

    @Override
    public void notifyElementExpired(String region, Object key) {
        logger.debug("\u7f13\u5b58\u6570\u636e\u8fc7\u671f -> region:{}, key:{}", (Object)region, key);
        if (this.factory.isOpenSecondCache()) {
            if (key instanceof List) {
                this.factory.getProvider((byte)2).buildCache(region, false, null).evict((List)key);
            } else {
                this.factory.getProvider((byte)2).buildCache(region, false, null).evict(key);
            }
        }
        if (this.factory.isUseCluster() && BroadcastType.REDIS_PUBSUB.equals((Object)this.factory.getCacheBroadcast())) {
            this.sendCmdBroadcast((byte)1, region, key);
        }
    }

    public void onMessage(byte[] channel, byte[] message) {
        if (message == null || message.length <= 0) {
            logger.warn("Redis subscribe message is empty!");
            return;
        }
        try {
            Command cmd = Command.parse(message);
            if (cmd == null) {
                return;
            }
            switch (cmd.getOperator()) {
                case 1: {
                    this.onDeleteCacheKey(cmd.getRegion(), cmd.getKey());
                    break;
                }
                default: {
                    logger.warn("\u5c1a\u672a\u652f\u6301\u7684\u6d88\u606f\u7c7b\u578b : {}", (Object)cmd.getOperator());
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error("\u672a\u80fd\u6b63\u786e\u5904\u7406\u63a5\u6536\u5230\u7684JGroup\u6d88\u606f.", (Throwable)e);
        }
    }
}

