/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.serializer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.oschina.j2cache.serializer.Serializer;
import net.oschina.j2cache.serializer.SerializerTools;
import org.nustaq.serialization.FSTConfiguration;
import org.nustaq.serialization.FSTObjectInput;
import org.nustaq.serialization.FSTObjectOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FstSerializer<T>
implements Serializer<T> {
    private static final Logger log = LoggerFactory.getLogger(FstSerializer.class);
    private static final FSTConfiguration conf = FSTConfiguration.createDefaultConfiguration();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] serialize(T value) {
        if (value == null) {
            return EMPTY_BYTES;
        }
        ByteArrayOutputStream os = null;
        try {
            os = new ByteArrayOutputStream();
            FSTObjectOutput oos = conf.getObjectOutput((OutputStream)os);
            oos.writeObject(value);
            oos.flush();
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            log.warn("\u5e8f\u5217\u5316\u5931\u8d25, value = {}", value, (Object)e);
            byte[] byArray = EMPTY_BYTES;
            return byArray;
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException e) {
                log.warn("\u5e8f\u5217\u5316\u5931\u8d25, value = {}", value, (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T deserialize(byte[] bytes) {
        if (SerializerTools.isEmpty(bytes)) {
            return null;
        }
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(bytes);
            FSTObjectInput ois = conf.getObjectInput((InputStream)is);
            Object object = ois.readObject();
            return (T)object;
        }
        catch (Exception e) {
            log.warn("\u53cd\u5e8f\u5217\u5316 bytes \u5931\u8d25.", (Throwable)e);
            T t = null;
            return t;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                log.warn("\u53cd\u5e8f\u5217\u5316 bytes \u5931\u8d25.", (Throwable)e);
            }
        }
    }
}

